/**!
 * https://github.com/repo-utils/giturl
 * 
 * giturl - lib/giturl.js
 *
 * Copyright(c) 2014
 * MIT Licensed
 *
 * Authors:
 *   fengmk2 <fengmk2@gmail.com> (http://fengmk2.github.com)
 */

"use strict";

/**
 * Module dependencies.
 */

// host[:/]n1/n2
var RE = /^([^:\/]+)[:\/](.+)$/i;

var HTTPS_HOSTS = {
  'github.wdf.sap.corp': 1,
  'github.com': 1,
  'gitcafe.com': 1,
  'gist.github.com': 1,
};

var parseGitUrl = function parse(sourceURL) {
  if (!sourceURL || typeof sourceURL !== 'string') {
    return '';
  }

  var url = sourceURL;
  if (url.indexOf('@') >= 0) {
    url = url.replace(/^[^@]+@/, '');    // git@ || https://jpillora@ => ""
  }
  url = url.replace(/^\w+:\/\//, '')    // git:// => ""
    .replace(/\.git$/, '');             // .git => ""
  var item = RE.exec(url);
  if (!item) {
    return sourceURL;
  }

  var host = item[1];
  var protocol = HTTPS_HOSTS[host] ? 'https' : 'http';

  // p1/p2/.../pn[.xxx]
  var slug = item[2].split('/', 2).join('/');
  return { url : protocol + '://' + host + '/' + slug, slug : slug };
};
