(function() {

  'use strict';

  window.DAGRE_D3_HELPER = (function() {
    
    // http://stackoverflow.com/questions/10973339/modifying-svg-attributes-with-javascript-has-no-effect
    ['preserveAspectRatio', 'viewBox'].forEach(function(k) {
      // jQuery converts the attribute name to lowercase before
      // looking for the hook. 
      $.attrHooks[k.toLowerCase()] = {
        set: function(el, value) {
          if (value) {
            el.setAttribute(k, value);
          } else {
            el.removeAttribute(k, value);
          }
          return true;
        },
        get: function(el) {
          return el.getAttribute(k);
        },
      };
    });
    
    // wire graph to table 
    function wireGraph2Table(dagId) {

      $('svg[data-id="'+dagId+'"] g.node' )
      .mouseenter(function() { 
        var nodeId = $(this).attr('id');
        if (nodeId) {
          var $tr = $('table.table[data-id="'+dagId+'"] tr[data-id="'+nodeId+'"]');
          $tr.addClass('HOVER');
        }
      }).on('click', function() {
        var nodeId = $(this).attr('id');
        if (nodeId) {
          var $a= $('table.table[data-id="'+dagId+'"] tr[data-id="'+nodeId+'"] td .travis.trigger a');
          $a.trigger('click');
        }
      }).mouseleave(function() {
        var nodeId = $(this).attr('id');
        if (nodeId) {
          var $tr = $('table.table[data-id="'+dagId+'"] tr[data-id="'+nodeId+'"]');
          $tr.removeClass('HOVER');
        }
      });
    }

    var putTheStuffMan = function(nodeId, remove, add) {
      $('g.node#' + nodeId).removeClass(remove).addClass(add);
    };
    
    var renderGraph = function(dag, dagSvgElement, shorten_index) {
      if (typeof dag === "undefined" || typeof dag.nodes === "undefined") {
        return;
      }
      
      // clone dag to prevent angular infinite loop on $digest
      var dagClone = $.extend(true, {}, dag);
      

      // grab first child g element
      var outerSvgGroupElement = dagSvgElement.find('svg').children('g').get(0);
      $(outerSvgGroupElement).empty();
      
      // set up an SVG group so that we can translate the final graph.
      var innerSvgGroupElement = d3.select(outerSvgGroupElement).append("g");

      var createGraph = function(dag) {
        var dagreD3graph = new dagreD3.graphlib.Graph({
          compound : true
        }).setGraph({}).setDefaultEdgeLabel(function() {
          return {};
        });

        dag.nodes.forEach(function(node) {

          if (typeof shorten_index !== "undefined") {
            if (shorten_index == 0) {
              node.value.label = node.value.labelShort;
            } else if (shorten_index == 1) {
              node.value.label = node.value.labelMedium;
            } else {
              node.value.label = node.value.labelFull;
            }
          }

          if (node.parent) {
            dagreD3graph.setParent(node.id, node.parent);
          }
          dagreD3graph.setNode(node.id, node.value);
        });

        dag.links.forEach(function(link) {
          dagreD3graph.setEdge(link.u, link.v, link.value);
        });

        return dagreD3graph;
      };

      var dagreD3graph = createGraph(dagClone);

      dagreD3graph.nodes().forEach(function(nodeId) {
        var node = dagreD3graph.node(nodeId);
        node.id = nodeId;
        // round the corners of the nodes
        node.rx = node.ry = 8;
      });

      var localNodeMap = {};
      $.each(dagClone.nodes, function(index, node) {
        localNodeMap[node.id] = node;
      });

      // create the renderer
      var render = new dagreD3.render();

      // run the renderer; this is what draws the final graph.
      render(innerSvgGroupElement, dagreD3graph);

      dagreD3graph.nodes().forEach(function(nodeId) {
        var node = localNodeMap[nodeId];
        var $node = $('g.node#' + nodeId);
        $node.attr('name', node.value.label);
        $node.addClass(localNodeMap[nodeId].state);
      });
      
      resizeGraph(dagreD3graph, dagSvgElement);
      
      wireGraph2Table(dag.name);
      
      return dagreD3graph;
    };

    
    var resizeGraph = function(dagreD3graph, dagSvgElement) {
      if (typeof dagreD3graph === "undefined") {
        return;
      }
      // grab elements
      var $svgElement            = dagSvgElement.find('svg');
      var $svgParent             = $svgElement.parent();
      var $svgParentParent       = $svgParent.parent();
      var $svgParentParentParent = $svgParentParent.parent();
      var outerSvgGroupElement   = $svgElement.children('g').get(0);
      var innerSvgGroupElement   = $svgElement.children('g').children('g').get(0);
      var d3outerSvgGroupElement = d3.select(outerSvgGroupElement);
      var d3innerSvgGroupElement = d3.select(innerSvgGroupElement);
      
      if ($svgParent.width() == 0) {
        return;
      }
      
      $svgParentParent.css( {
        position : "absolute",
        width    : $svgParentParentParent.width()+"px",
      });
      var horzMargin = 20;
      
      $svgParent.css({
        position : "relative",
        left     : -Math.ceil($("body .container").offset().left - horzMargin)+"px",
        top      : "0",
        width    : Math.ceil($("body" ).width() - (3*horzMargin) )+"px",
        height   : "auto",
      });
      
      // MUST READ : http://www.justinmccandless.com/demos/viewbox/index.html
      // set margins and center the thing
      var viewbox = {
          x      : -(($svgParent.width()-dagreD3graph.graph().width) / 2),
          y      : -(horzMargin),
          width  : Math.max(100, $svgParent.width()-(2*horzMargin)),
          height : Math.max(100, dagreD3graph.graph().height + (2*horzMargin)),
      }
      var viewboxAsString = _.map(viewbox, function(value, key){ return Math.ceil(value); }).join(' ');
      $svgElement.attr({
        width               : "100%",
        height              : "100%",
        viewBox             : viewboxAsString,
        preserveAspectRatio : "xMidYMin meet",
      });
      
      var setParentHeight = function(scale) {
        var h         = scale * dagreD3graph.graph().height;
        var newHeight = Math.ceil(Math.max(h, 100));
        
        $svgParentParentParent.height((newHeight + parseInt($svgParentParent.css('padding-top'))+ parseInt($svgParentParent.css('padding-bottom'))) + "px");
        $svgParent.height(newHeight + "px");
      }
      
      var scale = 1;
      setParentHeight(scale);

      // setup zoom
      d3.select(dagSvgElement.get(0)).call(d3.behavior.zoom().on('zoom', function() {
        d3innerSvgGroupElement.attr({
          'transform' : 'translate(' + d3.event.translate + ') scale(' + d3.event.scale + ')'
        });
        
        if (d3.event.scale != scale) {
          setParentHeight(d3.event.scale);
          scale = d3.event.scale;
        }
      }));
    };
    
    return {
        renderGraph : renderGraph,
        resizeGraph : resizeGraph,
        putTheStuffMan : putTheStuffMan
    };
  })();
})();
