<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><t:layout jsmodules="angular moment handlebars">

<script id="handlebars_messages" type="text/x-handlebars-template"><ul style=" list-style-type: none; padding:0;">
  {{#each this}}{{#each this}}<li>
    <strong>{{@key}}</strong> {{this}}
  </li>{{/each}}{{/each}}</ul></script>

  <style>
    .toprightfloatingtoolbar {
      float:right; 
      white-space: nowrap; 
      overflow: hidden;
    }
    ul {
      list-style-type: none;
    }
    span#back_to_index {
      white-space: nowrap; 
      overflow:hidden;
    }
  </style>
  
  <div>
    <span class="toprightfloatingtoolbar" style="font-size:larger">
      <c:if test="${not empty pageContext.request.remoteUser}">
      <a href="<c:url value='/modules/dagr/'/>"           title="show dag(s)"><i class="fa fa-paw"></i></i></a>
      </c:if>
      <a href="<c:url value='/modules/dagr/how-to.jsp'/>" title="how-to"     ><i class="fa fa-question-circle"></i></a>
    </span>

    <span id="back_to_index" class="alert alert-info" style="display: inline-block;">
      <span class="label label-info">info</span>
      <c:if test="${not empty pageContext.request.remoteUser}">
      <span">click the <a href="<c:url value='/dagr-api/v1/dags/'/>">top right <i class="fa fa-paw"></i> icon</a> to display selected dag(s)</span>
      </c:if>
      <c:if test="${empty pageContext.request.remoteUser}">
      <span">click on a dag</span>
      </c:if>
    </span>
  </div>

  <div class="btn-group btn-group-md" role="group" aria-label="..."">
    <a type="button" class="btn btn-default" href='<c:url value="/stnemucod/html/dags"/>' target = "_dags">DAGs directory</a>

    <button id="reload" type="button" class="btn btn-default">
      <span>reload <img id="ajaxLoading" src="<c:url value='/assets/images/animated_orange_refresh_22.png'/>" style="height:14px; width:auto;"> DAGs</span>
    </button>
  </div>

  <div id="messages" style="padding: 1em 0 0 0;"></div>
  <div  id="alert" class="alert alert-dismissable" style="display:none; ">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  </div>

  <div ng-app="ngAppDAGs" class="row">
    <h2 class="col-lg-12">all DAGs</h2>
    <div ng-controller="DAGsCtrl">
      <ul class="unstyled col-lg-8">
        <li ng-repeat="dag in dags| orderBy:'name'" style="border-bottom: 1px dashed #999;">
          <c:if test="${not empty pageContext.request.remoteUser}">
          <input type="checkbox" ng-model="dag.subscribed" ng-change="change()"/>
          </c:if>
          <a href="<c:url value='/dagr-api/v1/dags/'/>{{dag.key}}">
            {{dag.name}}
          </a>
        </li>
      </ul>
    </div>
  </div>

</t:layout>

<script src='<c:url value="/modules/dagr/scripts/reload-dags.js"/>' ></script>

<script type="text/javascript">

angular.module('ngAppDAGs', ['angular-loading-bar'])
.config(function(cfpLoadingBarProvider) {
  cfpLoadingBarProvider.includeSpinner = true;
})
.controller( 'DAGsCtrl',

  function($scope, $http) {
    $scope.dags   = [];
    
    var load = function(){
      $http({
          method: 'GET',
          url: "<c:url value='/dagr-api/v1/dags' />",
        }).success(function(data, status, headers, config) {
          $scope.dags = data;
        }).error(function(data, status, headers, config) {
          $scope.dags = [];
      });
    }
    
    load();

    dagrReload('<c:url value="/"/>', function() {
      load();
    });

    $scope.change = function() {
        $http({
            method: this.dag.subscribed ? 'POST': 'DELETE',
            url: "<c:url value='/dagr-api/v1/dags/subscription/' />"+this.dag.key
        });
    };
  }
);

</script>
