;(function(){

  angular.module('dagsApplication', ['ui.bootstrap', 'restangular', 'angular-loading-bar', 'LocalStorageModule', 'angular-websocket', 'humanReadableSnapshots']);
  
  /////////////////////////////////////////////////////////////////////////////
  // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
  function tryParseJSON(hypotheticalJSON){
    try {
        var o = JSON.parse(hypotheticalJSON);

        // Handle non-exception-throwing cases:
        // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
        // but... JSON.parse(null) returns 'null', and typeof null === "object", 
        // so we must check for that, too.
        if (o && typeof o === "object" && o !== null) {
            return o;
        }
    } catch (e) { 
    }

    return false;
  };

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').config(function(RestangularProvider) {
    RestangularProvider.setBaseUrl(Geppaequo.contextPath + 'dagr-api/v1');
  });
  
  // second Restangular service that uses aether-api
  angular.module('dagsApplication').factory('AetherRestangular', function(Restangular) {
    return Restangular.withConfig(function(RestangularConfigurer) {
      RestangularConfigurer.setBaseUrl(Geppaequo.contextPath + 'aether-api/v1');
    });
  });  
  
  // hird Restangular service that uses garance-api
  angular.module('dagsApplication').factory('GaranceRestangular', function(Restangular) {
    return Restangular.withConfig(function(RestangularConfigurer) {
      RestangularConfigurer.setBaseUrl(Geppaequo.contextPath + 'garance-api/v1');
    });
  });  
  
  angular.module('dagsApplication').config(function (localStorageServiceProvider) {
    localStorageServiceProvider
      .setPrefix('dagr');
  });  
  
  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dagTopological', [function(){
    
    var controller = ['$scope', function($scope) {
      
      $scope.mouseenter = function(dagId) {
        var $node = $('g.node#'+dagId);
        $node.addClass('HOVER');
      };
      
      $scope.mouseleave = function(dagId) {
        var $node = $('g.node#'+dagId);
        $node.removeClass('HOVER');
      };
      
    }];
    
    return {
      restrict     : 'E',
      templateUrl  : Geppaequo.contextPath + 'modules/dagr/templates/dag-topological.html',
      controller   : controller,
      controllerAs : 'ctrl',
    };
  }]);

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dagSvg', [function(){
    
    function link(scope, element, attrs) {
      scope.$watch('dag', function () {
        if (scope.dag.name) {
          scope.g = DAGRE_D3_HELPER.renderGraph(scope.dag, element, scope.shorten_index);
        }
      }, true);

      scope.$watch('shorten_index', function (newValue, oldValue, scope) {
        DAGRE_D3_HELPER.renderGraph(scope.dag, element, newValue);
      }, true);

      scope.$watch('dagInfo.active', function (newValue, oldValue, scope) {
        if (newValue) {
          // cf. http://stackoverflow.com/questions/12304291/angularjs-how-to-run-additional-code-after-angularjs-has-rendered-a-template
          scope.$evalAsync(function() { DAGRE_D3_HELPER.resizeGraph(scope.g, element); } );
        }
      }, true);
    }
    
    return {
      restrict    : 'E',
      templateUrl : Geppaequo.contextPath + 'modules/dagr/templates/dag-svg.html',
      link        : link,
    };
  }]);
  
  /////////////////////////////////////////////////////////////////////////////
  // cf. http://jsfiddle.net/jaredwilli/SfJ8c/
  angular.module('dagsApplication').directive('resize', function ($window) {
    return function (scope, element) {
        var w = angular.element($window);
        scope.getWindowDimensions = function () {
            return {
              'h': w.height(),
              'w': w.width()
            };
        };
        scope.$watch(scope.getWindowDimensions, function (newValue, oldValue) {
          // not used, I know; maybe should be passed as parameter of the resizeGraph ?
          scope.windowHeight = newValue.h;
          scope.windowWidth  = newValue.w;

          if (scope.dagInfo.active) {
            DAGRE_D3_HELPER.resizeGraph(scope.g, element);
          }
        }, true);

        w.bind('resize', function () {
            scope.$apply();
        });
    }
  });
  
  /////////////////////////////////////////////////////////////////////////////
  angular.module('humanReadableSnapshots', []).filter('humanreadable', function($sce) {
    return function(input, str) {

      var ret = (input || '').toString();
      
      var array = ret.split('-');
      if (array.length > 2) {
        var date = moment(array[array.length-2], "YYYYMMDD.HHmmss");
        if (date.isValid()) {
          ret = date.format('YYYY-MM-DD HH:mm');
        }
      }
      return $sce.trustAsHtml(ret);
    };
  });  
  
})();

