;(function(){
  
  /////////////////////////////////////////////////////////////////////////////
  // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
  function tryParseJSON(hypotheticalJSON){
    try {
        var o = JSON.parse(hypotheticalJSON);

        // Handle non-exception-throwing cases:
        // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
        // but... JSON.parse(null) returns 'null', and typeof null === "object", 
        // so we must check for that, too.
        if (o && typeof o === "object" && o !== null) {
            return o;
        }
    } catch (e) { 
    }

    return false;
  };

  ///////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dagWebsocket', ['$websocket', function($websocket){
    
    var controller = ['$scope', function ($scope) {
      // Open a WebSocket connection
      var url  = $scope.jevaispasmefairechier + 'patata';
      
      // window.log("opening dag websocket from", url);
      
      var dagWebsocketDataStream = $websocket(url);

      $scope.collection = [];

      dagWebsocketDataStream.onClose(function() {
        // window.log('closing dag websocket');
        dagWebsocketDataStream = null;
      });

      dagWebsocketDataStream.onError(function() {
        // window.log('error in dag websocket');
        dagWebsocketDataStream = null;
      });

      dagWebsocketDataStream.onMessage(function(atmosphereMessage) {
        
        window.log(atmosphereMessage);
        
        if (atmosphereMessage.type == "message" && atmosphereMessage.data == 'X') {
          window.log('received heartbeat');
          return;
        }

        var message = atmosphereMessage.data;
        var parsed = tryParseJSON(message)
        if (typeof parsed         !== "undefined" && parsed         != null &&
            typeof parsed.node    !== "undefined" && parsed.node    != null &&
            typeof parsed.node.id !== "undefined" && parsed.node.id != null) {
              
          DAGRE_D3_HELPER.putTheStuffMan(parsed.node.id, $scope.gimmethestuff, parsed.node.state);
          
          // the dag we are enclosed in may not have been yet initialized (e.g. hidden tab), $scope.nodeMap will not be here
          if (typeof $scope.nodeMap !== "undefined" && $scope.nodeMap != null) {
          
            var node = $scope.nodeMap[parsed.node.id];
            
            if (typeof node !== "undefined" && node != null) {
            
              // window.log("cleaner", parsed.node.cleaner, "current", parsed.node.state, "previous", node.state );
              
              if (parsed.node.state == 'BEING_CLEANED' && node.state != 'BEING_CLEANED') {
                node.onCleaningStarted(parsed.node.cleaner);
              }
              if (parsed.node.state != node.state) {
                node.state = parsed.node.state;
              }
              
              if (parsed.node.state == "CLEAN") { // no need to refresh snapshot if not clean
                node.onCleaningStopped();
                node.refreshSnapshot();
              }
            }
          }

          $scope.collection.push(parsed);
        } else {
          $scope.collection.push(message);
        }
      }); // dagWebsocketDataStream.onMessage
      
      var myTimer    = null;
      var states     = $scope.gimmethestuff.split(' ');;
      var stateIndex = 0;
      
      $scope.startSendingRandomStateChanges = function() {
        if (myTimer == null) {
          myTimer = setInterval(function() {
            var nodes = $scope.topological;
            
            var node = nodes[Math.floor(Math.random()*nodes.length)];

            var $element = $('table.table > tbody > tr[data-id='+node.id+'] > td .building span'); 
            $element.text(new Date());
            if (dagWebsocketDataStream) {
              dagWebsocketDataStream.send(JSON.stringify({node:{id: node.id, name: node.name, state: states[stateIndex%states.length]}}));
            }
            stateIndex = stateIndex + 1;

          }, 500);
        }
      }
      
      $scope.stopSendingRandomStateChanges = function() {
        if (myTimer != null) {
            clearInterval(myTimer);
            myTimer = null;
        }
        $scope.collection = [];
      }
      
    }]; // end of controller def
    
    return {
      restrict    : 'E',
      templateUrl : Geppaequo.contextPath + 'modules/dagr/templates/dag-websocket.html',
      controller  : controller
    };
  }]);

})();
