package net.aequologica.neo.dagr.websocket;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import static com.fasterxml.jackson.databind.DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES;

import java.io.IOException;

import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;

import com.fasterxml.jackson.databind.ObjectMapper;

public final class DagSocketMessageEncoderDecoder implements Encoder<DagSocketMessage, String>, Decoder<String, DagSocketMessage> {
    private final ObjectMapper mapper;

    public DagSocketMessageEncoderDecoder() {
        this.mapper = new ObjectMapper();
        // this.mapper.enable(INDENT_OUTPUT);
        this.mapper.configure(FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(NON_NULL);
    }
    
    @Override
    public DagSocketMessage decode(final String s){
        DagSocketMessage dagSocketMessage;
        try{
            dagSocketMessage = mapper.readValue(s, DagSocketMessage.class);
            return dagSocketMessage;
        }catch(IOException e){
            throw new RuntimeException(e);
        }
    }

    @Override
    public String encode(final DagSocketMessage dagSocketMessage){
        try{
            return mapper.writeValueAsString(dagSocketMessage);
        }catch(IOException e){
            throw new RuntimeException(e);
        }
    }
}
