package net.aequologica.neo.dagr.websocket;

import java.util.Date;

import net.aequologica.neo.dagr.model.Dag;

public final class DagSocketMessage{
    private Dag.Node node;
    private long time;

    public DagSocketMessage(){
        this(null);
    }

    public DagSocketMessage(Dag.Node node){
        this.node =  node;
        this.time = new Date().getTime();
    }

    public Dag.Node getNode(){
        return node;
    }

    public void setNode(Dag.Node node){
        this.node = node;
    }

    public long getTime(){
        return time;
    }

    public void setTime(long time){
        this.time = time;
    }
}
