var dagrReload = function(contextPath, callback) {
  var handlebars_messages   = $("#handlebars_messages").html();
  var handlebars_messages_template = Handlebars.compile(handlebars_messages);

  var format = 'MMMM Do YYYY, h:mm:ss a';
  $('#reload').click(function() {
    $.ajax({
        url: contextPath+'dagr-api/v1/reload',
        type: 'POST',
        cache: false,
        contentType: false,
        processData: false
    }).done(function( data, textStatus, jqXHR ) {
      var now = moment().format(format);
      var $messages = "";
      if (data && data.length) {
        $messages = handlebars_messages_template(data);
      }
      $("#messages").empty();
      var alert_class   = data.length == 0 ? "alert-success" : "alert-warning";
      var alert_message = data.length == 0 ? "reloaded"      : "reloaded with warnings";
      $( "#alert" ).clone()
                   .addClass(alert_class)
                   .append("["+textStatus+"] <small>"+now+"</small>&nbsp;<strong>"+alert_message+"!</strong>")
                   .append($messages)
                   .show()
                   .appendTo( "#messages" );
      if (callback) {
        callback();
      }
    }).fail(function( jqXHR, textStatus, errorThrown ) {
      var now = moment().format(format);
      $("#messages").empty();
      $( "#alert" ).clone()
                   .addClass("alert-warning")
                   .show()
                   .append("["+textStatus+"] "+now+"| <strong>oops!</strong> something wrong happened while sending a POST to [" +this.url + "]. Error:' '"+ errorThrown + "'")
                   .insertAfter( "#reload" );
    }).always(function( data_jqXHR, textStatus, jqXHR_errorThrown ) {
      // window.log("always");
    });
  });
};
