# <span style="float:left; margin-right:40px; margin-bottom:10px;"><img src="${baseURL}/assets/images/alphabet/051-16th-Century-letter-d-187x200.jpg"></span><span style="margin-left:-40px;">AG how-to</span>

## 0. DAG ?

cf. [directed acyclic graph](http://en.wikipedia.org/wiki/Directed_acyclic_graph)

&laquo; _a directed acyclic graph (...), is a directed graph with no directed cycles. That is, it is formed by a collection of vertices and directed edges, each edge connecting one vertex to another, such that there is no way to start at some vertex v and follow a sequence of edges that eventually loops back to v again_ &raquo;

## 1. upload DAG file

### DAG file format

e.g. 

<a href="${applicationScope.geppaequo.gitURL}/dagr/blob/${fn:replace(applicationScope.dagr.gitRepositoryState.branch, 'origin/', '') }/dagr-core/src/test/resources/java.io.tmpdir/.geppaequo/stnemucod/dags/arimul.basic" target="arimul.basic">basic DAG file</a>.

<a href="${applicationScope.geppaequo.gitURL}/dagr/blob/${fn:replace(applicationScope.dagr.gitRepositoryState.branch, 'origin/', '') }/dagr-core/src/test/resources/java.io.tmpdir/.geppaequo/stnemucod/dags/arimul.cluster" target="arimul.cluster">basic DAG file with clusters</a>.

<a href="${applicationScope.geppaequo.gitURL}/dagr/blob/${fn:replace(applicationScope.dagr.gitRepositoryState.branch, 'origin/', '') }/dagr-core/src/test/resources/java.io.tmpdir/.geppaequo/stnemucod/dags/github.aequologica.net.develop" target="github.aequologica.net.develop">real life full DAG file</a>.

### requirements

upload __MUST BE__ to directory __dags__ in document service.

<c:if test="${ pageContext.request.isUserInRole('wizard') || pageContext.request.isUserInRole('BUILTIN\\\\Administrators')}" >
### user interface

[fileupload.jsp](<c:url value="/stnemucod/html/dags"/>)

</c:if>

### REST interface

e.g. using [curl](http://curl.haxx.se/docs/manpage.html)

__windows__

    curl ^
        -F "file=@myDAG.json" ^
        -i ^
        -k ^
        -v ^
        -x http://proxy:8080 ^
        "${baseURL}/stnemucod/upload/dags?isUTF8=true"

__unix__

    curl \
        -F "file=@myHostSet.json" \
        -i \
        -k \
        -v \
        -x http://proxy:8080 \
        "${baseURL}/stnemucod/upload/dags?isUTF8=true"

| argument | (more info at [curl man page](http://curl.haxx.se/docs/manpage.html)) |
|----|----|
|-F, --form &lt;name=content&gt; | (HTTP) This lets curl emulate a filled-in form in which a user has pressed the submit button. This causes curl to POST data using the Content-Type multipart/form-data according to RFC 2388. |
|-i, --include  | (HTTP) Include the HTTP-header in the output. |
|-k, --insecure | (SSL) This option explicitly allows curl to perform "insecure" SSL connections and transfers. |
|-v, --verbose  | Makes the fetching more verbose/talkative. Mostly useful for debugging. |
|-x, --proxy <[protocol://]&#91;user:password@]proxyhost[:port]> | Use the specified proxy. |

## 3. reload DAGs

### user interface

<button id="reload" type="button" class="btn btn-default btn-lg">
    <span>reload <img id="ajaxLoading" src="<c:url value='/assets/images/animated_orange_refresh_22.png'/>">DAGs</span>
</button>
<div id="messages"></div>
<div  id="alert" class="alert alert-dismissable" style="display:none; ">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
</div>

### REST interface

e.g. using [curl](http://curl.haxx.se/docs/manpage.html)

__windows__

    curl ^
        -d "" ^
        -H "Content-Type:application/json" ^
        -i ^
        -k ^
        -v ^
        -x http://proxy:8080 ^
        -X POST ^
        "${baseURL}/dags"

__unix__

    curl \
        -d "" \
        -H "Content-Type:application/json" \
        -i \
        -k \
        -v \
        -x http://proxy:8080 \
        -X POST \
        "${baseURL}/dags"

| argument | (more info at [curl man page](http://curl.haxx.se/docs/manpage.html)) |
|----|----|
| -d, --data &lt;data&gt; | (HTTP) Sends the specified data in a POST request to the HTTP server, in the same way that a browser does when a user has filled in an HTML form and presses the submit button. |
| -H, --header &lt;header&gt; | (HTTP) Extra header to use when getting a web page. |
| -X, --request &lt;command&gt; | (HTTP) Specifies a custom request method to use when communicating with the HTTP server. |

## 4. select DAG(s)

### user interface

user must select one or more DAG(s) @ [dags-list.jsp](<c:url value="/modules/dagr/dags-list.jsp"/>)

selected DAGs are displayed @ [dagr main page](<c:url value="/modules/dagr"/>)
