<%@ page contentType="text/html" pageEncoding="UTF-8" trimDirectiveWhitespaces="true" 
%><%@ page import="net.aequologica.neo.geppaequo.servlet.WebJar"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout" %>
<%  net.aequologica.neo.geppaequo.servlet.ZeroUtils.HostContextUserAccountAndApp(request);
%>
<t:layout module="dagr" jsmodules="angular modernizr datatables moment">
<base href="<c:url value='/modules/dagr/dags.jsp' />">
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/dags.css'  />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/graph.css' />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/topo.css'  />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/building.css'  />"></link>
 
<div id="container" ng-app="dagsApplication">

  <section ng-controller="tabsController">


    <div>
      <form id    = "shorten" 
            class = "toolbar toprightfloating"> 
        <span id          = "online" 
              title       = "on / off line"
              data-toggle = "tooltip"
              class       = "connection {{connection ? 'on' : 'off'}} btn btn-xs btn-default"
              ng-click    = "toggleConnection()">
          <i class="fa fa-bolt" ></i>
        </span>
        <span id          = "vraiment" 
              title       = "short / medium / full label"
              data-toggle = "tooltip"
              class       = "btn btn-xs btn-default"
              ng-click="bumpShortenIndex()">
          <i class="fa {{shorten_icons[shorten_index]}}" ></i>
        </span>
        <a title          = "select dag(s)"
              href        = "<c:url value='/modules/dagr/dags-list.jsp'/>"
              class       = "btn btn-xs btn-default"
              data-toggle = "tooltip">
          <i class="fa fa-list" /></i>
        </a> 
        <a title          = "how-to"
              href        = "<c:url value='/modules/dagr/how-to.jsp'/>"
              class       = "btn btn-xs btn-default"
              data-toggle = "tooltip" >
          <i class="fa fa-question-circle" /></i>
        </a> 
        <span id="idspy" data-toggle="tooltip" title="dag id"></span>
      </form>
      <span class="alert alert-warning" ng-show="{{dagInfos.length == 0}}" ng-cloak> 
        <span class="label label-warning">warning</span> 
        <span>no DAG selected; click the 
          <a href="<c:url value='/modules/dagr/dags-list.jsp'/>">top right <i class="fa fa-list"></i> icon</a> to select a DAG.
        </span>
      </span>
    </div>

    <tabset ng-hide="{{dagInfos.length == 0}}">
      <tab ng-repeat="dagInfo in dagInfos" select="tabSelected(dagInfo)" deselect="tabDeselected(dagInfo)">
        <tab-heading>
          <h3 style="margin:0;" title="{{dagInfo.title}}" data-toggle="tooltip">{{dagInfo.name}}</h3>
          <form class="toolbar" style="margin-left:.5em;">
            <span id          = "download{{dagInfo.id}}" 
                  class       = "download btn btn-xs btn-default"  
                  title       = "download {{dagInfo.name}}"
                  data-id     = "{{dagInfo.id}}" 
                  data-toggle = "tooltip"
                  ng-click    = "download(dagInfo.name)">
              <i class="fa fa-download"></i>
            </span>      
          </form>
          
        </tab-heading>
        
        <dag ng-show="dagInfo.active">

            <dag-svg id="{{dag.name}}" resize></dag-svg>
            
            <dag-topological></dag-topological>
            
            <dag-websocket></dag-websocket>

        </dag>
      
      </tab>

    </tabset>

  </section>

</div>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("d3.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dagre-d3.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/angular-websocket.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/restangular.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("ui-bootstrap.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("ui-bootstrap-tpls.js")%>' />"></script>

<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dagre-d3-helper.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dags.js' />"></script>

<script type="text/javascript">

;(function(){
  angular.module('dagsApplication').controller('tabsController', ['$scope', 'localStorageService', function($scope, localStorageService){
    
    var dagInfos = [<c:forEach items="${model}" var="_this_" varStatus="status">
      {
        id         : '${status.count}',
        name       : '${_this_.name}',
        key        : '${_this_.key}',
        source     : '${_this_.url}',
        clazz      : <c:if test="${not empty pageContext.request.remoteUser}"><c:if test="${_this_.subscribed}">'toggle-on active'</c:if><c:if test="${not _this_.subscribed}">'toggle-off'</c:if></c:if><c:if test="${empty pageContext.request.remoteUser}">undefined</c:if>
      },</c:forEach>
    ];
    
    dagInfos.sort(function(a, b) {
      // cf. http://stackoverflow.com/questions/51165/how-do-you-do-string-comparison-in-javascript
      return a.name.localeCompare(b.name);
    });
    
    var snapshotServer = {
        name        : "${applicationScope.quintessence.snapshotRepo.name}",
        baseURL     : "${applicationScope.quintessence.snapshotRepo.url}"
    };
    var releaseServer = {
        name        : "${applicationScope.quintessence.releaseRepo.name}",
        baseURL     : "${applicationScope.quintessence.releaseRepo.url}"
    };
    
    $scope.dagInfos       = dagInfos;
    $scope.snapshotServer = snapshotServer;
    $scope.releaseServer  = releaseServer;
    
    $scope.download = function(dagName) {
      window.location.href = '<c:url value="/stnemucod/document/dags/"/>'+dagName;
    }
    
    $scope.connection = localStorageService.get('connection');
    $scope.toggleConnection = function() {
      $scope.connection = !$scope.connection;
      localStorageService.set('connection', $scope.connection);
      location.reload(); 
    };

    $scope.shorten_icons = [ "fa-minus",
                             "fa-plus",
                             "fa-asterisk" ];
    var shorten_index = localStorageService.get('shorten_index');
    if (typeof shorten_index === "undefined" || shorten_index == null) {
      shorten_index = 2;
    }
    $scope.shorten_index = shorten_index % $scope.shorten_icons.length;
    $scope.bumpShortenIndex = function() {
      $scope.shorten_index = ($scope.shorten_index + 1) % $scope.shorten_icons.length;
      localStorageService.set('shorten_index', $scope.shorten_index);
    }
    
    $scope.gimmethestuff = "<%=net.aequologica.neo.dagr.model.Dag.Node.State.gimmethestuff()%>";
    window.log($scope.gimmethestuff);
    
    $scope.jevaispasmefairechier = 'ws'
      <c:if test="${pageContext.request.secure}">
    + 's'
    </c:if>
    + '://'
    + '${pageContext.request.serverName}'
    + ':'
    + '${pageContext.request.serverPort}'
    + Geppaequo.contextPath;
    
    $scope.tabSelected = function(dagInfo) {
      dagInfo.active = true;
      window.log('activated', dagInfo.name);
    };
    $scope.tabDeselected = function(dagInfo) {
      dagInfo.active = false;
      window.log('desactivated', dagInfo.name);
    };

    $scope.magicien = false;
    <c:if test="${pageContext.request.isUserInRole('wizard') || pageContext.request.isUserInRole('BUILTIN\\\\Administrators')}">
    $scope.magicien = true;
    </c:if>
    
      
  }]);
})();

</script>

<script type="text/javascript">
  $(document).ready(function(){
    
    // tooltips
    $('body').tooltip({
      delay     : { "show": 500, "hide": 100 },
      placement : 'bottom',
      trigger   : "hover", 
      selector  : "[data-toggle='tooltip']"
    });
    
    $('#toggleSocketIFrame').on('click', function(event){
      event.preventDefault();
      $('#dagsocket').toggle();
    })
  });

</script>
