/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.garance;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.garance.Listener$$Lambda$1;
import net.aequologica.neo.dagr.garance.Listener$$Lambda$4;
import net.aequologica.neo.dagr.garance.Listener$$Lambda$5;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.garance.SeriesSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@WebListener
public class Listener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger((String)"net.aequologica.neo.dagr.garance");
    @Inject
    private SeriesSet seriesMap;
    @Inject
    private Bus<Dag.Node> bus;
    private Map<String, Date> startMap = new HashMap();
    private Subscription subscription;

    public void contextInitialized(ServletContextEvent arg0) {
        this.subscription = this.bus.toObservable().filter(Listener$$Lambda$1.lambdaFactory$()).map(Listener$$Lambda$4.lambdaFactory$()).subscribe(Listener$$Lambda$5.lambdaFactory$((Listener)this));
        log.debug("[garance] subbscribed !");
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
            log.debug("[garance] unsubscribed !");
        }
    }

    void sendNotification(Dag.Node node) {
        if (node.getState().equals((Object)Dag.Node.State.BEING_CLEANED)) {
            this.startMap.put(node.getValue().getGubrid(), new Date());
        } else if (node.getState().equals((Object)Dag.Node.State.CLEAN)) {
            Date start = (Date)this.startMap.get(node.getValue().getGubrid());
            if (start != null) {
                this.seriesMap.put(node.getValue().getGubrid(), (double)(new Date().getTime() - start.getTime()));
                this.seriesMap.save();
            }
            this.startMap.remove(node.getValue().getGubrid());
        } else if (node.getState().equals((Object)Dag.Node.State.CLEANING_FAILED)) {
            // empty if block
        }
    }

    private /* synthetic */ void lambda$contextInitialized$5(Dag.Node node) {
        this.sendNotification(node);
    }

    private static /* synthetic */ Dag.Node lambda$contextInitialized$4(BusEvent event) {
        return (Dag.Node)event.get();
    }

    private static /* synthetic */ Boolean lambda$contextInitialized$3(BusEvent event) {
        return event.getType().equals((Object)BusEvent.Type.BUILD_STARTED) || event.getType().equals((Object)BusEvent.Type.BUILD_OK) || event.getType().equals((Object)BusEvent.Type.BUILD_ERROR);
    }

    static /* synthetic */ Boolean access$lambda$0(BusEvent busEvent) {
        return Listener.lambda$contextInitialized$3((BusEvent)busEvent);
    }

    static /* synthetic */ Dag.Node access$lambda$1(BusEvent busEvent) {
        return Listener.lambda$contextInitialized$4((BusEvent)busEvent);
    }

    static /* synthetic */ void access$lambda$2(Listener listener, Dag.Node node) {
        listener.lambda$contextInitialized$5(node);
    }
}

