package net.aequologica.neo.dagr.jaxrs;

import java.io.IOException;

import javax.inject.Inject;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.model.Dag.Node;

@javax.ws.rs.Path("/github")
public class ResourceGithub extends AbstractResource {

    private final static Logger log = LoggerFactory.getLogger("net.aequologica.neo.dagr.jaxrs");
    
    @Inject private Bus<Node> bus;
    
    // cf. https://developer.github.com/v3/orgs/hooks/
    @POST
    @javax.ws.rs.Path("/notification")
    @Consumes("application/json")
    public Response getPushNotification(String payload) throws IOException {
        try {
            log.debug("[github] payload: {}", payload);
            System.out.println("[github] payload: "+ payload.replace("\n", "").replace("\r", ""));
            
            JsonObject githubPushPayload = mapper.readValue(payload, JsonObject.class);

            String repo_fullname = null;
            String ref           = githubPushPayload.getString("ref");

            JsonObject repositoryObject = githubPushPayload.getJsonObject("repository");
            if (repositoryObject != null) {
                repo_fullname = repositoryObject.getString("full_name");
            }
            
            if (repo_fullname != null && ref != null) {
                log.debug("[bus] sending event {}, repo_fullname='{}', ref='{}' to the bus", BusEvent.Type.PUSH, repo_fullname, ref);
                System.out.println("[bus] sending event "+BusEvent.Type.PUSH+", repo_fullname='"+repo_fullname+"', ref='"+ref+"' to the bus");
                
                // ça balance pas mal, dans le bus:
                bus.send(BusEvent.Type.PUSH, repo_fullname, ref);
            } else {
            }

            return Response.noContent().build();
        } catch (Exception e) {
            log.error("[github] exception {} logged and re-thrown", e.getMessage());
            System.err.println("[github] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        } finally {
        }

    }
    
}
