/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.bus;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.aequologica.neo.dagr.Dags;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.model.Dag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

@Singleton
public class NodeBusImpl
implements Bus<Dag.Node> {
    private static final Logger log = LoggerFactory.getLogger((String)"net.aequologica.neo.dagr.bus");
    private final Subject<BusEvent<Dag.Node>, BusEvent<Dag.Node>> nodeBus = new SerializedSubject((Subject)PublishSubject.create());
    @Inject
    private Dags dags;

    private NodeBusImpl() {
        log.debug("bus {} created", (Object)this);
    }

    @Override
    public void send(final BusEvent.Type type, String repo_fullname, String ref) {
        try {
            Object newState = type.equals((Object)BusEvent.Type.PUSH) ? Dag.Node.State.DIRTY : (type.equals((Object)BusEvent.Type.DEPENDENCY) ? Dag.Node.State.DIRTY : (type.equals((Object)BusEvent.Type.BUILD_STARTED) ? Dag.Node.State.BEING_CLEANED : (type.equals((Object)BusEvent.Type.BUILD_ERROR) ? Dag.Node.State.CLEANING_FAILED : (type.equals((Object)BusEvent.Type.BUILD_OK) ? Dag.Node.State.CLEAN : (type.equals((Object)BusEvent.Type.TRAVIS_ERROR) ? Dag.Node.State.CLEANING_FAILED : (type.equals((Object)BusEvent.Type.TRAVIS_OK) ? Dag.Node.State.CLEAN : null))))));
            List nodes = this.dags.getNodesByRepoFullnameAndRef(repo_fullname, ref);
            log.debug("[bus] found {} nodes with repo_fullname='{}' and ref='{}'", new Object[]{nodes.size(), repo_fullname, ref});
            for (final Dag.Node node : nodes) {
                Dag.Node.State previousState = node.getState();
                if (newState != null && previousState != null && !previousState.equals(newState)) {
                    node.setState(newState);
                }
                log.debug("[bus] notiying observers that state of node {} ({}) changed from {} to {}", new Object[]{node.getName(), node.getId(), previousState, node.getState()});
                this.nodeBus.onNext((Object)new BusEvent<Dag.Node>(){

                    @Override
                    public BusEvent.Type getType() {
                        return type;
                    }

                    @Override
                    public Dag.Node get() {
                        return node;
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("[bus] exception {} logged and re-thrown", (Object)e.getMessage());
            System.err.println("[bus] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        }
    }

    @Override
    public Observable<BusEvent<Dag.Node>> toObservable() {
        return this.nodeBus;
    }
}

