<%@page contentType="text/html" pageEncoding="UTF-8"
%><%@taglib prefix="c"   uri="http://java.sun.com/jstl/core_rt"
%><%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt_rt"
%><%@taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><t:layout module="aether" >

<link href="//cdnjs.cloudflare.com/ajax/libs/select2/4.0.0/css/select2.min.css" rel="stylesheet" />

<style>

input:text {
  width: 100%;
}
  .table-condensed > thead > tr > th:first-child, 
  .table-condensed > tbody > tr > td:first-child {
padding-left:0;
}
  .table-condensed > thead > tr > th:last-child, 
  .table-condensed > tbody > tr > td:last-child {
padding-right:0;
}
th:before {
  /* content: "| "; */
  color: lightgray;
}

form > div {
  margin-top: 1em;
}
abbr[title], abbr[data-original-title] {
border-bottom:none;
}
.fa-asterisk {
  color:orange;
  font-size:6pt;
  vertical-align: text-top;
  
}
#msg > div > div > span,
#msg > div > div > i,
#msg > div > div > b,
#msg > div > div > a {
  padding-right: 15px;
}

</style>

<a class="visible-lg" style="float:right;" href="http://books.sonatype.com/mvnex-book/reference/simple-project-sect-simple-core.html" target="maven_doc">
    <img src='<c:url value="/assets/images/help.png"/>' title="Explanation of 'Maven Coordinates' (scroll down in the linked page)."/>
</a>

<h2>Resolve Version Range</h2>

          
<form action="javascript:return false;">
  <div class="table-responsive">
    <table class="table table-condensed" id="hor-minimalist-a">
      <caption></caption>
      <thead>
        <tr>
          <th  title="Group id of the artifact (Required)">
            <label>group&nbsp;id&nbsp;<abbr class="req" title="required"><i class="fa fa-asterisk"></i></abbr></label></th>
          <th  title="Artifact id of the artifact (Required)">
            <label>artifact&nbsp;id&nbsp;<abbr class="req" title="required"><i class="fa fa-asterisk"></i></abbr></label></th>
          <th  title="Classifier of the artifact (Optional)">
            <label>classifier</label></th>
          <th  title="Packaging type of the artifact (Optional)">
            <label>extension</label></th>
          <th  title="Version range of the artifact (Required) Supports resolving of 'LATEST', 'RELEASE' and snapshot versions ('1.0-SNAPSHOT') too">
            <label>version&nbsp;range&nbsp;<abbr class="req" title="required"><i class="fa fa-asterisk"></i></abbr></label>
            <a class="visible-lg" style="float:right;" href="https://docs.oracle.com/middleware/1212/core/MAVEN/maven_version.htm#MAVEN402">
              <img src='<c:url value="/assets/images/help.png"/>' title="'Version Range' syntax guide"/>
            </a>
          </th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td ><input class="form-control" type="text" id="g" value="" /></td>
          <td ><input class="form-control" type="text" id="a" value="" /></td>
          <td ><input class="form-control" type="text" id="c" value="" /></td>
          <td ><input class="form-control" type="text" id="e" value="" /></td>
          <td ><input class="form-control" type="text" id="v" value="" /></td>
        </tr>
      </tbody>
    </table>
    </div>

    <div class="form-inline">
      <div class="form-group visible-lg" style="float: right;">
        <label style="font-style: italic;">predefined
          searches: </label> <select class="form-control"
            id="myComboBox">
              <option value="0"></option>
              <option value="1">ch.qos.logback:logback-classic:jar:sources:[,1.1)</option>
              <option value="2">org.slf4j:slf4j-api:jar::[,)</option>
              <option value="3">net.aequologica.neo:holos:pom::[,)</option>
          </select>
      </div>
      <div class="form-group">
        <label title="Repository where to search the artifact(Required)">repository&nbsp;<abbr class="req" title="required"><i class="fa fa-asterisk"></i></abbr></label>
        <select class="form-control" id="r" style="width:32em;" multiple="multiple">
          <c:forEach var="repo" items="${applicationScope.quintessence.repos}">
          <option value="${repo.name}" title="${repo.url}">${repo.name}</option>
          <%--
          <option value="qwe">asd</option>
          --%>
          </c:forEach>
         </select>
      </div>
    </div>

    <div class="form-inline">
    <div  class="form-group">
      <input class="form-control btn btn-default" id="submit" type="submit" value="resolve" /> 
      <input class="form-control btn btn-default" id="reset" type="reset" value="reset" />
    </div>
    </div>

    <div id="msg" class="alert" style="display:none; margin-top:1em; "></div>

</form>

<div style="display:none">
  <pre id="result" ></pre>
  <pre id="location-header"></pre>
</div>

<%-- div class="btn btn-default" id="download" style="display:none; margin-top:1em;">download</div--%>

</t:layout>

<script src="//cdnjs.cloudflare.com/ajax/libs/select2/4.0.0/js/select2.min.js"></script>

<script>
  $(function() {
    $("#myComboBox").change(function() {
        var ids = ["g", "a", "e", "c", "v"];
        var gav = $("#myComboBox option:selected").text();
        if (gav == "") {
            for (i in ids) {
                var inp = $("#"+ids[i]);
                inp.val("");
            }
        } else {
            var a = gav.split(':');
            for (i in a) {
                var inp = $("#"+ids[i]);
                inp.val(a[i]);
            }
        }
    }); 
  });
  
  $("form").submit(function() {
     $("#msg").removeClass().addClass("alert alert-info").text("resolving ...").show();
     $("#result").parent().hide();

     
     var commonQueryString = "";
     var rrr = $('#r').val();
     if (rrr) {
       if (rrr.length) {
         for (i=0;i<rrr.length;i++) {
           if (i > 0) {
             commonQueryString = commonQueryString + "&";
           }
           commonQueryString = commonQueryString + "r=" +  rrr[i];
         }
       } else {
         commonQueryString = commonQueryString + "r=" + rrr;
       }
     }
     commonQueryString = commonQueryString + "&g=" + $('#g').val();
     commonQueryString = commonQueryString + "&a=" + $('#a').val();
     commonQueryString = commonQueryString + "&e=" + $('#e').val();
     var classifier = $('#c').val();
     if (classifier) {
       commonQueryString = commonQueryString + "&c=" + classifier;
     }
     var localQueryString = "&v=" + $('#v').val();
     var theURL = '<c:url value="/aether-api/v1/legacy?"/>'+ commonQueryString + localQueryString;

     var artifacId = $('#a').val();
     var range = $('#v').val();
     $.ajax({
       url: theURL,
       cache: false,
       dataType: 'json',
       timeout: 30000,
       success: function(data, textStatus, jqXHR) {
         var locationHeader = jqXHR.getResponseHeader("Location");
          $("#msg")
            .removeClass()
            .addClass("alert alert-success")
            .html(
              $('<div>')
              .append($('<div>')
                .css({"font-size": "smaller", "float":"right"})
                .text(textStatus + " - " +jqXHR.status + " - " +jqXHR.statusText + ' ')
              ).append($('<div>')
                .css({"font-size": "larger"})
                  .append( $('<span>').text(artifacId + ' ' + range))
                  .append( $('<i>').addClass("fa fa-hand-o-right"))
                  .append( $('<b>').text(data.version))
                  .append( $('<a>').attr('href', locationHeader)
                    .append( $('<i>').attr('id', "download").addClass("fa fa-download")))
              )
            )
            .show();
          
          var pretty = JSON.stringify(data, undefined, 2);
          $("#result").empty().append(pretty);

          $("#msg").show();
          $("#result").parent().show();
          $("#download").show();

          $("#location-header").empty().append('<span>"Location" response header:<span>&nbsp;<span>"'+locationHeader+'"<span>').show();
          
       },
       error: function(jqXHR, textStatus, errorThrown) {
          if (400 <= jqXHR.status && jqXHR.status < 500) {
            $("#msg").removeClass().addClass("alert alert-warning").text(textStatus + " - " + jqXHR.status+" - "+jqXHR.statusText + ' - "'+jqXHR.responseText + '"').show();
          } else {
            $("#msg").removeClass().addClass("alert alert-danger").text(textStatus + " - " + jqXHR.status+" - "+jqXHR.statusText).show();
          } 
          $("#msg").show();
          $("#result").parent().hide();
          $("#download").hide();
          if (errorThrown.message) {
            $("#result").empty().text(errorThrown.message).parent().show();
          } else if (errorThrown != jqXHR.statusText) {
            $("#result").empty().text(errorThrown).parent().show();
          } else {
            $("#result").empty();
          }
       }
     });
     return false;
  });

  $("form").bind("reset", function() {
      $("#msg").hide();
      $("#result").parent().hide();
      $("#download").hide();
      return false;
  });
  
  
  if (typeof String.prototype.startsWith != 'function') {
  String.prototype.startsWith = function (str){
      return this.slice(0, str.length) == str;
    };
  }
  
  $(document).ready(function() {
    
    $("#r").select2();
    
    $("#r").val("");
    $("#g").val("");
    $("#a").val("");
    $("#e").val("");
    $("#c").val("");
    $("#v").val("");
  });
    

</script>
