;var DAGSAPP = (function(){

  var app = angular.module('dagsApplication', ['ui.bootstrap', 'restangular', 'angular-loading-bar', 'LocalStorageModule', 'angular-websocket']);
  
  /////////////////////////////////////////////////////////////////////////////
  // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
  function tryParseJSON(hypotheticalJSON){
    try {
        var o = JSON.parse(hypotheticalJSON);

        // Handle non-exception-throwing cases:
        // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
        // but... JSON.parse(null) returns 'null', and typeof null === "object", 
        // so we must check for that, too.
        if (o && typeof o === "object" && o !== null) {
            return o;
        }
    } catch (e) { 
    }

    return false;
  };

  /////////////////////////////////////////////////////////////////////////////
  app.config(function(RestangularProvider) {
    RestangularProvider.setBaseUrl(Geppaequo.contextPath + 'dagr-api/v1');
  });
  
  // second Restangular service that uses aether-api
  app.factory('AetherRestangular', function(Restangular) {
    return Restangular.withConfig(function(RestangularConfigurer) {
      RestangularConfigurer.setBaseUrl(Geppaequo.contextPath + 'aether-api/v1');
    });
  });  
  
  app.config(function (localStorageServiceProvider) {
    localStorageServiceProvider
      .setPrefix('dagr');
  });  
  
  ///////////////////////////////////////////////////////////////////////////
  app.directive('dagWebsocket', ['$websocket', function($websocket){
    
    var controller = ['$scope', function ($scope) {
      // Open a WebSocket connection
      var url  = $scope.jevaispasmefairechier + 'patata';
      
      window.log("opening dag websocket from", url);
      var dataStream = $websocket(url);

      $scope.collection = [];

      dataStream.onClose(function() {
        window.log('closing dag websocket');
        dataStream = null;
      });

      dataStream.onError(function() {
        window.log('error in dag websocket');
        dataStream = null;
      });

      dataStream.onMessage(function(atmosphereMessage) {
        // window.log(atmosphereMessage);
        
        var messages = atmosphereMessage.data.split('|');

        if (messages.length < 2) {
          messages = [atmosphereMessage];
        } else {
          messages.shift();
        }
        var len = messages.length;

        for (i=0; i<len; ++i) {
          var message = messages[i];
          var parsed = tryParseJSON(message)
          if (parsed) {
            
            DAGRE_D3_HELPER.putTheStuffMan(parsed.node.id, $scope.gimmethestuff, parsed.node.state);
            
            // the dag we are enclosed in may not have been yet initialized (e.g. hidden tab)
            if ($scope.nodeMap) {
              var node = $scope.nodeMap[parsed.node.id];
              if (node) {
                node.state = parsed.node.state;
              }
              
              if (parsed.node.cleaner) {
                node.startBuildhubWebsocket(parsed.node.cleaner);
              }
              
              if (parsed.node.state == "CLEAN") {
                node.refreshSnapshot();
              }
            }
  
            $scope.collection.push(parsed);
          } else {
            $scope.collection.push(message);
          }
        }
      }); 
      
      var myTimer     = null;
      var states      = $scope.gimmethestuff.split(' ');;
      var stateIndex  = 0;
      
      $scope.start = function() {
        if (myTimer == null) {
          myTimer = setInterval(function() {
            var nodes = $scope.topological;
            
            var node = nodes[Math.floor(Math.random()*nodes.length)];

            var $element = $('table.table > tbody > tr[data-id='+node.id+'] > td .building span'); 
            $element.text(new Date());
            
            dataStream.send(JSON.stringify({node:{id: node.id, name: node.name, state: states[stateIndex%states.length]}}));
            stateIndex = stateIndex + 1;

          }, 500);
        }
      }
      
      $scope.stop = function() {
        if (myTimer != null) {
            clearInterval(myTimer);
            myTimer = undefined;
        }
        $scope.collection = [];
      }
    }]; // end of controller def
    
    return {
      restrict    : 'E',
      require     : '^dag',
      templateUrl : Geppaequo.contextPath + 'modules/dagr/templates/dag-websocket.html',
      controller  : controller
    };
  }]);

  /////////////////////////////////////////////////////////////////////////////
  app.directive('dag', [function(){
    
    var controller = ['$scope', '$sce', 'Restangular', 'AetherRestangular', '$websocket', function($scope, $sce, Restangular, AetherRestangular, $websocket) {
      
      $scope.dag     = {};
      $scope.loaded  = false;
      $scope.loading = false;
      
      $scope.loadOnce = function() {
        if ($scope.loaded || $scope.loading) {
          return;
        }
        $scope.loading = true;
        
        var dagRestResource = Restangular.one('dags', $scope.dagInfo.name);

        dagRestResource.get().then(function(dag) {
          
          var nodeArray = [];
          
          dag.nodes.forEach(function(node) {
            if (node.clazz !== "cluster") {
              nodeArray.push(node);
            }
          });
          
          // load topological sort
          var topologicalSortRestResource = Restangular.one('dags', $scope.dagInfo.name).one('topological');

          topologicalSortRestResource.get().then(function(topo) {
            // cf. http://stackoverflow.com/questions/13304543/javascript-sort-array-based-on-another-array
            // as noted in the comments @ SO, the following code has quadratic complexity
            // node arrays *must* be small, and, in fact, they are expected to be small.
            $scope.topological = nodeArray.map(function(node) {
              var n = topo.indexOf(node.id);
              topo[n] = '';
              return [n, node];
            }).sort().map(function(j) { return j[1] });
          });
   
          var nodeMap = {};
          nodeArray.forEach(function(node) {
            nodeMap[node.id] = node;
          });
          $scope.nodeMap = nodeMap;

          var clusterCount = 0;
          
          dag.nodes.forEach(function(node) {
            
            node.building = function () {
              return node.state == "BEING_CLEANED";
            }
            
            var dataStream = null;
            node.startBuildhubWebsocket = function(cleaner) {
              if (dataStream != null) {
                return;
              }

              var url  = $scope.jevaispasmefairechier + 'hub/' + cleaner;
              
              // Open a WebSocket connection
              window.log("opening cleaner websocket from", url, 'for node', node.name, cleaner);
              dataStream = $websocket(url);

              var $element = $('table.table > tbody > tr[data-id=' + node.id + '] > td .building span'); 

              dataStream.onMessage(function(angularWebSocketMessageWrapper) {

                // window.log(angularWebSocketMessageWrapper);
                var atmosphereMessage = angularWebSocketMessageWrapper.data;
                  
                var atmospherePrefixRemoved = atmosphereMessage.replace(/\d+\|(\{.*\})/gi, "$1");

                var datum = tryParseJSON(atmospherePrefixRemoved)
                if (datum) {

                  $element.text(datum.value);
                  
                  if (datum.key === "result") {
                    if (datum.value === "false") {
                      node.state = "CLEANING_FAILED";
                    } else {
                      node.state = "CLEAN";
                    }
                  }
                  if (datum.key === "close" && datum.value === "close") {
                    dataStream.close(true);
                  }
                }
              });

              dataStream.onClose(function() {
                window.log(node.id, 'cleaner socket received onClose event', cleaner);
                dataStream = null;
              });

              dataStream.onError(function() {
                window.log(node.id, 'cleaner socket received onError event', cleaner);
                dataStream = null;
              });

            }
            
            // cluster ?
            {
              if (node.clazz == "cluster") {
                clusterCount = clusterCount + 1;
                node.value.clusterLabelPos = 'top';
              }
            }
            
            // setup short and medium and full labels
            {
              node.value.labelFull = node.value.label;
              
              var name    = node.value.labelFull;
              var version = "";

              var labelFullSplit = node.value.labelFull.split(' ');
              if (labelFullSplit.length > 1) {
                name = labelFullSplit.shift();
                version = labelFullSplit.join(' ');
              }
                
              var shortName  = name;
              var lastDot = name.lastIndexOf('.');
              if (lastDot != -1) {
                shortName = name.substr(lastDot+1);
              }
              
              node.value.labelShort  = shortName;
              node.value.labelMedium = shortName + ' ' + version;
            }
            
            // setup gavpce
            {
              node.gav = gavpce(node.value.gubrid);

              if (node.gav.ok()) {
                // prepare for travis
                var shortgav  = node.gav.g.replace(/net\.(.*)\.neo/g, "$1");
                node.reponame = shortgav+"/"+node.gav.a;
                node.repoid   = node.reponame.replace(/\//g, "_");

              }
            }

            //setup scm
            {
              var scmurl;
              if (typeof node.value.scm !== "undefined" && node.value.scm != null) {
                github = node.value.scm.replace(/\.git/g, "");
                if (github.startsWith('http')) {
                   scmurl = github;
                } else if (github.startsWith('git@')) {
                  github = github.replace(/\:/gi, "/");
                  github = github.replace(/^git@/g, "https://");
                  scmurl = github;
                }
              }
    
              if (typeof node.value.branch !== "undefined" && node.value.branch != null ) {
                node.shortbranch = node.value.branch.replace(/refs\/heads\//g, "");
                if (typeof scmurl !== "undefined") {
                    scmurl = scmurl +'/tree/' + node.shortbranch
                }
              }
              
              if (typeof scmurl !== "undefined") {
                node.value.scmurl     = scmurl;
                node.value.scmtruncated = github.middleEllipse(20, 14);
              } else {
                node.value.scmtruncated = github;
              }
            }
            
            // setup travis 
            if ($scope.connection) {
              // is travis here ?
              var travisURL = "https://api.travis-ci.org/repos/"+node.reponame+"/branches";

              $.ajax({
                url: travisURL,
                crossDomain: true,
                headers: { 'Accept' : 'application/vnd.travis-ci.2+json' }
              })
              .fail(function( data ) {
                node.travis = false;
              })
              .done(function( data ) {
                node.travis = true;
                var foundJob = null; {
                  // search in commits array for the branch
                  var foundCommit = null; {
                    for (var ccc = 0; ccc < data.commits.length; ccc++) {
                      if (data.commits[ccc].branch==node.shortbranch) {
                        foundCommit = data.commits[ccc].id;
                        break;
                      }
                    }
                  }
                  if (foundCommit != null) {
                    // search in branch array for the job
                    for (var bbb = 0; bbb < data.branches.length; bbb++) {
                      if (data.branches[bbb].commit_id==foundCommit) {
                        if (data.branches[bbb].job_ids.length) {
                          foundJob = data.branches[bbb].job_ids[0];
                          break;
                        }
                      }
                    }
                  }
                }
                if (foundJob != null) {
                  node.foundJob = foundJob;
                }
              });
            }
            
            // setup and conditionally exec aether requests
            {
              node.refreshSnapshot = function() {
                var snapshotRes = AetherRestangular
                  .one('repositories', $scope.snapshotServer.name)
                  .one('groups',       node.gav.g )
                  .one('artifacts',    node.gav.a )
                  .one('versions',     '[,)' )
                  .one('extensions',   'pom' );
                
                snapshotRes.get().then(function(aetherJson) {
                  node.resolvedSnapshot = $sce.trustAsHtml(aetherJson.version);
                },function(response) {
                  // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
                  node.resolvedSnapshot = $sce.trustAsHtml("&#8709;");
                });
              }
              
              node.refreshRelease = function() {
                var releaseRes = AetherRestangular
                  .one('repositories', $scope.releaseServer.name)
                  .one('groups',       node.gav.g )
                  .one('artifacts',    node.gav.a )
                  .one('versions',     '[,)' )
                  .one('extensions',   'pom' );
                
                releaseRes.get().then(function(aetherJson) {
                  node.resolvedRelease = $sce.trustAsHtml(aetherJson.version);
                },function(response) {
                  // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
                  node.resolvedRelease = $sce.trustAsHtml("&#8709;");
                });
              }
              
              if ($scope.connection) {
                node.refreshSnapshot();
                node.refreshRelease();
              }
            }
          }); // dag.nodes.forEach
          
          if (clusterCount > 1 ) {
            // cf. http://tools.medialab.sciences-po.fr/iwanthue/
            var colors = ["#3CF7BD",
                          "#D118AB",
                          "#6E3904",
                          "#A6BCE6",
                          "#C2E12C",
                          "#0A5BC6",
                          "#E493AB",
                          "#D6F3B7",
                          "#316B7B",
                          "#289870",
                          "#53327D",
                          "#9C1D1D"];
            var color = 0;
            dag.nodes.forEach(function(node) {
              if (node.clazz == "cluster") {
                node.value.style = "fill: " + colors[(color++)%colors.length];
              }
            });
          }
          
          dag.links.forEach(function(edge) {
            if (edge.clazz == "parent") {
              edge.value.style = "stroke: #7777FF; stroke-width: 1px; stroke-dasharray: 5, 5;";
            } else if (edge.clazz == "transitive") {
              edge.value.style = "stroke: #3f7f7f; stroke-width: 1px; stroke-dasharray: 2, 3;";
            }
            edge.value.lineInterpolate = 'basis';
            edge.value.arrowheadStyle  = "fill: #000";
          });
          
          $scope.askTravis2rebuild = function(node) {
            if (!node.foundJob) {
              return;
            }

            $.ajax({
              url: 'https://api.travis-ci.org/jobs/'+node.foundJob+'/restart',
              method: "POST",
              crossDomain: true,
              headers: {'Accept'        : 'application/vnd.travis-ci.2+json', 
                        'Authorization' : 'token 8W0KwXx3rb-5PFC721NTJA'}
            })
            .fail(function( jqXHR, textStatus, errorThrown ) {
              alert("[]\nthere was some issue connecting with travis, rebuild has not been triggered.\ntextStatus: "+textStatus+"\nerrorThrown: "+errorThrown);
            })
            .done(function( data, textStatus, jqXHR ) {
              var buildStartedRes = Restangular
                .one('dags',  $scope.dagInfo.name)
                .one('nodes', node.name )
                .one('event', 'BUILD_STARTED' );
              
              buildStartedRes.patch({}, undefined, { 'Content-Type': 'text/plain' }).then(
                function(json)    {
                  // window.log('message BUILD_STARTED send to dagr-api for node ' + node.name );
                },
                function(response) {
                  // window.log('error sending BUILD_STARTED to dagr-api for node ' + node.name );
                }
              );
            });
          }
                
          $scope.dag = dag;
          
          $scope.cleanNode = function(node) {
            var snapshotRes = Restangular
              .one('dags',  $scope.dagInfo.name)
              .one('nodes', node.name )
              .one('event', 'BUILD_OK' );
            
            snapshotRes.patch({}, undefined, { 'Content-Type': 'text/plain' }).then(
              function(json)    {},
              function(resonse) {}
            );
          };
          
          $scope.loaded = true;
          $scope.loading = false;
          // window.log('loaded', dag.name);
        }); // dagRestResource.get().then
        
      }  
      
      if (!$scope.dagInfo.active || typeof $scope.dag.name !== "undefined") {
        // window.log('$scope.dagInfo.name', $scope.dagInfo.name, '$scope.dagInfo.active', $scope.dagInfo.active, 'typeof $scope.dag.name', typeof $scope.dag.name, ': not loading');
        return;
      } else {
        // window.log('$scope.dagInfo.name', $scope.dagInfo.name, '$scope.dagInfo.active', $scope.dagInfo.active, 'typeof $scope.dag.name', typeof $scope.dag.name, ': load me, please !');
        $scope.loadOnce();
      }

    }]; // controller definition
    
    return {
      restrict    : 'E',
      require     : '^dag',
      controller  : controller,
      link: function ($scope, $element, attr) {
        $scope.$watch(attr.ngShow, function() {
            var visible = eval('$scope.'+attr.ngShow);
            // window.log("Hi, I'm ...", eval('$scope.'+attr.ngShow) ? 'visible' : 'hidden', $scope.dagInfo.name);
            if (visible) {
              $scope.loadOnce();
            }
        });
    }
    };
    
  }]);
  
  /////////////////////////////////////////////////////////////////////////////
  app.directive('dagTopological', [function(){
    
    var controller = ['$scope', function($scope) {
      
      $scope.mouseenter = function(dagId) {
        var $node = $('g.node#'+dagId);
        $node.addClass('HOVER');
      };
      
      $scope.mouseleave = function(dagId) {
        var $node = $('g.node#'+dagId);
        $node.removeClass('HOVER');
      };
      
    }];
    
    return {
      restrict    : 'E',
      templateUrl : Geppaequo.contextPath + 'modules/dagr/templates/dag-topological.html',
      controller  : controller
    };
  }]);

  /////////////////////////////////////////////////////////////////////////////
  app.directive('dagSvg', [function(){
    
    function link(scope, element, attrs) {
      scope.$watch('dag', function () {
        if (scope.dag.name) {
          scope.g = DAGRE_D3_HELPER.renderGraph(scope.dag, element, scope.shorten_index);
        }
      }, true);

      scope.$watch('shorten_index', function (newValue, oldValue, scope) {
        // window.log('$watch shorten_index', scope.dag, element, newValue, oldValue);
        DAGRE_D3_HELPER.renderGraph(scope.dag, element, newValue);
      }, true);

      scope.$watch('dagInfo.active', function (newValue, oldValue, scope) {
        // window.log('$watch dagInfo.active', scope.dag, element, newValue, oldValue);
        if (newValue) {
          // cf. http://stackoverflow.com/questions/12304291/angularjs-how-to-run-additional-code-after-angularjs-has-rendered-a-template
          scope.$evalAsync(function() { DAGRE_D3_HELPER.resizeGraph(scope.g, element); } );
        }
      }, true);
    }
    
    return {
      restrict    : 'E',
      require     : '^dag',
      templateUrl : Geppaequo.contextPath + 'modules/dagr/templates/dag-svg.html',
      link        : link,
    };
  }]);
  
  /////////////////////////////////////////////////////////////////////////////
  // cf. http://jsfiddle.net/jaredwilli/SfJ8c/
  app.directive('resize', function ($window) {
    return function (scope, element) {
        var w = angular.element($window);
        scope.getWindowDimensions = function () {
            return {
              'h': w.height(),
              'w': w.width()
            };
        };
        scope.$watch(scope.getWindowDimensions, function (newValue, oldValue) {
          // not used, I know; maybe should be passed as parameter of the resizeGraph ?
          scope.windowHeight = newValue.h;
          scope.windowWidth  = newValue.w;

          if (scope.dagInfo.active) {
            DAGRE_D3_HELPER.resizeGraph(scope.g, element);
          }
        }, true);

        w.bind('resize', function () {
            scope.$apply();
        });
    }
  });
  
  /////////////////////////////////////////////////////////////////////////////
  function gavpce(str) {
    var _this_ = {};

    function isok(x) {
        if (typeof x === "undefined" || x === null || x.length === 0) {
            return false;
        }
        return true;
    }

    /*
    g    Group id of the artifact (Required)
    a    Artifact id of the artifact (Required)
    t    Type of the artifact (Required)
    v    Version of the artifact (Required) Supports resolving of "LATEST", "RELEASE" and snapshot versions ("1.0-SNAPSHOT") too
    p    Packaging type of the artifact (Optional)
    c    Classifier of the artifact (Optional)
    e    Extension of the artifact (Optional)
    
    [r    Repository that the artifact is contained in (Required)] <-- not needed
    
    str = "g:a:t:v:p:c:e";
    
    */
    // verify that parameter is fine
    // if not, return an object that containing only a 'ok' function returning false.
    if (!isok(str)) {
        _this_.ok = function() {return false;}
        return _this_;
    }

    var arr = str.split(":");

    _this_.g = arr[0];
    _this_.a = arr[1];
    _this_.t = arr[2];
    _this_.v = arr[3];
    _this_.p = arr[4];
    _this_.c = arr[5];
    _this_.e = arr[6];

    // if no package , package is type
    if (!isok(_this_.p)) {
        _this_.p = _this_.t;
    }

    _this_.ok = function() {
       var mandatories = [_this_.g, _this_.a, _this_.t, _this_.v];
       for (j = 0; j < mandatories.length; j++) {
           if (!isok(mandatories[j])) {
               return false;
           }
       }
       return true;
    }

    return _this_;
  }
  
  /////////////////////////////////////////////////////////////////////////////
  return app;
  
})();

