(function() {

  'use strict';

  window.DAGRE_D3_HELPER = (function() {
    
    // wire graph to table 
    function wireGraph2Table(dagId) {

      $('svg[data-id="'+dagId+'"] g.node' )
      .mouseenter(function() { 
        var nodeId = $(this).attr('id');
        if (nodeId) {
          var $tr = $('table.table[data-id="'+dagId+'"] tr[data-id="'+nodeId+'"]');
          $tr.addClass('HOVER');
        }
      }).mouseleave(function() {
        var nodeId = $(this).attr('id');
        if (nodeId) {
          var $tr = $('table.table[data-id="'+dagId+'"] tr[data-id="'+nodeId+'"]');
          $tr.removeClass('HOVER');
        }
      });
    }

    var putTheStuffMan = function(nodeId, remove, add) {
      $('g.node#' + nodeId).removeClass(remove).addClass(add);
    };
    
    var renderGraph = function(dag, svgElement, shorten_index) {
      if (typeof dag === "undefined" || typeof dag.nodes === "undefined") {
        return;
      }
      
      // clone dag to prevent angular infinite loop on $digest
      var dagClone = $.extend(true, {}, dag);

      // grab first child g element
      var graphElement = svgElement.find('svg').children('g').get(0);
      $(graphElement).empty();
      
      // set up an SVG group so that we can translate the final graph.
      var inner = d3.select(graphElement).append("g");

      var createGraph = function(dag) {
        var dagreD3graph = new dagreD3.graphlib.Graph({
          compound : true
        }).setGraph({}).setDefaultEdgeLabel(function() {
          return {};
        });

        dag.nodes.forEach(function(node) {

          if (typeof shorten_index !== "undefined") {
            if (shorten_index == 0) {
              node.value.label = node.value.labelShort;
            } else if (shorten_index == 1) {
              node.value.label = node.value.labelMedium;
            } else {
              node.value.label = node.value.labelFull;
            }
          }

          if (node.parent) {
            dagreD3graph.setParent(node.id, node.parent);
          }
          dagreD3graph.setNode(node.id, node.value);
        });

        dag.links.forEach(function(link) {
          dagreD3graph.setEdge(link.u, link.v, link.value);
        });

        return dagreD3graph;
      };

      var dagreD3graph = createGraph(dagClone);

      dagreD3graph.nodes().forEach(function(nodeId) {
        var node = dagreD3graph.node(nodeId);
        node.id = nodeId;
        // round the corners of the nodes
        node.rx = node.ry = 8;
      });

      var localNodeMap = {};
      $.each(dagClone.nodes, function(index, node) {
        localNodeMap[node.id] = node;
      });

      // create the renderer
      var render = new dagreD3.render();

      // run the renderer; this is what draws the final graph.
      render(inner, dagreD3graph);

      dagreD3graph.nodes().forEach(function(nodeId) {
        var node = localNodeMap[nodeId];
        var $node = $('g.node#' + nodeId);
        $node.attr('name', node.value.label);
        $node.addClass(localNodeMap[nodeId].state);
      });
      
      resizeGraph(dagreD3graph, svgElement);
      
      wireGraph2Table(dag.name);
      
      return dagreD3graph;
    };

    var resizeGraph = function(dagreD3graph, svgElement) {
      if (typeof dagreD3graph === "undefined") {
        return;
      }

      // grab first child g element
      var graphElement = svgElement.find('svg').children('g').get(0);

      var d3graphElement = d3.select(graphElement);

      // up to parent with class "dagParentParent"
      var colParent = $(svgElement).find(".dagParent");

      // window.log('colParent ', colParent);
      
      if (colParent.width() == 0) {
        return;
      }

      var w     = window, 
          d     = document, 
          e     = d.documentElement, 
          gbody = d.getElementsByTagName('body')[0], 
          x = colParent.width() || w.innerWidth  || e.clientWidth  || gbody.clientWidth, 
          y =                      w.innerHeight || e.clientHeight || gbody.clientHeight;

      // window.log("-------------");

      // back to scale 1 !!! (euh, not sure that works, but it does not seem to harm)
      d3graphElement.attr("transform", "scale(1)");
      var unscaledGraphHeight = dagreD3graph.graph().height;
      
      var true_ratio_x = x / dagreD3graph.graph().width;
      var true_ratio_y = y / dagreD3graph.graph().height;

      var ratio_x = Math.min(true_ratio_x, 1);
      var ratio_y = Math.min(true_ratio_y, 1);

      // window.log(x + " / " + dagreD3graph.graph().width + " = " + true_ratio_x + ", using " + ratio_x);
      // window.log(y + " / " + dagreD3graph.graph().height + " = " + true_ratio_y + ", using " + ratio_y);

      var final_ratio = Math.min(ratio_x, ratio_y);

      // window.log(final_ratio);

      d3graphElement.attr("transform", "scale(" + final_ratio + ")");

      // adjust SVG height to content
      var h = final_ratio * unscaledGraphHeight;
      var newHeight = Math.ceil(h);

      newHeight = newHeight < 40 ? 40 : newHeight;
      // window.log('adjust SVG height to content', colParent, $(svgElement), newHeight);
      colParent.height(newHeight);

      // setup zoom
      d3.select(svgElement.get(0)).call(d3.behavior.zoom().on('zoom', function() {
        var ev = d3.event;
        d3graphElement.attr('transform', 'translate(' + ev.translate + ') scale(' + ev.scale + ')');
      }));
    };

    return {
        renderGraph : renderGraph,
        resizeGraph : resizeGraph,
        putTheStuffMan : putTheStuffMan
    };
  })();
})();
