package net.aequologica.neo.dagr.jaxrs;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.aequologica.neo.dagr.bus.AbhorrentNodeBus;
import net.aequologica.neo.dagr.bus.Event;

@javax.ws.rs.Path("/travis")
public class ResourceTravis extends AbstractResource {
    
    final static Logger log = LoggerFactory.getLogger("net.aequologica.neo.dagr.jaxrs");

    @POST
    @javax.ws.rs.Path("notifications")
    @Consumes("application/x-www-form-urlencoded")
    public Response receiveNotification(@FormParam("payload") String payload) throws Exception {
        
        try {
            log.debug("[travis] payload: {}", payload);
            System.out.println("[travis] payload: "+ payload.replace("\n", "").replace("\r", ""));
        
            // massage travis payload
            JsonObject travisPayload = mapper.readValue(payload, JsonObject.class);
            if (travisPayload == null) {
                Response.serverError().entity("failed to parse payload from [" + payload + "]").build();
            }
            
            String name = null;
            String owner_name = null;
            JsonObject repository = travisPayload.getJsonObject("repository");
            if (repository != null) {
                name = repository.getString("name");
                owner_name = repository.getString("owner_name");
            }
            final String branch = travisPayload.getString("branch");
            final int    status = travisPayload.getInt("status");
        
            if (name != null && branch != null) {
                Event.Type type = (status == 0 ? Event.Type.BUILD_OK : Event.Type.BUILD_ERROR);
                
                String owner_name_name = (owner_name != null && !owner_name.isEmpty() ? owner_name + '/' + name : name);
                
                log.debug("[travis] sending event {}, owner_name/name='{}', branch='{}' to the bus", type, owner_name_name, branch);
                System.out.println("[travis] sending event "+type+", owner_name/name='"+owner_name_name+"', branch='"+branch+"' to the bus");
                
                // balance dans le bus
                AbhorrentNodeBus.getInstance().send(type, owner_name_name, branch);
            }
        
            return Response.noContent().build();
        } catch (Exception e) {
            log.error("[bus] exception {} logged and re-thrown", e.getMessage());
            System.err.println("[bus] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        } finally {
        }
    }
    
}
