/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.websocket;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import net.aequologica.neo.dagr.websocket.DagSocketMessage;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;

public final class DagSocketMessageEncoderDecoder
implements Encoder<DagSocketMessage, String>,
Decoder<String, DagSocketMessage> {
    private final ObjectMapper mapper = new ObjectMapper();

    public DagSocketMessageEncoderDecoder() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public DagSocketMessage decode(String s) {
        try {
            DagSocketMessage dagSocketMessage = (DagSocketMessage)this.mapper.readValue(s, DagSocketMessage.class);
            return dagSocketMessage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String encode(DagSocketMessage dagSocketMessage) {
        try {
            return this.mapper.writeValueAsString((Object)dagSocketMessage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

