/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.mobile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import net.aequologica.neo.dagr.bus.AbhorrentNodeBus;
import net.aequologica.neo.dagr.bus.Event;
import net.aequologica.neo.dagr.config.DagrConfig;
import net.aequologica.neo.dagr.mobile.Listener$$Lambda$1;
import net.aequologica.neo.dagr.mobile.Listener$$Lambda$4;
import net.aequologica.neo.dagr.mobile.Listener$$Lambda$5;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.crypto.CodecPBEWithMD5AndDES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;

@WebListener
public class Listener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger((String)"net.aequologica.neo.dagr.mobile");
    private ObjectMapper mapper;
    private String googleCloudMessagingAPIKey;
    private Subscription subscription;

    public void contextInitialized(ServletContextEvent arg0) {
        this.mapper = new ObjectMapper();
        try {
            this.googleCloudMessagingAPIKey = new CodecPBEWithMD5AndDES().decrypt(((DagrConfig)ConfigRegistry.getConfig(DagrConfig.class)).getEncryptedGoogleCloudMessagingAPIKey().toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AbhorrentNodeBus bus = AbhorrentNodeBus.getInstance();
        this.subscription = bus.toObservable().filter(Listener$$Lambda$1.lambdaFactory$()).map(Listener$$Lambda$4.lambdaFactory$()).subscribe(Listener$$Lambda$5.lambdaFactory$(this));
        log.debug("[gcm] subbscribed !");
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            log.debug("[gcm] unsubscribed !");
        }
    }

    void sendNotification(Dag.Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getState().toString());
        sb.append(" ");
        sb.append(node.getName());
        sb.append(" @ ");
        sb.append("travis");
        String message = sb.toString();
        log.debug("[gcm] sending notification {} for node {} to google cloud messaging", (Object)message, (Object)node.getName());
        try {
            GCMMessage msg = new GCMMessage(new GCMMessage.Data(message));
            String gcmMessageAsString = this.mapper.writeValueAsString((Object)msg);
            URL url = new URL("https://android.googleapis.com/gcm/send");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", "key=" + this.googleCloudMessagingAPIKey);
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(gcmMessageAsString.getBytes(StandardCharsets.UTF_8));
            InputStream inputStream = conn.getInputStream();
            String responseText = CharStreams.toString((Readable)new InputStreamReader(inputStream));
            log.debug("[gcm] Check your device/emulator for notification or logcat for confirmation of the receipt of the GCM message. GCM Response text is {}", (Object)responseText);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$contextInitialized$2(Dag.Node node) {
        this.sendNotification(node);
    }

    private static /* synthetic */ Dag.Node lambda$contextInitialized$1(Event event) {
        return (Dag.Node)event.get();
    }

    private static /* synthetic */ Boolean lambda$contextInitialized$0(Event event) {
        return event.getType().equals((Object)Event.Type.BUILD_OK) || event.getType().equals((Object)Event.Type.BUILD_ERROR);
    }

    static /* synthetic */ Boolean access$lambda$0(Event event) {
        return Listener.lambda$contextInitialized$0(event);
    }

    static /* synthetic */ Dag.Node access$lambda$1(Event event) {
        return Listener.lambda$contextInitialized$1(event);
    }

    static /* synthetic */ void access$lambda$2(Listener listener, Dag.Node node) {
        listener.lambda$contextInitialized$2(node);
    }

    private static class GCMMessage {
        @JsonProperty
        private final String to = "/topics/global";
        @JsonProperty
        private Data data;

        public GCMMessage() {
        }

        public GCMMessage(Data data) {
            this.data = data;
        }

        private static class Data {
            @JsonProperty
            private String message;

            public Data() {
            }

            public Data(String message) {
                this.message = message;
            }
        }
    }
}

