/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.Dags;
import net.aequologica.neo.dagr.bus.AbhorrentNodeBus;
import net.aequologica.neo.dagr.bus.Event;
import net.aequologica.neo.dagr.jgrapht.DagJGraphT;
import net.aequologica.neo.dagr.model.Dag;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1")
public class ResourceDags<T> {
    private static final Logger log = LoggerFactory.getLogger((String)"net.aequologica.neo.dagr.jaxrs");
    @Context
    ServletContext context;
    private final Dags dags = Dags.getInstance();

    @GET
    @Path(value="")
    @Produces(value={"text/plain"})
    public String ping() {
        return "pong";
    }

    @POST
    @Path(value="/reload")
    @Produces(value={"application/json"})
    public Response reload() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.dags.load()).build();
    }

    @GET
    @Path(value="/pick-dag")
    @Produces(value={"text/html"})
    public Viewable pickDate(@Context HttpServletRequest request) throws Exception {
        return new Viewable("/WEB-INF/dagr/pick-dag");
    }

    @GET
    @Path(value="/dags")
    @Produces(value={"application/json"})
    public List<DagInfo> getUserDagInfos(@Context HttpServletRequest request) {
        String username = ResourceDags.getUsername(request);
        return this.getAllDagInfos(username);
    }

    @GET
    @Path(value="/dags/users/{user : .+}")
    @Produces(value={"application/json"})
    public List<DagInfo> getAllDagInfos(@PathParam(value="user") String username) {
        Collection dagsCollection = this.dags.getDAGs();
        List<DagInfo> ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @GET
    @Path(value="/dags")
    @Produces(value={"text/html"})
    public Viewable viewDags(@Context HttpServletRequest request) throws IOException {
        List ret;
        Collection dagsCollection = this.dags.getDAGs();
        String username = ResourceDags.getUsername(request);
        if (username == null) {
            ret = Collections.emptyList();
        } else {
            List<DagInfo> tmp = this.buildDagInfoList(dagsCollection, username);
            ret = new ArrayList();
            for (DagInfo dagInfo : tmp) {
                if (!dagInfo.getSubscribed().booleanValue()) continue;
                ret.add(dagInfo);
            }
        }
        return new Viewable("/WEB-INF/dagr/dags", ret);
    }

    @GET
    @Path(value="/dags/{dag : .+}")
    @Produces(value={"application/json"})
    public Dag getDAG(@PathParam(value="dag") String dagkey) throws Exception {
        Dag dag = this.dags.getDAG(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        return dag;
    }

    @GET
    @Path(value="/dags/{dag : .+}")
    @Produces(value={"text/html"})
    public Viewable getDAGasHTML(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws Exception {
        Dag dag = this.getDAG(dagkey);
        ArrayList<Dag> list = new ArrayList<Dag>();
        list.add(dag);
        String username = ResourceDags.getUsername(request);
        List<DagInfo> buildDagInfoList = this.buildDagInfoList(list, username);
        return new Viewable("/WEB-INF/dagr/dags", buildDagInfoList);
    }

    @GET
    @Path(value="/dags/{dag : .+}/topological")
    @Produces(value={"application/json"})
    public List<String> getTopological(@PathParam(value="dag") String dagkey) throws Exception {
        DagJGraphT dag = this.dags.getDagJGraphT(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        Function<Dag.Node, String> node2nodeId = new Function<Dag.Node, String>(){

            public String apply(Dag.Node node) {
                return node.getId();
            }
        };
        return Lists.newArrayList((Iterator)Iterators.transform((Iterator)dag.getTopologicalOrderIterator(), (Function)node2nodeId));
    }

    @GET
    @Path(value="/dags/{dag : .+}/topologicartifacts")
    @Produces(value={"application/json"})
    public List<String> getTopologicartifacts(@PathParam(value="dag") String dagkey) throws Exception {
        DagJGraphT dag = this.dags.getDagJGraphT(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        Function<Dag.Node, String> node2artifactId = new Function<Dag.Node, String>(){

            public String apply(Dag.Node node) {
                Dag.NodeValue value = node.getValue();
                if (value == null) {
                    return node.getId();
                }
                String gubrid = value.getGubrid();
                if (gubrid == null || gubrid.length() == 0) {
                    return node.getId();
                }
                Iterable split = Splitter.on((char)':').split((CharSequence)gubrid);
                Iterator iterator = split.iterator();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String groupId = (String)iterator.next();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String artifactId = (String)iterator.next();
                if (artifactId == null || artifactId.toString().length() == 0) {
                    return node.getId();
                }
                return artifactId;
            }
        };
        return Lists.newArrayList((Iterator)Iterators.transform((Iterator)dag.getTopologicalOrderIterator(), (Function)node2artifactId));
    }

    @GET
    @Path(value="/dags/{dag : .+}/nodes")
    @Produces(value={"application/json"})
    public List<Dag.Node> getDAGNodes(@PathParam(value="dag") String dagkey) throws Exception {
        Dag dag = this.getDAG(dagkey);
        return dag.getNodes();
    }

    @GET
    @Path(value="/dags/{dag : .+}/nodes/{nodename : .+}")
    @Produces(value={"application/json"})
    public Dag.Node getDAGNode(@PathParam(value="dag") String dagkey, @PathParam(value="nodename") String nodeName) throws Exception {
        Dag dag = this.getDAG(dagkey);
        List nodes = dag.getNodesNamedAs(nodeName);
        if (nodes.size() == 0) {
            throw new WebApplicationException("dag [" + dagkey + "] node + [" + nodeName + "] + not found", Response.Status.NOT_FOUND);
        }
        if (nodes.size() > 1) {
            throw new WebApplicationException("application error. multiple nodes with the same name is not supported", Response.Status.NOT_IMPLEMENTED);
        }
        return (Dag.Node)nodes.get(0);
    }

    @GET
    @Path(value="/dags/{dag : .+}/nodes/{nodename : .+}/state")
    @Produces(value={"application/json"})
    public Dag.Node.State getDAGNodeState(@PathParam(value="dag") String dagkey, @PathParam(value="nodename") String nodeName) throws Exception {
        Dag.Node node = this.getDAGNode(dagkey, nodeName);
        return node.getState();
    }

    private void sendBusEvent(Event.Type eventType, Dag.Node node) {
        log.debug("[dagr-api] sending event {}, owner_name/name='{}', branch='{}' to the bus", new Object[]{eventType, node.getName(), node.getValue().getBranch()});
        System.out.println("[dagr-api] sending event " + (Object)((Object)eventType) + ", owner_name/name='" + node.getName() + "', branch='" + node.getValue().getBranch() + "' to the bus");
        AbhorrentNodeBus.getInstance().send(eventType, node.getName(), node.getValue() != null ? node.getValue().getBranch() : null);
    }

    @POST
    @Path(value="/dags/{dag : .+}/nodes/{nodename : .+}/state/{state : .+}")
    @Produces(value={"application/json"})
    public Response setDAGNodeState(@PathParam(value="dag") String dagkey, @PathParam(value="nodename") String nodeName, @PathParam(value="state") Dag.Node.State state) throws Exception {
        Dag.Node node;
        block5: {
            node = this.getDAGNode(dagkey, nodeName);
            this.sendBusEvent(Event.Type.STATE_CHANGE_HACK, node);
            if (!node.getState().equals((Object)state)) break block5;
            Response response = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            return response;
        }
        try {
            node.setState(state);
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (Exception e) {
            log.error("[dagr-api] exception {} logged and re-thrown", (Object)e.getMessage());
            System.err.println("[dagr-api] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        }
    }

    @POST
    @Path(value="/dags/{dag : .+}/nodes/{nodename : .+}/event/{event : .+}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response sendBusEvent(String cleaner, @PathParam(value="dag") String dagkey, @PathParam(value="nodename") String nodeName, @PathParam(value="event") Event.Type eventType) throws Exception {
        System.out.println("cleaner uuid: " + cleaner);
        try {
            Dag.Node node = this.getDAGNode(dagkey, nodeName);
            node.setCleaner(cleaner);
            this.sendBusEvent(eventType, node);
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (Exception e) {
            log.error("[dagr-api] exception {} logged and re-thrown", (Object)e.getMessage());
            System.err.println("[dagr-api] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        }
    }

    @GET
    @Path(value="/dags/subscription")
    @Produces(value={"application/json"})
    public List<DagInfo> getUserDAGs(@Context HttpServletRequest request) throws Exception {
        String username = ResourceDags.getUsername(request);
        if (username == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List dagsCollection = this.dags.getUserDAGs(username);
        List<DagInfo> ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @POST
    @Path(value="/dags/subscription/{dag : .+}")
    public Response subscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = ResourceDags.getUsername(request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.subscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    @DELETE
    @Path(value="/dags/subscription/{dag : .+}")
    public Response unsubscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = ResourceDags.getUsername(request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.unsubscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    private List<DagInfo> buildDagInfoList(Collection<Dag> dagsCollection, String username) {
        ArrayList<DagInfo> ret = new ArrayList<DagInfo>(dagsCollection.size());
        for (Dag dag : dagsCollection) {
            DagInfo dagInfo = new DagInfo();
            dagInfo.name = dag.getName();
            dagInfo.key = dag.getKey();
            dagInfo.url = dag.getSource();
            dagInfo.username = username;
            dagInfo.subscribed = username == null ? false : this.dags.isUserSubscribed(dag.getKey(), username);
            ret.add(dagInfo);
        }
        return ret;
    }

    private static String getUsername(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        String username = userPrincipal.getName();
        if (username == null || username.isEmpty()) {
            return null;
        }
        return username;
    }

    public static class DagInfo {
        private String name;
        private String key;
        private String url;
        private Boolean subscribed;
        private String username;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Boolean getSubscribed() {
            return this.subscribed;
        }

        public void setSubscribed(Boolean subscribed) {
            this.subscribed = subscribed;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

