<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ page import="net.aequologica.neo.geppaequo.servlet.WebJar"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><t:layout jsmodules="angular moment" not_decorate="true">

  <style>
  ul {
    list-style-type: none;
    margin  : 0;
    padding : 0;
  }
  </style>
  <div ng-app="DagApplication">

  <section ng-controller="DagController">
    <button type="button" class="btn btn-default" ng-click="send()">send</button><button type="button" class="btn btn-default" ng-click="clear()">clear</button>
    <ul>
      <li ng-repeat="data in MyData.collection | orderBy:'-' track by $index ">
        {{ data }}
      </li>
    </ul>
  </section>

</div>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/angular-websocket.js")%>' />" ></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("d3.min.js")%>' />" ></script>

<script>

  var getNodes = function() {
    var $nodes = $('g.node', window.parent.document);
    return $nodes;
  }
  
  var getNode = function(nodeId) {
    var $node = $('g.node#' + nodeId, window.parent.document);
    return $node;
  }
  
  var getNodeRect = function(nodeId) {
    var $nodeRect = $('g.node#' + nodeId + ' rect', window.parent.document);
    return $nodeRect;
  }
  
  angular.module('DagApplication', [
    'angular-websocket' // you may also use 'ngWebSocket' if you prefer
  ])
  .factory('MyData', function($websocket) {
    // Open a WebSocket connection
    var url  = 'ws'
             <c:if test="${pageContext.request.secure}">
             + 's'
             </c:if>
             + '://'
             + '${pageContext.request.serverName}'
             + ':'
             + '${pageContext.request.serverPort}'
             + '${pageContext.request.contextPath}'
             + '/patata';
    
    var dataStream = $websocket(url);

    var collection = [];

    dataStream.onMessage(function(atmosphereMessage) {
      window.log(atmosphereMessage);
      
      // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
      function tryParseJSON (jsonString){
        try {
            var o = JSON.parse(jsonString);

            // Handle non-exception-throwing cases:
            // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
            // but... JSON.parse(null) returns 'null', and typeof null === "object", 
            // so we must check for that, too.
            if (o && typeof o === "object" && o !== null) {
                return o;
            }
        }
        catch (e) { }

        return false;
    };
    
    
    var messages = atmosphereMessage.data.split('|');

    if (messages.length < 2) {
      messages = [atmosphereMessage];
    } else {
      messages.shift();
    }
    var len = messages.length;

    for (i=0; i<len; ++i) {
      var message = messages[i];
      var parsed = tryParseJSON(message)
      if (parsed) {
          collection.push(parsed);

          var $node = getNode(parsed.node.id);
          $node.removeClass("<%=net.aequologica.neo.dagr.model.Dag.Node.State.gimmethestuff()%>").addClass(parsed.node.state);

      } else {
          collection.push(message);
          
          $('#idspy', window.parent.document).text(message);
      }
    }

    });

    var myFunction = function(){ 
      var $nodes = getNodes();
      $($nodes[Math.floor(Math.random()*$nodes.length)]).each(function(){
        var id = $(this).attr('id');
        var name = $(this).attr('name');
        dataStream.send(JSON.stringify({node:{id: id, name: name, state: $(this).hasClass('DIRTY') ? 'CLEAN' : 'DIRTY'}}));
      });
    }
    
    var methods = {
      collection: collection,
      get: function() {
        return setInterval(myFunction, 300);
      }
    };

    return methods;
  })
  .controller('DagController', function ($scope, MyData) {
    $scope.MyData = MyData;
    $scope.send = function() {
      if (!MyData.myVar) {
        MyData.myVar = MyData.get();
      }
    }
    $scope.clear = function() {
      MyData.collection.length = 0;
      if (MyData.myVar) {
          clearInterval(MyData.myVar);
          MyData.myVar = undefined;
      }
    }
  });
</script>
