/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.bus.AbhorrentNodeBus;
import net.aequologica.neo.dagr.bus.Event;
import net.aequologica.neo.dagr.jaxrs.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/travis")
public class ResourceTravis
extends AbstractResource {
    static final Logger log = LoggerFactory.getLogger((String)"net.aequologica.neo.dagr.jaxrs");

    @POST
    @Path(value="notifications")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response receiveNotification(@FormParam(value="payload") String payload) throws Exception {
        try {
            log.debug("[travis] payload: {}", (Object)payload);
            System.out.println("[travis] payload: " + payload.replace("\n", "").replace("\r", ""));
            JsonObject travisPayload = (JsonObject)this.mapper.readValue(payload, JsonObject.class);
            if (travisPayload == null) {
                Response.serverError().entity((Object)("failed to parse payload from [" + payload + "]")).build();
            }
            String name = null;
            String owner_name = null;
            JsonObject repository = travisPayload.getJsonObject("repository");
            if (repository != null) {
                name = repository.getString("name");
                owner_name = repository.getString("owner_name");
            }
            String branch = travisPayload.getString("branch");
            int status = travisPayload.getInt("status");
            if (name != null && branch != null) {
                Event.Type type = status == 0 ? Event.Type.BUILD_OK : Event.Type.BUILD_ERROR;
                String owner_name_name = owner_name != null && !owner_name.isEmpty() ? owner_name + '/' + name : name;
                log.debug("[travis] sending event {}, owner_name/name='{}', branch='{}' to the bus", new Object[]{type, owner_name_name, branch});
                System.out.println("[travis] sending event " + type + ", owner_name/name='" + owner_name_name + "', branch='" + branch + "' to the bus");
                AbhorrentNodeBus.getInstance().send(type, owner_name_name, branch);
            }
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            log.error("[bus] exception {} logged and re-thrown", (Object)e.getMessage());
            System.err.println("[bus] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        }
    }
}

