/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import java.io.IOException;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.bus.AbhorrentNodeBus;
import net.aequologica.neo.dagr.bus.Event;
import net.aequologica.neo.dagr.jaxrs.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/github")
public class ResourceGithub
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger((String)"net.aequologica.neo.dagr.jaxrs");

    @POST
    @Path(value="/notification")
    @Consumes(value={"application/json"})
    public Response getPushNotification(String payload) throws IOException {
        try {
            log.debug("[github] payload: {}", (Object)payload);
            System.out.println("[github] payload: " + payload.replace("\n", "").replace("\r", ""));
            JsonObject githubPushPayload = (JsonObject)this.mapper.readValue(payload, JsonObject.class);
            String repo_fullname = null;
            String ref = githubPushPayload.getString("ref");
            JsonObject repositoryObject = githubPushPayload.getJsonObject("repository");
            if (repositoryObject != null) {
                repo_fullname = repositoryObject.getString("full_name");
            }
            if (repo_fullname != null && ref != null) {
                log.debug("[bus] sending event {}, repo_fullname='{}', ref='{}' to the bus", new Object[]{Event.Type.PUSH, repo_fullname, ref});
                System.out.println("[bus] sending event " + Event.Type.PUSH + ", repo_fullname='" + repo_fullname + "', ref='" + ref + "' to the bus");
                AbhorrentNodeBus.getInstance().send(Event.Type.PUSH, repo_fullname, ref);
            }
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            log.error("[github] exception {} logged and re-thrown", (Object)e.getMessage());
            System.err.println("[github] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        }
    }
}

