package net.aequologica.neo.dagr.websocket;

import java.io.IOException;

import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.aequologica.neo.dagr.bus.AbhorrentNodeBus;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.model.Dag.Node;
import rx.Subscription;

@ManagedService(path = "/patata")
public final class DagSocket{
    private static final Logger logger = LoggerFactory.getLogger(DagSocket.class);

    private Bus<Node> bus = AbhorrentNodeBus.getInstance();
    private Subscription subscription;
    
    @Ready
    public final void onReady(final AtmosphereResource r){
        logger.info("Browser {} connected.", r.uuid());
        
        subscription = bus.toObservable()
                .map(nodeevent -> nodeevent.get())
                .subscribe(node -> broadcast(r.getBroadcaster(), node));
        
        logger.debug("[websocket] [broadcaster:#"+r.getBroadcaster().hashCode()+"] subscribed !");
    }

    private Node broadcast(Broadcaster broadcaster, Node node) {
        try {
            logger.debug("[websocket] received node '{}' from the bus", node.getName());
            System.out.println("[websocket] received node '" + node.getName() + "' from the bus");
            
            DagSocketMessage dagSocketMessage = new DagSocketMessage();
            dagSocketMessage.setNode(node);
            DagSocketMessageEncoderDecoder qwe = new DagSocketMessageEncoderDecoder();
            String encoded = qwe.encode(dagSocketMessage);
            logger.debug("[websocket] [broadcaster:#{}] about to broadcast: |{}|", broadcaster.hashCode(), encoded);
            System.out.println("[websocket] [broadcaster:#"+broadcaster.hashCode() +"] about to broadcast: |"+encoded+"|");
            broadcaster.broadcast(encoded);

            return node;
        } catch (Exception e) {
            logger.error("[websocket] exception {} logged and re-thrown", e.getMessage());
            System.err.println("[websocket] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        } finally {
        }
    }

    @Disconnect
    public final void onDisconnect(final AtmosphereResourceEvent event){
        
        subscription.unsubscribe();
        logger.debug("[websocket] [broadcaster:#{}] usubscribed !", event.getResource().getBroadcaster().hashCode());
        
        if(event.isCancelled())
            logger.info("Browser {} unexpectedly disconnected", event.getResource().uuid());
        else if(event.isClosedByClient())
            logger.info("Browser {} closed the connection", event.getResource().uuid());
    }

    @Message(encoders = {DagSocketMessageEncoderDecoder.class}, decoders = {DagSocketMessageEncoderDecoder.class})
    public final DagSocketMessage onMessage(final DagSocketMessage message) throws IOException{
        logger.info("{} is {}", message.getNode().getName(), message.getNode().getState());
        System.err.println( message.getNode().getName()+" is "+message.getNode().getState());
        return message;
    }
    
}