/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.websocket;

import java.io.IOException;
import net.aequologica.neo.dagr.bus.AbhorrentNodeBus;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.Event;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.websocket.DagSocket$$Lambda$1;
import net.aequologica.neo.dagr.websocket.DagSocket$$Lambda$2;
import net.aequologica.neo.dagr.websocket.DagSocketMessage;
import net.aequologica.neo.dagr.websocket.DagSocketMessageEncoderDecoder;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;

@ManagedService(path="/patata")
public final class DagSocket {
    private static final Logger logger = LoggerFactory.getLogger(DagSocket.class);
    private Bus<Dag.Node> bus = AbhorrentNodeBus.getInstance();
    private Subscription subscription;

    @Ready
    public final void onReady(AtmosphereResource r) {
        logger.info("Browser {} connected.", (Object)r.uuid());
        this.subscription = this.bus.toObservable().map(DagSocket$$Lambda$1.lambdaFactory$()).subscribe(DagSocket$$Lambda$2.lambdaFactory$(this, r));
        logger.debug("[websocket] [broadcaster:#" + r.getBroadcaster().hashCode() + "] subscribed !");
    }

    private Dag.Node broadcast(Broadcaster broadcaster, Dag.Node node) {
        try {
            logger.debug("[websocket] received node '{}' from the bus", (Object)node.getName());
            System.out.println("[websocket] received node '" + node.getName() + "' from the bus");
            DagSocketMessage dagSocketMessage = new DagSocketMessage();
            dagSocketMessage.setNode(node);
            DagSocketMessageEncoderDecoder qwe = new DagSocketMessageEncoderDecoder();
            String encoded = qwe.encode(dagSocketMessage);
            logger.debug("[websocket] [broadcaster:#{}] about to broadcast: |{}|", (Object)broadcaster.hashCode(), (Object)encoded);
            System.out.println("[websocket] [broadcaster:#" + broadcaster.hashCode() + "] about to broadcast: |" + encoded + "|");
            broadcaster.broadcast((Object)encoded);
            Dag.Node node2 = node;
            return node2;
        }
        catch (Exception e) {
            logger.error("[websocket] exception {} logged and re-thrown", (Object)e.getMessage());
            System.err.println("[websocket] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        }
    }

    @Disconnect
    public final void onDisconnect(AtmosphereResourceEvent event) {
        this.subscription.unsubscribe();
        logger.debug("[websocket] [broadcaster:#{}] usubscribed !", (Object)event.getResource().getBroadcaster().hashCode());
        if (event.isCancelled()) {
            logger.info("Browser {} unexpectedly disconnected", (Object)event.getResource().uuid());
        } else if (event.isClosedByClient()) {
            logger.info("Browser {} closed the connection", (Object)event.getResource().uuid());
        }
    }

    @Message(encoders={DagSocketMessageEncoderDecoder.class}, decoders={DagSocketMessageEncoderDecoder.class})
    public final DagSocketMessage onMessage(DagSocketMessage message) throws IOException {
        logger.info("{} is {}", (Object)message.getNode().getName(), (Object)message.getNode().getState());
        System.err.println(message.getNode().getName() + " is " + message.getNode().getState());
        return message;
    }

    private /* synthetic */ void lambda$onReady$4(AtmosphereResource atmosphereResource, Dag.Node node) {
        this.broadcast(atmosphereResource.getBroadcaster(), node);
    }

    private static /* synthetic */ Dag.Node lambda$onReady$3(Event nodeevent) {
        return (Dag.Node)nodeevent.get();
    }

    static /* synthetic */ Dag.Node access$lambda$0(Event event) {
        return DagSocket.lambda$onReady$3(event);
    }

    static /* synthetic */ void access$lambda$1(DagSocket dagSocket, AtmosphereResource atmosphereResource, Dag.Node node) {
        dagSocket.lambda$onReady$4(atmosphereResource, node);
    }
}

