<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ page import="net.aequologica.neo.geppaequo.servlet.WebJar"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><t:layout jsmodules="angular" >

<div ng-app="DagApplication">

  <section ng-controller="DagController">
    <ul>
      <li ng-repeat="data in MyData.collection track by $index">
        {{ data }}
      </li>
    </ul>
    <button type="button" class="btn btn-default" ng-click="send()">send</button>
  </section>

</div>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/angular-websocket.js")%>' />" ></script>

<script>

  angular.module('DagApplication', [
    'angular-websocket' // you may also use 'ngWebSocket' if you prefer
  ])
  .factory('MyData', function($websocket) {
    // Open a WebSocket connection
    var url  = 'ws'
             <c:if test="${pageContext.request.secure}">
             + 's'
             </c:if>
             + '://'
             + '${pageContext.request.serverName}'
             + ':'
             + '${pageContext.request.serverPort}'
             + '${pageContext.request.contextPath}'
             + '/patati';
    
    var dataStream = $websocket(url);

    var collection = [];

    dataStream.onMessage(function(message) {
      window.log(message);
      
      // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
      function tryParseJSON (jsonString){
        try {
            var o = JSON.parse(jsonString);

            // Handle non-exception-throwing cases:
            // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
            // but... JSON.parse(null) returns 'null', and typeof null === "object", 
            // so we must check for that, too.
            if (o && typeof o === "object" && o !== null) {
                return o;
            }
        }
        catch (e) { }

        return false;
    };
    
    var data = message.data.replace(/\d+\|(\{.*\})/g, "$1");
    var parsed = tryParseJSON(data)
    if (parsed) {
        collection.push(parsed.message);
    } else {
        collection.push(message.data);
    }
    });

    var methods = {
      collection: collection,
      get: function() {
        dataStream.send(JSON.stringify({"message":"asd","author":"Christophe 2"}));
      }
    };

    return methods;
  })
  .controller('DagController', function ($scope, MyData) {
    $scope.MyData = MyData;
    $scope.send = function() {
      MyData.get();
    }
  });
</script>
