;(function( $ ){
  
  function Nexus(gap, policy, nexusBase, repository, redirectJSP) {
    this.title  = "nexus " + repository;
    this.url    = nexusBase;
    this.policy = policy;
    
    this.resolveURL = function() {
      return nexusBase + "/service/local/artifact/maven/resolve?" +
                      "g=" + gap.group     +
                     "&a=" + gap.artifact  +
                     "&v=" + "LATEST"      +
                     "&p=" + gap.packaging +
                     "&r=" + repository ;
    };

    this.downloadURL = function(version) {
      return nexusBase + "/service/local/artifact/maven/content?" +
                      "g=" + gap.group     +
                     "&a=" + gap.artifact  +
                     "&v=" + version       +
                     "&p=" + gap.packaging +
                     "&r=" + repository;
    };
    
    this.siteURL = function(version) {
      return nexusBase + "/content/unzip/build.milestones.unzip/" +
                          gap.group.replace(/\./gi, '/') + '/' +
                          gap.artifact                   + '/' +
                          version                        + '/' +
                          gap.artifact + "-" + version +'-site.jar-unzip/';
    }

    this.browseURL    =  function() {
      return nexusBase + "/index.html#nexus-search;gav~"+gap.group+"~"+gap.artifact+"~~~";
    };

    this.parseVersion = function(xmlResponse) {
      var $versionNode = $(xmlResponse).find( "version" );
      if ($versionNode.length == 0) {
          return undefined;
      }
      return $versionNode.text();
    };

    this.ajax = function() {
      return $.ajax( {
        cache    : false,
        dataType : "xml",
        url      : redirectJSP + encodeURIComponent(this.resolveURL())
      });
    };

    return this;
  }
  
  function MavenCentral(gap, redirectJSP) {
    this.title  = "maven central";
    this.url    = "http://search.maven.org";
    this.policy = "release";
    // window.log(gap.group + ' ' + gap.artifact + ' ' + gap.packaging);

    this.resolveURL = function() {
      return this.url + "/solrsearch/select?" +
                  "q="    + ("g:%22"+gap.group+"%22+AND+a:%22"+gap.artifact+"%22") +
                 "&core=" + "gav" +
                 "&rows=" + "2"   +
                 "&wt="   + "json";
    };

    this.downloadURL = function(version) {
      return this.url + "/remotecontent?" +
                        "filepath=" + (gap.group.replace(/\./gi, '/') + '/' +
                                       gap.artifact                   + '/' +
                                       version                        + '/' +
                                       gap.artifact + "-" + version + '.' + gap.packaging);
    }
    
    this.siteURL = function(version) {
      return undefined;
    }

    this.browseURL =  function(gap) {
      return this.url + "/#search%7Cga%7C1%7Cg%3A%22"+gap.group+"%22%20AND%20a%3A%22"+gap.artifact+"%22";
    };

    this.parseVersion = function(jsonResponse) {
      if (!jsonResponse.response.docs.length) {
          return undefined;
      }
      return jsonResponse.response.docs[0].v;
    }
    
    this.ajax = function() {
      return $.ajax( {
        cache    : false,
        dataType : "json",
        url      : redirectJSP + encodeURIComponent(this.resolveURL())
      });
    };

    return this;
  }
  
  var global = {};
  
  $.extend({ 
    geppaefact : function(config) {
        global = config;
    }
  });
  
  $.fn.extend({ 
    
    geppaefact: function(config) {
      
      var $this = this;
      
      config.before = config.before || global.before || function ($zeElement, ajaxLoadingImg, server) {

        $zeElement.find('.ajaxLoading').show().attr({src: ajaxLoadingImg}).on('click', function() {go();} );
        $zeElement.find('#version').empty();        
        $zeElement.find('.gav').wrap($('<a>').attr({
          href   : server.browseURL,
          target : server.title,
          title  : "browse all versions"}));
      }
      
      config.callback = config.callback || global.callback || function($zeElement, data, server) {
        if (!data.status) {
          $zeElement.find('#error').text(data.errorThrown + ' - ' + data.textStatus);
        } else {
          if (data.version) {
            $zeElement.find('#version').text(data.version);
          }
       
          if (data.downloadURL) {
            $zeElement
              .find('#download')
              .wrap($('<a>')
                .attr({ href  : data.downloadURL,
                        title : "download"  }));
          }
        }
      }
      
      config.after =  config.after || global.after || function($zeElement, ajaxLoadedImg) {
        setTimeout(function() { 
          var $loading = $zeElement.find('.ajaxLoading');
          
          $loading.attr({src:ajaxLoadedImg});
        }, 666);
      }

      config.gap = config.gap || {
          group     : $this.find('.gav #group').text(),
          artifact  : $this.find('.gav #artifact').text(),
          packaging : $this.find('.gav #packaging').text()
      }
      
      config.redirectJSP = config.redirectJSP || global.redirectJSP;
      
      if (config.server.type == "nexus") {
        var server = new Nexus(config.gap, config.server.policy, config.server.base, config.server.repo, config.redirectJSP); 
      } else {
        var server = new MavenCentral(config.gap, config.redirectJSP); 
      }
      
      this.find('.server')
          .html(server.title)
          .wrap($('<a>')
            .attr({ href   : server.url,
                    title  : server.title,
                    target : server.title}));
      
      var ajaxLoading = config.ajaxLoading || global.ajaxLoading;
      var ajaxLoaded  = config.ajaxLoaded || global.ajaxLoaded;
      
      var go = function() {
        // window.log('before');
        config.before($this, ajaxLoading, server);
        
        // window.log('callback');
        var artifactPromise = server.ajax();

        artifactPromise.done(function(response) {
          var version = server.parseVersion(response);
          var downloadURL = undefined;
          if (typeof version !== "undefined") {
            downloadURL = server.downloadURL(version);
          }

          config.callback($this, {
            status       : (typeof version !== "undefined" && typeof downloadURL !== "undefined"),
            version      : version,
            downloadURL  : downloadURL,
            siteURL      : server.siteURL(version)
          },
          server);
        });

        artifactPromise.fail(function(  jqXHR, textStatus, errorThrown ) {
          config.callback($this, {
            status       : false,
            version      : undefined,
            downloadURL  : undefined,
            siteURL      : undefined,
            textStatus   : textStatus,
            errorThrown  : errorThrown
          },
          server);
        });
          
        artifactPromise.always(function() {
          // window.log('after');
          config.after($this, ajaxLoaded, server);
        });

      };

      go();
      
    }
  });
})( jQuery );
