<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><t:layout jsmodules="angular">

  <style>
    .toprightfloatingtoolbar {
      float:right; 
      white-space: nowrap; 
      overflow: hidden;
    }
    ul {
      list-style-type: none;
    }
    span#back_to_index {
      white-space: nowrap; 
      overflow:hidden;
    }
  </style>

  <div>
    <span class="toprightfloatingtoolbar" style="font-size:larger">
      <c:if test="${not empty pageContext.request.remoteUser}">
      <a href="<c:url value='/modules/dagr/'/>"           title="show dag(s)"><i class="fa fa-paw"></i></i></a>
      </c:if>
      <a href="<c:url value='/modules/dagr/how-to.jsp'/>" title="how-to"     ><i class="fa fa-question-circle"></i></a>
    </span>

    <span id="back_to_index" class="alert alert-info" style="display: inline-block;">
      <span class="label label-info">info</span>
      <c:if test="${not empty pageContext.request.remoteUser}">
      <span">click the <a href="<c:url value='/dagr-api/dags/'/>">top right <i class="fa fa-paw"></i> icon</a> to display selected dag(s)</span>
      </c:if>
      <c:if test="${empty pageContext.request.remoteUser}">
      <span">click on a dag</span>
      </c:if>
    </span>
  </div>

  <div ng-app="ngAppDAGs">
    <h2>all DAGs</h2>
    <div ng-controller="DAGsCtrl">
      <ul class="unstyled col-lg-8">
        <li ng-repeat="dag in dags| orderBy:'name'" style="border-bottom: 1px dashed #999;">
          <c:if test="${not empty pageContext.request.remoteUser}">
          <input type="checkbox" ng-model="dag.subscribed" ng-change="change()"/>
          </c:if>
          <a href="<c:url value='/dagr-api/dags/'/>{{dag.key}}">
            {{dag.name}}
          </a>
        </li>
      </ul>
    </div>
  </div>

</t:layout>

<script type="text/javascript">

angular.module('ngAppDAGs', ['angular-loading-bar'])
.config(function(cfpLoadingBarProvider) {
  cfpLoadingBarProvider.includeSpinner = true;
})
.controller( 'DAGsCtrl',

  function($scope, $http) {
    $scope.dags   = [];
    $http({
        method: 'GET',
        url: "<c:url value='/dagr-api/dags' />",
      }).success(function(data, status, headers, config) {
        $scope.dags = data;
      }).error(function(data, status, headers, config) {
        $scope.dags = [];
    });

    $scope.change = function() {
        $http({
            method: this.dag.subscribed ? 'POST': 'DELETE',
            url: "<c:url value='/dagr-api/dags/subscription/' />"+this.dag.key
        });
    };
  }
);

</script>
