<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ page import="net.aequologica.neo.geppaequo.servlet.WebJar"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><% net.aequologica.neo.geppaequo.servlet.ZeroUtils.HostContextUserAccountAndApp(request);
%><t:layout module="dagr" jsmodules="modernizr datatables moment handlebars">

<style>
.toprightfloatingtoolbar {
  float:right; 
  white-space: nowrap; 
  overflow: hidden;
}

span#no_tab_defined {
  white-space: nowrap; 
  overflow:hidden;
}

.dagParent {
  padding: 20px 0 0 0;
  // border: 1px solid #ddd;
}

.dag .node rect {
  stroke: #bbb;
  fill: none;
}

.dag .edgePath path {
  stroke: #444;
  stroke-width: 1px;
  fill: none;
}

td, th  {
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

a > span.date {
  margin-left: .5em;
  font-size: smaller;
}

svg {
   cursor : move;
}

g.node, g.node > rect, g.node > g > g > text {
   cursor: pointer;
}
.ear {
  margin: 0 0 10px 0;
  cursor: pointer;
}

li.active .ear.star.active {
  color: green;
}

li .ear.star.active {
  color: gray;
}

li .ear.star {
  color: orange;
}

.fa-medium {
  margin: 0 0 0 10px;
  font-size : smaller;
}

</style>

<div>
  <span class="toprightfloatingtoolbar" style="font-size:larger">
    <a href="javascript:void(0)" id="shorten" data-toggle="tooltip" title="short/long label" ><i class="fa fa-minus-square"></i></a>
    <a href="<c:url value='/modules/dagr/dags.jsp'/>" data-toggle="tooltip" title="select dag(s)"><i class="fa fa-list"/></i></a>
    <a href="<c:url value='/modules/dagr/how-to.jsp'/>" data-toggle="tooltip" title="how-to" ><i class="fa fa-question-circle"/></i></a>
    <span id="idspy" data-toggle="tooltip" title="dag id" style="display: none;"></i></span>
  </span>

  <span id="no_tab_defined" class="alert alert-warning" style="display:none;" >
    <span class="label label-warning">warning</span>
    <span>no DAG selected; click the <a href="<c:url value='/modules/dagr/dags.jsp'/>">top right <i class="fa fa-list"></i> icon</a> to select a DAG.</span>
  </span>
</div>

  <div id="container">
  </div>

<%-- BEGIN ------------------ handlebars templates ------------------ BEGIN --%>

<script id="basic_template" type="text/x-handlebars-template"
><tr id="{{this.key}}" >
<td ><span class="index"    >{{this.index   }}</span></td>
<td ><span class="artifact" >{{this.artifact}}</span></td>
</tr></script>

<script id="gav_header_template" type="text/x-handlebars-template"
><tr>
<th>order</th>
<th>artifact</th>
<th>version</th>
<th><a href='
  {{this.buildServer.url}}' target='
  {{this.buildServer.title}}' data-toggle='tooltip' title='
  {{this.buildServer.url}}'>
  build</a></th>
<th><a href='
  {{this.snapshotServer.url}}' target='
  {{this.snapshotServer.title}}' data-toggle='tooltip' title='
  {{this.snapshotServer.url}}'>
  {{this.snapshotServer.policy}}
</a></th>
<th><a href='
  {{this.releaseServer.url}}' target='
  {{this.releaseServer.title}}' data-toggle='tooltip' title='
  {{this.releaseServer.url}}'>
  {{this.releaseServer.policy}}
</a></th>
<th><a href='
  {{this.sourceServer.url}}' target='
  {{this.sourceServer.title}}' data-toggle='tooltip' title='
  {{this.sourceServer.url}}'>
  source</a></th>
</tr></script>

<script id="gav_template" type="text/x-handlebars-template"
><tr id="{{this.key}}" >
<td ><span class="index"    >{{this.index   }}</span></td>
<%-- td style="display:none" ><span class="group"  >{{this.group   }}</span></td --%>
<td ><span class="artifact" data-toggle="tooltip" title="{{this.group}}:{{this.artifact}}:{{this.version}}">{{this.artifact}}</span></td>
<td ><span class="version"  >{{this.version }}</span></td>
<td >
  <span class="travis" id="{{this.repoid}}" style="display: none;">
    <a href="https://travis-ci.org/{{this.reponame}}" data-toggle="tooltip" title="https://travis-ci.org/{{this.reponame}}" target="travis">
    {{#if this.branch}}
      <img src="https://travis-ci.org/{{this.reponame}}.svg?branch={{this.branch}}" onerror="this.src=''" ></img>
    {{/if}}
    </a>
    &nbsp;
    <a class="trigger btn btn-default btn-xs" 
        id="{{this.repoid}}" 
        data-toggle="tooltip" title="rebuild {{this.reponame}}" 
        data-original-title="rebuild {{this.reponame}}"
        href="javascript:void(0)"></a>
  </span>
</td>
<td id="snapshot"><img class="ajaxLoading" ></img><span id="download"><span id="version">x.y.z</span></span></td>
<td id="release"> <img class="ajaxLoading" ></img><span id="download"><span id="version">X.Y.Z</span></span></td>
<td>
  <span class="scm" data-toggle="tooltip" title="{{this.scm}}">
    {{#if this.scmurl}}
      <a href="{{this.scmurl}}" target="github">
    {{/if}}
    {{this.scmtrunked}}
    {{#if this.scmurl}}
      </a>
    {{/if}}
  </span>
</td>
</tr></script>

<script id="tab_definitions" type="text/x-handlebars-template"
><ul class="nav nav-tabs">
  {{#each items}}
    <li>
      <a id="tab_{{this.id}}" href="#tab{{this.id}}" data-id="{{this.id}}" data-toggle="tab">{{this.name}}
        <span id="listening{{this.id}}" class="ear {{clazz}}" data-id="{{this.id}}" style="margin: 0 0 10px 0; cursor: pointer;" data-toggle="tooltip" title="subscription">
          <i class="fa fa-{{this.clazz}}"></i>
        </span>      
      </a>
    </li>
  {{/each}}
</ul>

<div id="dag-name" style="display:none;"></div>

<div id="myTabContent" class="tab-content">
  {{#each items}}
    <div class="tab-pane fade in" id="tab{{this.id}}" data-id="{{this.id}}" >
      <div class="row">
        <div class="col-lg-12">
          <div class="dagParent">
            <div class="dag" id="dag{{this.id}}">
              <svg id="svg{{this.id}}" data-id="{{this.id}}" height="100%" width="100%"">
                <g/>
              </svg>
            </div>
          </div>
        </div>
        <div class="col-lg-12">
          <h3>Topological Sort</h3>
          <div class="topo" id="topo{{this.id}}">
          </div>
        </div>
      </div>
    </div>
  {{/each}}
</div></script>

<script id="friendly_message_to_ie_user" type="text/x-handlebars-template"
><div class="alert alert-warning">
  <span class="label label-danger">
    Patatra!
  </span>
  <span>
    It seems that you are using <span style="color:blue;" data-toggle="tooltip" title="{{this.userAgent}}">internet explorer
  </span>
  <span>
    What you see here is probably not what you expected.
  </span>
  <span>
    The <a href="https://github.com/cpettitt/dagre-d3">dagre-d3</a> library used to render graphs seems to have an issue with IE at line 307:
  </span>
  <span class="thumbnail" style="background:transparent; border: none;">
    <img src="{{this.iebug_png}}" style=" margin: 0;"/>
  </span>
  <span>
    The issue is easy to fix : switch to 
      <span style="color:blue;">chrome</span> or 
      <span style="color:blue;">firefox</span> or 
      <span style="color:blue;">safari</span>.
  </span>
</div></script>        

<%-- END ------------------ handlebars templates ------------------ END --%>
</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("d3.min.js")%>' />" ></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dagre-d3.js")%>' />" ></script>

<script src="<c:url value="/scripts/geppaefact.js"/>"></script>

<script type="text/javascript">

  var $isisevil = null;

  var formatDate = function(datetime, format) {
    if (moment) {
      return moment(datetime).format(format);
    } else {
      return datetime;
    }
  }

  // not used
  Handlebars.registerHelper("formatDate", formatDate);

  <c:if test="${not empty pageContext.request.remoteUser}">
  var items = {
    items : [<c:forEach items="${model}" var="_this_" varStatus="status">
      {
        id         : '${status.count}',
        name       : '${_this_.name}',
        key        : '${_this_.key}',
        source     : '${_this_.url}',
        clazz      : '<c:if test="${_this_.subscribed}">star active</c:if><c:if test="${not _this_.subscribed}">star</c:if>'
      },</c:forEach>
    ]
  };
  </c:if>
  <c:if test="${empty pageContext.request.remoteUser}">
  var items = {
      items : [<c:forEach items="${model}" var="_this_" varStatus="status">
        {
          id         : '${status.count}',
          name       : '${_this_.name}',
          key        : '${_this_.key}',
          source     : '${_this_.url}',
          clazz      : undefined
        },</c:forEach>
      ]
    };
  </c:if>

  items.items.sort(function(a, b) {
      return a.name < b.name;
  });

  $(document).ready(function(){
    
    $('body').tooltip({
      delay    : { "show": 500, "hide": 100 },
      placement: 'bottom',
      selector : "[data-toggle='tooltip']"
    });
    
    // IE
    var userAgent = navigator.userAgent;
    
    if (userAgent.indexOf('.NET ') != -1 || IE.isTheBrowser) {
      var friendly_message_to_ie_user = Handlebars.compile($("#friendly_message_to_ie_user").html());

      $isisevil = friendly_message_to_ie_user({
          userAgent : userAgent,
          iebug_png : "<c:url value='/modules/dagr/iebug.png'/>"
      });
    }

    // geppaefact
    var ajaxLoading = "<c:url value='/assets/images/animated_orange_refresh_22.gif'/>",
        ajaxLoaded  = "<c:url value='/assets/images/animated_orange_refresh_22.png'/>",
        redirectJSP = "<c:url value='/proxy.jsp?'/>";

    var snapshotServerType       = "${applicationScope.geppaequo.snapshotServerType}";
    var snapshotServerBaseURL    = "${applicationScope.geppaequo.snapshotServerBaseURL}";
    var snapshotServerRepository = "${applicationScope.geppaequo.snapshotServerRepository}";
    var releaseServerType        = "${applicationScope.geppaequo.releaseServerType}";
    var releaseServerBaseURL     = "${applicationScope.geppaequo.releaseServerBaseURL}";
    var releaseServerRepository  = "${applicationScope.geppaequo.releaseServerRepository}";
    
    var tab_definitions_template = Handlebars.compile($("#tab_definitions").html());
    var gav_template             = Handlebars.compile($("#gav_template").html());
    var gav_header_template      = Handlebars.compile($("#gav_header_template").html());
    var basic_template           = Handlebars.compile($("#basic_template").html());
    
    if (Modernizr.localstorage) {
      var short_label_is_displayed = window.localStorage["dagr.short_label"];
      window.log('window.localStorage["dagr.short_label"]=' + short_label_is_displayed);
      var $shorten_i = $('#shorten i'); 
      if (short_label_is_displayed ) {
        $shorten_i.removeClass('fa-minus-square');
        $shorten_i.addClass('fa-plus-square');
      } else {
        $shorten_i.removeClass('fa-plus-square');
        $shorten_i.addClass('fa-minus-square');
      }
    }
    
    
    // keep DAGs in this global object, as we will need them when we switch between multiple tabs
    var datas = [];
    function putData(id, data) {
      datas[new String(id)] = data;
    }
    function getData(id) {
      return datas[new String(id)];
    }

    // let's go though the subscribed DAGs
    if (items.items.length == 0 ) {
      $('#no_tab_defined').css("display", "inline-block").show();
    } else {
      $('#container').html(tab_definitions_template(items));
      
      $('#container ul li:first-child').addClass('active');
      $('#container div div:first-child').addClass('active');

      $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
          var dagId = $(this).data('id');
          var data = getData(dagId);
          window.DAG.renderGraph(data, $('svg[data-id="'+dagId+'"]'));
      });

      $.each(items.items, function( index, dagInfo ) {

        $.ajax({
            url: '<c:url value="/dagr-api/dags/"/>' + dagInfo.key,
            dataType: "json",
        }).done(function(data) {
            
          // save it for later use
          putData(dagInfo.id, data );
            
          // put date in tab label as html title
          var $tabLabel = $("a#tab_"+dagInfo.id).attr('data-toggle', 'tooltip');
          if (data.date) {
            $tabLabel.attr({ title: 'created on ' + formatDate(new moment(data.date), "dddd, MMMM Do YYYY, h:mm:ss a")});
          } else {
            $tabLabel.attr({ title: 'creation date unknown' });
          }
            
          // backup original node label
          $.each(data.nodes, function( index, node ) {
            node.value.label0 = node.value.label;
          });

          // this creates the svg graph
          loadData(data, dagInfo.id);
          
          var releaseServer = {};
          var snapshotServer = {};
          
          // load topological sort
          $.ajax({
              url: '<c:url value="/dagr-api/dags/"/>' + dagInfo.key + '/topological',
              dataType: "json",
          }).done(function(topologicalSort) {

            
            var $topotable = $('<table class="table" data-id="'+dagInfo.id+'"></table>');
            var $topotableWrapper = $('<div class="table-responsive">');
            $topotableWrapper.html($topotable);
            $('#topo'+dagInfo.id).html($topotableWrapper);

            // map node key to node value
            var nodeKey2ValueMap = {};
            $.each(data.nodes, function( index, node ) {
              nodeKey2ValueMap[node.id] = node.value;
            });
            
            // set global geppaefact config
            $.geppaefact({
              redirectJSP : redirectJSP,
              ajaxLoading : ajaxLoading,
              ajaxLoaded  : ajaxLoaded,
              before : function ($zeElement, ajaxLoadingImg, server) {
                $zeElement.find('#version').empty();        
                $zeElement.parent().find('td > span.version').wrap($('<a>').attr({
                  href   : server.browseURL,
                  target : server.title,
                  'data-toggle' : 'tooltip',
                  title  : "browse all versions"}));
                if (server.policy == "snapshot") {
                  snapshotServer = server;
                } else if (server.policy == "release") {
                  releaseServer = server;
                }
              },
              after :function($zeElement, ajaxLoadedImg) {
              }
            });

            // for each line in the topological list
            var countoks = 0;
            $.each(topologicalSort, function( index, dagkey ) {
              var nodeValue = nodeKey2ValueMap[dagkey];
              var gav = gavpce(nodeValue.gubrid);
              var selector = dagkey.replace(/\./gi, "\\.");

              if (gav.ok()) {
                 countoks += 1;
              }
              
              // massage artifact data to produce a row
              {
                var instantiatedTemplate;
                if (gav.ok()) {
                  var shortgav = gav.g.replace(/net\.(.*)\.neo/g, "$1");
                  var reponame = shortgav+"/"+gav.a;
                  var repoid = reponame.replace(/\//g, "_");
                  var github = "";
                  var scmurl = undefined;
                  if (typeof nodeValue.scm !== "undefined" && nodeValue.scm != null) {
                      github = nodeValue.scm.replace(/\.git/g, "");
                      if (github.startsWith('http')) {
                         scmurl = github;
                      } else if (github.startsWith('git@')) {
                        github = github.replace(/\:/gi, "/");
                        github = github.replace(/^git@/g, "https://");
                        scmurl = github;
                      }
                  }
                  var shortbranch = "";
                  if (typeof nodeValue.branch !== "undefined" && nodeValue.branch != null ) {
                      shortbranch = nodeValue.branch.replace(/refs\/heads\//g, "");
                      if (typeof scmurl !== "undefined") {
                          scmurl = scmurl +'/tree/'+shortbranch
                      }
                  }
                  
                  instantiatedTemplate = gav_template({
                    index      : index, 
                    key        : dagkey, 
                    scm        : github, 
                    scmurl     : scmurl, 
                    scmtrunked : typeof scmurl !== "undefined" ? github.middleEllipse(19, 13) : github,
                    branch     : shortbranch,
                    group      : gav.g, 
                    artifact   : gav.a, 
                    version    : gav.v, 
                    reponame   : reponame, 
                    repoid     : repoid
                  });

                  // is travis here ?
                  var travisURL = "https://api.travis-ci.org/repos/"+reponame+"/branches";
                  window.log(travisURL);
                  $.ajax({
                    url: travisURL,
                    crossDomain: true,
                    headers: { 'Accept'        : 'application/vnd.travis-ci.2+json' /*, 
                               'Authorization' : 'token 8W0KwXx3rb-5PFC721NTJA'*/}
                  })
                  .fail(function( data ) {
                      $( "span.travis#"+repoid ).css( {display : 'none'});
                  })
                  .done(function( data ) {
                    $( "span.travis#"+repoid ).show();
                    var foundJob = null; {
                      // search in commits array for the branch
                      var foundCommit = null; {
                        for (var ccc = 0; ccc < data.commits.length; ccc++) {
                          if (data.commits[ccc].branch==shortbranch) {
                            foundCommit = data.commits[ccc].id;
                            break;
                          }
                        }
                      }
                      if (foundCommit != null) {
                        // search in branch array for the job
                        for (var bbb = 0; bbb < data.branches.length; bbb++) {
                          if (data.branches[bbb].commit_id==foundCommit) {
                            if (data.branches[bbb].job_ids.length) {
                              foundJob = data.branches[bbb].job_ids[0];
                              break;
                            }
                          }
                        }
                      }
                    }
                    if (foundJob != null) {
                      $( "a.trigger#"+repoid ).on( 'click', function(event) {
                        $target = $(event.target).closest('a');
                        $.ajax({
                          url: 'https://api.travis-ci.org/jobs/'+foundJob+'/restart',
                          method: "POST",
                          crossDomain: true,
                          headers: {'Accept'        : 'application/vnd.travis-ci.2+json', 
                                    'Authorization' : 'token 8W0KwXx3rb-5PFC721NTJA'}
                        })
                        .fail(function( jqXHR, textStatus, errorThrown ) {
                          alert("["+$target.data('original-title') + "]\nthere was some issue connecting with travis, rebuild has not been triggered.\ntextStatus: "+textStatus+"\nerrorThrown: "+errorThrown);
                        })
                        .done(function( data, textStatus, jqXHR ) {
                          $target.popover({
                            trigger: 'manual',
                            placement: 'left',
                            title : $target.data('original-title'),
                            content: function() {
                                 return data ? data.flash ? data.flash.length ? data.flash[0].notice ? data.flash[0].notice : textStatus  : textStatus : textStatus : textStatus;
                            }
                          });
                          $target.popover("show");
                          setTimeout(function() {$target.popover('destroy')},1500);
                        });
                      }).html( $('<i class="fa fa-play"/>') );
                    } else {
                      $( "a.trigger#"+repoid ).css( { display : 'none' });
                    }
                  });
                  // done with travis

                } else {
                  // no valid gav, fallback on basic template
                  instantiatedTemplate = basic_template({index:index, key:dagkey, artifact:nodeValue.label});
                }
                
                $topotable.append(instantiatedTemplate);
              }

              if (gav.ok()) {
                
                // get latest snapshot and release version and setup links through geppaefact
                $('table.table[data-id="' + dagInfo.id + '"] tr#' + selector + ' td#snapshot').geppaefact({
                  gap : {
                    group     : gav.g,
                    artifact  : gav.a,
                    packaging : gav.p
                  },
                  server : {
                    type : snapshotServerType,
                    base : snapshotServerBaseURL,
                    repo : snapshotServerRepository,
                    policy : "snapshot"
                  }
                });
                  
                $('table.table[data-id="' + dagInfo.id + '"] tr#' + selector + ' td#release').geppaefact({
                  gap : {
                    group     : gav.g,
                    artifact  : gav.a,
                    packaging : gav.p
                  },
                  server : {
                    type : releaseServerType,
                    base : releaseServerBaseURL,
                    repo : releaseServerRepository,
                    policy : "release"
                  }
                });      
              } // end of geppaefact
                  
            });  // end for each topological item

            // prepend table header
            if (countoks == topologicalSort.length) {

              $topotable.prepend(gav_header_template({
                buildServer : {
                  url : "https://travis-ci.org/",
                  title : "travis"
                },
                snapshotServer : snapshotServer,
                releaseServer : releaseServer,
                sourceServer : {
                  url : "https://github.com/",
                  title : "github"
                }
                
              }));

              wireTable2Graph(dagInfo.id);
              
            }
          });  // ajax load topological sort
          
        });  // ajax load dag
        
      });  // for each of the dag selected
      

      $('#shorten').on('click', function(event) {
        event.preventDefault();
        var $i = $(this).children("i");
        var short_label_is_displayed = (0 < $i.attr("class").indexOf('fa-plus-square'));
        if (short_label_is_displayed) {
          $i.removeClass('fa-plus-square');
          $i.addClass('fa-minus-square');
        } else {
          $i.removeClass('fa-minus-square');
          $i.addClass('fa-plus-square');
        }
        
        var $activeTab = $('.tab-pane.active');
        var dagId = $activeTab.data('id');
        var graph = getData(dagId);
        
        window.DAG.renderGraph(graph, $('svg[data-id="'+dagId+'"]'));

        // save
        if (Modernizr.localstorage) {
          var short_label_is_displayed = (0 < $i.attr("class").indexOf('fa-plus-square'));
          if (short_label_is_displayed) {
            window.localStorage["dagr.short_label"] = true;
            window.log("just wrote localstorage[\"dagr.short_label\"] = " + window.localStorage["dagr.short_label"]);
          } else {
            if (window.localStorage.getItem("dagr.short_label")) {
              window.localStorage.removeItem("dagr.short_label");
              window.log("just removed localstorage[\"dagr.short_label\"] = " + window.localStorage["dagr.short_label"]);
            }
          }
        }

      });
      
    }    // any dag selected ?
  });  // document ready

  // wire graph to table 
  function wireGraph2Table(id) {

    $('svg[data-id="'+id+'"] g.node' )
    .on('click', function(event) {
      window.log(this);
      var artifact = $("tr#"+this.id+" > td > span.artifact").text();
      var where = window.location + '/../dag-'+artifact+'.json';
      if (where) {
        window.open(where);
      } else {
        alert("not a http link: "+where);
      }
    })
    .mouseenter(function(event) { 
      var $rect = $(this).find("rect");
      if ($rect.length) {
        var dataBG = $rect.attr('data-bg');
        if (!dataBG) {
          $rect.attr('data-bg', $rect.css('fill')) 
        }
        $rect.css('fill', '#efefef');
      } 
      if (this.__data__) {
        $('tr#'+this.__data__).css('background-color', '#efefef');
      }
    }).mouseleave(function(event) {
      var $rect = $(this).find("rect");
      if ($rect.length) {
        var dataBG = $rect.attr('data-bg');
        if (!dataBG) {
          $rect.css('fill', "none");
        } else {
          $rect.css('fill', dataBG);
        }
      }
      if (this.__data__) {
        $('tr#'+this.__data__).css('background-color', 'inherit');
      }
    });
  }

  // wire table to graph
  function wireTable2Graph(id) {
    
    $('#shorten').show();
    
   // table
    $( 'table.table[data-id="'+id+'"] tr' )
    .mouseenter(function(event) {
      if (this.id) {
        var $rect = $('.node#'+this.id).find('rect');
        if ($rect.length) {
          var dataBG = $rect.attr('data-bg');
          if (!dataBG) {
            $rect.attr('data-bg', $rect.css('fill')) 
          }
          $rect.css('fill', '#efefef');
        } 
      }
      $(this).css('background-color', '#efefef');
    })
    .mouseleave(function(event) {
      if (this.id) {
        var $rect = $('.node#'+this.id).find('rect');
        if ($rect.length) {
          var dataBG = $rect.attr('data-bg');
          if (!dataBG) {
              $rect.css('fill', "none");
          } else {
              $rect.css('fill', dataBG);
          }
        }
      }
      $(this).css('background-color', 'inherit');
    });      
  }

  
  
  (function () {
      'use strict';
      window.DAG = {
          displayGraph: function (graph, dagNameElem, svgElem) {
              dagNameElem.text(graph.name);

              this.renderGraph(graph, svgElem);
          },

          renderGraph: function(graph, svgElem) {
              var theTrulyUniqueID = svgElem.data('id');
              $('#idspy').text(theTrulyUniqueID).show();
              if ($isisevil)  {
                $('#shorten').hide();
                svgElem.parent().parent().html($isisevil);
                return;
              }

              var graphElem = svgElem.children('g').get(0);
              $(graphElem).empty();

              var nodes = graph.nodes;
              var links = graph.links;

              // Create the renderer
              var render = new dagreD3.render();

              // Set up an SVG group so that we can translate the final graph.
              var svg   = d3.select(graphElem),
                  inner = svg.append("g");

              var createGraph = function(nodes, edges) {
                var graph = new dagreD3.graphlib.Graph()
                  .setGraph({})
                  .setDefaultEdgeLabel(function() { return {}; });

                nodes.forEach(function(u) {
                  u.value.labelStyle = "font-family: Geppaequo; font-size: 11px;";
                  graph.setNode(u.id, u.value);
                });

                edges.forEach(function(e) {
                  e.value.lineInterpolate = 'basis';
                  e.value.arrowheadStyle = "fill: #000";
                  graph.setEdge(e.u, e.v, e.value);
                });

                return graph;
              };

              var g = createGraph(nodes, links);

              g.nodes().forEach(function(v) {
                var node = g.node(v);
                // Round the corners of the nodes
                node.id = v;
                node.rx = node.ry = 5;
              });
              
              var nodes = graph.nodes;
              var links = graph.links;

              var plus = $('#shorten').children("i").attr("class").indexOf('fa-plus-square');
              
              $.each(nodes, function( index, node ) {
                var value = node.value;
                  if (plus == -1) {
                    value.label = value.label0;
                  } else {
                    var space =  value.label0.indexOf(' ');
                    if (space== -1) {
                        value.label = value.label0;
                    } else {
                        value.label = value.label0.substr(0,space);
                    }
                  }
              });

              // Run the renderer. This is what draws the final graph.
              render(inner, g);

              var resize = function() {
                
                var $activeTab = $('.tab-pane.active');
                var dagId = $activeTab.data('id');
                var gelem = d3.select("svg[data-id='"+dagId+"'] > g");
                
                // up to parent with style "col-lg-12"
                var colParent = svgElem.parent();
                while (colParent) {
                    if (colParent.hasClass("col-lg-12")) {
                        break;
                    }
                    colParent = colParent.parent();
                }
                
                var w = window,
                    d = document,
                    e = d.documentElement,
                    gbody = d.getElementsByTagName('body')[0],
                    x = colParent.width() || w.innerWidth || e.clientWidth || gbody.clientWidth,
                    y =                      w.innerHeight|| e.clientHeight|| gbody.clientHeight;

                // console.log("-------------"); 
                // console.log("colParent.width(): "+colParent.width()+", w.innerWidth: " + w.innerWidth +", e.clientWidth: " + e.clientWidth + ", gbody.clientWidth: " + gbody.clientWidth + ", x = " + x);
                
                var true_ratio_x = x / g.graph().width;
                var true_ratio_y = y / g.graph().height;

                var ratio_x = Math.min(true_ratio_x, 1);
                var ratio_y = Math.min(true_ratio_y, 1);

                // console.log(x + " / " + g.graph().width  + " = " + true_ratio_x + ", using " + ratio_x);
                // console.log(y + " / " + g.graph().height + " = " + true_ratio_y + ", using " + ratio_y);

                var final_ratio = Math.min(ratio_x, ratio_y);

                // console.log(final_ratio);
                
                gelem.attr("transform", "scale("+ final_ratio +")"); 

                // Adjust SVG height to content
                var main = svgElem.find('g > g');
                var h = main.get(0).getBoundingClientRect().height;
                var newHeight = h;
                newHeight = newHeight < 40 ? 40: newHeight;
                svgElem.height(newHeight);
                
                // Zoom
                d3.select(svgElem.get(0)).call(d3.behavior.zoom().on('zoom', function() {
                    var ev = d3.event;
                    svg.select('g')
                        .attr('transform', 'translate(' + ev.translate + ') scale(' + ev.scale + ')');
                }));
              }
              
              window.onresize = resize;               

              resize();
              
              wireGraph2Table(theTrulyUniqueID);
          }
      };
  })();

  (function () {
      'use strict';
      // callback for graph data loading
      window.loadData = function (data, id) {
        DAG.displayGraph(data, $('#dag-name'), $('#dag'+id+' > svg'));
      };
  }());

  function gavpce(str) {
      var _this_ = {};

      function isok(x) {
          if (typeof x === "undefined" || x === null || x.length === 0) {
              return false;
          }
          return true;
      }

      /*
      g    Group id of the artifact (Required)
      a    Artifact id of the artifact (Required)
      t    Type of the artifact (Required)
      v    Version of the artifact (Required) Supports resolving of "LATEST", "RELEASE" and snapshot versions ("1.0-SNAPSHOT") too
      p    Packaging type of the artifact (Optional)
      c    Classifier of the artifact (Optional)
      e    Extension of the artifact (Optional)
      
      [r    Repository that the artifact is contained in (Required)] <-- not needed
      
      str = "g:a:t:v:p:c:e";
      
      */
      // verify that parameter is fine
      // if not, return an object that containing only a 'ok' function returning false.
      if (!isok(str)) {
          _this_.ok = function() {return false;}
          return _this_;
      }

      var arr = str.split(":");

      _this_.g = arr[0];
      _this_.a = arr[1];
      _this_.t = arr[2];
      _this_.v = arr[3];
      _this_.p = arr[4];
      _this_.c = arr[5];
      _this_.e = arr[6];

      // if no package , package is type
      if (!isok(_this_.p)) {
          _this_.p = _this_.t;
      }

      _this_.ok = function() {
         var mandatories = [_this_.g, _this_.a, _this_.t, _this_.v];
         for (j = 0; j < mandatories.length; j++) {
             if (!isok(mandatories[j])) {
                 return false;
             }
         }
         return true;
      }

      return _this_;
  }

</script>