/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.Dags;
import net.aequologica.neo.dagr.jaxrs.Resource;
import net.aequologica.neo.dagr.jgrapht.DagJGraphT;
import net.aequologica.neo.dagr.model.Dag;
import org.glassfish.jersey.server.mvc.Viewable;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class Resource<T> {
    @Context
    ServletContext context;
    private final Dags dags = Dags.getInstance();

    public Resource() throws IOException {
        this.dags.load();
    }

    @GET
    @Path(value="")
    @Produces(value={"text/plain"})
    public String ping() {
        return "pong";
    }

    @POST
    @Path(value="/reload")
    @Produces(value={"application/json"})
    public Response reload() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.dags.load()).build();
    }

    @GET
    @Path(value="/pick-dag")
    @Produces(value={"text/html"})
    public Viewable pickDate(@Context HttpServletRequest request) throws Exception {
        return new Viewable("/WEB-INF/dagr/pick-dag");
    }

    @GET
    @Path(value="/dags")
    @Produces(value={"application/json"})
    public List<DagInfo> getUserDagInfos(@Context HttpServletRequest request) {
        Collection dagsCollection = this.dags.getDAGs();
        String username = Resource.getUsername((HttpServletRequest)request);
        List ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @GET
    @Path(value="/dags/users/{user : .+}")
    @Produces(value={"application/json"})
    public List<DagInfo> getAllDagInfos(@PathParam(value="user") String username) {
        Collection dagsCollection = this.dags.getDAGs();
        List ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @GET
    @Path(value="/dags")
    @Produces(value={"text/html"})
    public Viewable viewDags(@Context HttpServletRequest request) throws IOException {
        List ret;
        Collection dagsCollection = this.dags.getDAGs();
        String username = Resource.getUsername((HttpServletRequest)request);
        if (username == null) {
            ret = Collections.emptyList();
        } else {
            List tmp = this.buildDagInfoList(dagsCollection, username);
            ret = new ArrayList();
            for (DagInfo dagInfo : tmp) {
                if (!dagInfo.getSubscribed().booleanValue()) continue;
                ret.add(dagInfo);
            }
        }
        return new Viewable("/WEB-INF/dagr/dags", ret);
    }

    @GET
    @Path(value="/dags/{dag : .+}")
    @Produces(value={"application/json"})
    public Dag getDAG(@PathParam(value="dag") String dagkey) throws Exception {
        Dag dag = this.dags.getDAG(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        return dag;
    }

    @GET
    @Path(value="/dags/{dag : .+}")
    @Produces(value={"text/html"})
    public Viewable getDAGasHTML(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws Exception {
        Dag dag = this.getDAG(dagkey);
        ArrayList<Dag> list = new ArrayList<Dag>();
        list.add(dag);
        String username = Resource.getUsername((HttpServletRequest)request);
        List buildDagInfoList = this.buildDagInfoList(list, username);
        return new Viewable("/WEB-INF/dagr/dags", (Object)buildDagInfoList);
    }

    @GET
    @Path(value="/dags/{dag : .+}/topological")
    @Produces(value={"application/json"})
    public List<String> getTopological(@PathParam(value="dag") String dagkey) throws Exception {
        DagJGraphT dag = this.dags.getDAG2(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        1 node2nodeId = new /* Unavailable Anonymous Inner Class!! */;
        return Lists.newArrayList((Iterator)Iterators.transform((Iterator)dag.getTopologicalOrderIterator(), (Function)node2nodeId));
    }

    @GET
    @Path(value="/dags/{dag : .+}/topologicartifacts")
    @Produces(value={"application/json"})
    public List<String> getTopologicartifacts(@PathParam(value="dag") String dagkey) throws Exception {
        DagJGraphT dag = this.dags.getDAG2(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        2 node2artifactId = new /* Unavailable Anonymous Inner Class!! */;
        return Lists.newArrayList((Iterator)Iterators.transform((Iterator)dag.getTopologicalOrderIterator(), (Function)node2artifactId));
    }

    @GET
    @Path(value="/dags/subscription")
    @Produces(value={"application/json"})
    public List<DagInfo> getUserDAGs(@Context HttpServletRequest request) throws Exception {
        String username = Resource.getUsername((HttpServletRequest)request);
        if (username == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List dagsCollection = this.dags.getUserDAGs(username);
        List ret = this.buildDagInfoList((Collection)dagsCollection, username);
        return ret;
    }

    @POST
    @Path(value="/dags/subscription/{dag : .+}")
    public Response subscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = Resource.getUsername((HttpServletRequest)request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.subscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    @DELETE
    @Path(value="/dags/subscription/{dag : .+}")
    public Response unsubscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = Resource.getUsername((HttpServletRequest)request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.unsubscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    private List<DagInfo> buildDagInfoList(Collection<Dag> dagsCollection, String username) {
        ArrayList<DagInfo> ret = new ArrayList<DagInfo>(dagsCollection.size());
        for (Dag dag : dagsCollection) {
            DagInfo dagInfo = new DagInfo();
            DagInfo.access$002((DagInfo)dagInfo, (String)dag.getName());
            DagInfo.access$102((DagInfo)dagInfo, (String)dag.getKey());
            DagInfo.access$202((DagInfo)dagInfo, (String)dag.getSource());
            DagInfo.access$302((DagInfo)dagInfo, (String)username);
            DagInfo.access$402((DagInfo)dagInfo, (Boolean)(username == null ? false : this.dags.isUserSubscribed(dag.getKey(), username)));
            ret.add(dagInfo);
        }
        return ret;
    }

    private static String getUsername(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        String username = userPrincipal.getName();
        if (username == null || username.isEmpty()) {
            return null;
        }
        return username;
    }
}

