/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import java.io.IOException;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/github")
public class GithubResource {
    private static final Logger log = LoggerFactory.getLogger(GithubResource.class);
    ObjectMapper mapper = new ObjectMapper();

    public GithubResource() throws IOException {
        this.mapper.registerModule((Module)new JSR353Module());
    }

    @POST
    @Path(value="/notification")
    @Consumes(value={"application/json"})
    public Response receiveNotification(String payload) throws IOException {
        JsonObject ob = (JsonObject)this.mapper.readValue(payload, JsonObject.class);
        System.out.println("ref is " + ob.get((Object)"ref"));
        JsonObject repositoryObject = ob.getJsonObject("repository");
        if (repositoryObject != null) {
            System.out.println("repository url is " + repositoryObject.get((Object)"url"));
        } else {
            System.out.println("repository is null");
        }
        JsonObject head_commitObject = ob.getJsonObject("head_commit");
        if (head_commitObject != null) {
            System.out.println("head_commit message is " + head_commitObject.get((Object)"message"));
            System.out.println("head_commit timestamp is " + head_commitObject.get((Object)"timestamp"));
        } else {
            System.out.println("head_commit is null");
        }
        JsonObject organizationObject = ob.getJsonObject("organization");
        if (organizationObject != null) {
            System.out.println("organization url is " + organizationObject.get((Object)"url"));
            System.out.println("organization login is " + organizationObject.get((Object)"login"));
        } else {
            System.out.println("organization is null");
        }
        return Response.noContent().build();
    }
}

