/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.chat.atmosphere;

import java.io.IOException;
import net.aequologica.neo.chat.atmosphere.ChatMessage;
import net.aequologica.neo.chat.atmosphere.ChatMessageEncoderDecoder;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedService(path="/patati")
public final class Chat {
    private static final Logger logger = LoggerFactory.getLogger(Chat.class);

    @Ready
    public final void onReady(AtmosphereResource r) {
        logger.info("Browser {} connected.", (Object)r.uuid());
    }

    @Disconnect
    public final void onDisconnect(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            logger.info("Browser {} unexpectedly disconnected", (Object)event.getResource().uuid());
        } else if (event.isClosedByClient()) {
            logger.info("Browser {} closed the connection", (Object)event.getResource().uuid());
        }
    }

    @Message(encoders={ChatMessageEncoderDecoder.class}, decoders={ChatMessageEncoderDecoder.class})
    public final ChatMessage onMessage(ChatMessage message) throws IOException {
        logger.info("{} just send {}", (Object)message.getAuthor(), (Object)message.getMessage());
        return message;
    }
}

