/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jgrapht;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;

public class TransitiveReduction<V, E> {
    private final DirectedGraph<V, E> graph;
    private final List<V> vertices;
    private final BitSet[] pathMatrix;

    public TransitiveReduction(DirectedGraph<V, E> graph) {
        this.graph = graph;
        this.vertices = new ArrayList<V>(graph.vertexSet());
        BitSet[] original = new BitSet[this.vertices.size()];
        for (int i = 0; i < original.length; ++i) {
            original[i] = new BitSet(this.vertices.size());
        }
        Set edges = graph.edgeSet();
        for (Object edge : edges) {
            Object v1 = graph.getEdgeSource(edge);
            Object v2 = graph.getEdgeTarget(edge);
            int v_1 = this.vertices.indexOf(v1);
            int v_2 = this.vertices.indexOf(v2);
            original[v_1].set(v_2);
        }
        this.pathMatrix = original;
        TransitiveReduction.transformToPathMatrix(this.pathMatrix);
    }

    static BitSet[] transformToPathMatrix(BitSet[] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                if (i == j || !matrix[j].get(i)) continue;
                for (int k = 0; k < matrix.length; ++k) {
                    if (matrix[j].get(k)) continue;
                    matrix[j].set(k, matrix[i].get(k));
                }
            }
        }
        return matrix;
    }

    static BitSet[] transitiveReduction(BitSet[] pathMatrix) {
        for (int j = 0; j < pathMatrix.length; ++j) {
            for (int i = 0; i < pathMatrix.length; ++i) {
                if (!pathMatrix[i].get(j)) continue;
                for (int k = 0; k < pathMatrix.length; ++k) {
                    if (!pathMatrix[j].get(k)) continue;
                    pathMatrix[i].set(k, false);
                }
            }
        }
        return pathMatrix;
    }

    public void reduce() {
        int n = this.pathMatrix.length;
        BitSet[] transitivelyReducedMatrix = new BitSet[n];
        System.arraycopy(this.pathMatrix, 0, transitivelyReducedMatrix, 0, this.pathMatrix.length);
        TransitiveReduction.transitiveReduction(transitivelyReducedMatrix);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (transitivelyReducedMatrix[i].get(j)) continue;
                this.graph.removeEdge(this.graph.getEdge(this.vertices.get(i), this.vertices.get(j)));
            }
        }
    }
}

