/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.config.DagrConfig;
import net.aequologica.neo.dagr.crypto.Codec;
import net.aequologica.neo.dagr.crypto.CodecPBEWithMD5AndDES;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/travis")
public class TravisResource {
    private static final Logger log = LoggerFactory.getLogger(TravisResource.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final Codec codec;

    public TravisResource() throws IOException {
        this.mapper.registerModule((Module)new JSR353Module());
        this.codec = new CodecPBEWithMD5AndDES();
    }

    @POST
    @Path(value="notifications")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response receiveNotification(@FormParam(value="payload") String payloadInput) throws Exception {
        JsonObject payload = (JsonObject)this.mapper.readValue(payloadInput, JsonObject.class);
        StringBuilder sb = new StringBuilder();
        sb.append(payload.getInt("status") == 0 ? "SUCCESS" : "FAILURE");
        sb.append(" ");
        sb.append(payload.getJsonObject("repository").getString("name"));
        sb.append(" @ ");
        sb.append(payload.getString("build_url"));
        this.sendNotification(sb.toString());
        return Response.noContent().build();
    }

    void sendNotification(String message) throws Exception {
        try {
            GCMMessage msg = new GCMMessage(new GCMMessage.Data(message));
            String msgAsString = this.mapper.writeValueAsString((Object)msg);
            System.out.println("======= message:");
            System.out.println(msgAsString);
            GCMMessage readValue = (GCMMessage)this.mapper.readValue(msgAsString, GCMMessage.class);
            System.out.println(readValue);
            DagrConfig config = (DagrConfig)ConfigRegistry.getConfig(DagrConfig.class);
            String encryptedGoogleCloudMessagingAPIKey = config.getEncryptedGoogleCloudMessagingAPIKey();
            String googleCloudMessagingAPIKey = this.codec.decrypt(encryptedGoogleCloudMessagingAPIKey.toCharArray());
            URL url = new URL("https://android.googleapis.com/gcm/send");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", "key=" + googleCloudMessagingAPIKey);
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(msgAsString.getBytes(StandardCharsets.UTF_8));
            InputStream inputStream = conn.getInputStream();
            String resp = CharStreams.toString((Readable)new InputStreamReader(inputStream));
            System.out.println("======= response:");
            System.out.println(resp);
            System.out.println("Check your device/emulator for notification or logcat for confirmation of the receipt of the GCM message.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class GCMMessage {
        @JsonProperty
        private final String to = "/topics/global";
        @JsonProperty
        private Data data;

        public GCMMessage() {
        }

        public GCMMessage(Data data) {
            this.data = data;
        }

        private static class Data {
            @JsonProperty
            private String message;

            public Data() {
            }

            public Data(String message) {
                this.message = message;
            }
        }
    }
}

