/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.Dags;
import net.aequologica.neo.dagr.jgrapht.DagJGraphT;
import net.aequologica.neo.dagr.model.Dag;
import org.glassfish.jersey.server.mvc.Viewable;

@Path(value="/")
public class Resource<T> {
    @Context
    ServletContext context;
    private final Dags dags = Dags.getInstance();

    public Resource() throws IOException {
        this.dags.load();
    }

    @GET
    @Path(value="")
    @Produces(value={"text/plain"})
    public String ping() {
        return "pong";
    }

    @POST
    @Path(value="/reload")
    @Produces(value={"application/json"})
    public Response reload() {
        return Response.status((Response.Status)Response.Status.OK).entity(this.dags.load()).build();
    }

    @GET
    @Path(value="/pick-dag")
    @Produces(value={"text/html"})
    public Viewable pickDate(@Context HttpServletRequest request) throws Exception {
        return new Viewable("/WEB-INF/dagr/pick-dag");
    }

    @GET
    @Path(value="/dags")
    @Produces(value={"application/json"})
    public List<DagInfo> getUserDagInfos(@Context HttpServletRequest request) {
        Collection<Dag> dagsCollection = this.dags.getDAGs();
        String username = Resource.getUsername(request);
        List<DagInfo> ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @GET
    @Path(value="/dags/users/{user : .+}")
    @Produces(value={"application/json"})
    public List<DagInfo> getAllDagInfos(@PathParam(value="user") String username) {
        Collection<Dag> dagsCollection = this.dags.getDAGs();
        List<DagInfo> ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @GET
    @Path(value="/dags")
    @Produces(value={"text/html"})
    public Viewable viewDags(@Context HttpServletRequest request) throws IOException {
        List ret;
        Collection<Dag> dagsCollection = this.dags.getDAGs();
        String username = Resource.getUsername(request);
        if (username == null) {
            ret = Collections.emptyList();
        } else {
            List<DagInfo> tmp = this.buildDagInfoList(dagsCollection, username);
            ret = new ArrayList();
            for (DagInfo dagInfo : tmp) {
                if (!dagInfo.getSubscribed().booleanValue()) continue;
                ret.add(dagInfo);
            }
        }
        return new Viewable("/WEB-INF/dagr/dags", ret);
    }

    @GET
    @Path(value="/dags/{dag : .+}")
    @Produces(value={"application/json"})
    public Dag getDAG(@PathParam(value="dag") String dagkey) throws Exception {
        Dag dag = this.dags.getDAG(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        return dag;
    }

    @GET
    @Path(value="/dags/{dag : .+}")
    @Produces(value={"text/html"})
    public Viewable getDAGasHTML(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws Exception {
        Dag dag = this.getDAG(dagkey);
        ArrayList<Dag> list = new ArrayList<Dag>();
        list.add(dag);
        String username = Resource.getUsername(request);
        List<DagInfo> buildDagInfoList = this.buildDagInfoList(list, username);
        return new Viewable("/WEB-INF/dagr/dags", buildDagInfoList);
    }

    @GET
    @Path(value="/dags/{dag : .+}/topological")
    @Produces(value={"application/json"})
    public List<String> getTopological(@PathParam(value="dag") String dagkey) throws Exception {
        DagJGraphT dag = this.dags.getDAG2(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        Function<Dag.Node, String> node2nodeId = new Function<Dag.Node, String>(){

            public String apply(Dag.Node node) {
                return node.getId();
            }
        };
        return Lists.newArrayList((Iterator)Iterators.transform(dag.getTopologicalOrderIterator(), (Function)node2nodeId));
    }

    @GET
    @Path(value="/dags/{dag : .+}/topologicartifacts")
    @Produces(value={"application/json"})
    public List<String> getTopologicartifacts(@PathParam(value="dag") String dagkey) throws Exception {
        DagJGraphT dag = this.dags.getDAG2(dagkey);
        if (dag == null) {
            throw new WebApplicationException("dag [" + dagkey + "] not found", Response.Status.NOT_FOUND);
        }
        Function<Dag.Node, String> node2artifactId = new Function<Dag.Node, String>(){

            public String apply(Dag.Node node) {
                Dag.NodeValue value = node.getValue();
                if (value == null) {
                    return node.getId();
                }
                String gubrid = value.getGubrid();
                if (gubrid == null || gubrid.length() == 0) {
                    return node.getId();
                }
                Iterable split = Splitter.on((char)':').split((CharSequence)gubrid);
                Iterator iterator = split.iterator();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String groupId = (String)iterator.next();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String artifactId = (String)iterator.next();
                if (artifactId == null || artifactId.toString().length() == 0) {
                    return node.getId();
                }
                return artifactId;
            }
        };
        return Lists.newArrayList((Iterator)Iterators.transform(dag.getTopologicalOrderIterator(), (Function)node2artifactId));
    }

    @GET
    @Path(value="/dags/subscription")
    @Produces(value={"application/json"})
    public List<DagInfo> getUserDAGs(@Context HttpServletRequest request) throws Exception {
        String username = Resource.getUsername(request);
        if (username == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<Dag> dagsCollection = this.dags.getUserDAGs(username);
        List<DagInfo> ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @POST
    @Path(value="/dags/subscription/{dag : .+}")
    public Response subscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = Resource.getUsername(request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.subscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    @DELETE
    @Path(value="/dags/subscription/{dag : .+}")
    public Response unsubscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = Resource.getUsername(request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.unsubscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    private List<DagInfo> buildDagInfoList(Collection<Dag> dagsCollection, String username) {
        ArrayList<DagInfo> ret = new ArrayList<DagInfo>(dagsCollection.size());
        for (Dag dag : dagsCollection) {
            DagInfo dagInfo = new DagInfo();
            dagInfo.name = dag.getName();
            dagInfo.key = dag.getKey();
            dagInfo.url = dag.getSource();
            dagInfo.username = username;
            dagInfo.subscribed = username == null ? false : this.dags.isUserSubscribed(dag.getKey(), username);
            ret.add(dagInfo);
        }
        return ret;
    }

    private static String getUsername(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        String username = userPrincipal.getName();
        if (username == null || username.isEmpty()) {
            return null;
        }
        return username;
    }

    public static class DagInfo {
        private String name;
        private String key;
        private String url;
        private Boolean subscribed;
        private String username;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Boolean getSubscribed() {
            return this.subscribed;
        }

        public void setSubscribed(Boolean subscribed) {
            this.subscribed = subscribed;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

