/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aequologica.neo.dagr.jgrapht.DagJGraphT;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.DagDocumentSerializer;
import net.aequologica.neo.geppaequo.cmis.ECMHelper;
import net.aequologica.neo.geppaequo.document.DocumentHelper;

public class Dags {
    private static DagDocumentSerializer serializer = new DagDocumentSerializer();
    private Map<String, Dag> dagmap = null;
    private Map<String, DagJGraphT> graphmap = null;
    private Multimap<String, String> user2dags = null;
    private Multimap<String, String> dag2users = null;
    private ObjectMapper mapper = new ObjectMapper();
    private Path userDagTuplesPath = Paths.get("/.dagr/userdagtuples.json", new String[0]);
    private static Dags instance = null;

    public static Dags getInstance() {
        if (instance == null) {
            instance = new Dags();
        }
        return instance;
    }

    private Dags() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Collection<Dag> getDAGs() {
        return this.dagmap.values();
    }

    public Set<String> getDAGKeys() {
        return this.dagmap.keySet();
    }

    public Dag getDAG(String dagkey) {
        return this.dagmap.get(dagkey);
    }

    public DagJGraphT getDAG2(String dagkey) {
        return this.graphmap.get(dagkey);
    }

    public List<Dag> getUserDAGs(String username) {
        Collection thisUserDags = this.user2dags.get((Object)username);
        ArrayList<Dag> ret = new ArrayList<Dag>(thisUserDags.size());
        for (String dagkey : thisUserDags) {
            Dag dag = this.dagmap.get(dagkey);
            if (dag == null) continue;
            ret.add(dag);
        }
        return ret;
    }

    public List<Map.Entry<String, String>> load() {
        List sources;
        ArrayList exceptions = Lists.newArrayList();
        this.dagmap = new HashMap<String, Dag>();
        this.graphmap = new HashMap<String, DagJGraphT>();
        this.user2dags = ArrayListMultimap.create();
        this.dag2users = ArrayListMultimap.create();
        Path path = Paths.get("/dags", new String[0]);
        try {
            sources = DocumentHelper.list((Path)path);
        }
        catch (Exception e) {
            exceptions.add(new AbstractMap.SimpleImmutableEntry<String, String>(path.toString(), e.getClass().getSimpleName() + " - " + e.getMessage()));
            return exceptions;
        }
        for (Path source : sources) {
            try {
                Dag tmpDag;
                String lowerCase = source.getFileName().toString().toLowerCase();
                if (lowerCase.endsWith(this.userDagTuplesPath.getFileName().toString()) || !lowerCase.endsWith(".json") || (tmpDag = serializer.read(source)) == null) continue;
                Dag dag = new DagJGraphT(tmpDag).detectAndFlagTransitiveEdges();
                dag.setSource(source.toString());
                String dagkey = source.getFileName().toString();
                dag.setKey(dagkey);
                this.dagmap.put(dagkey, dag);
                this.graphmap.put(dagkey, new DagJGraphT(dag));
            }
            catch (Exception e) {
                exceptions.add(new AbstractMap.SimpleImmutableEntry<String, String>(source.toString(), e.getClass().getSimpleName() + " - " + e.getMessage()));
            }
        }
        try {
            this.readUserDagTuples(this.userDagTuplesPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exceptions;
    }

    public boolean subscribe(String dagkey, String username) throws IOException {
        Dag dag = this.dagmap.get(dagkey);
        if (dag == null) {
            throw new IOException("[" + dagkey + "] not found");
        }
        Collection existingDags = this.user2dags.get((Object)username);
        Collection existingUsers = this.dag2users.get((Object)dagkey);
        if (existingDags.contains(dagkey) && existingUsers.contains(username)) {
            return false;
        }
        this.user2dags.put((Object)username, (Object)dagkey);
        this.dag2users.put((Object)dagkey, (Object)username);
        this.writeUserDagTuples(this.userDagTuplesPath);
        return true;
    }

    public boolean unsubscribe(String dagkey, String username) throws IOException {
        Dag dag = this.dagmap.get(dagkey);
        if (dag == null) {
            throw new IOException("[" + dagkey + "] not found");
        }
        Collection existingDags = this.user2dags.get((Object)username);
        Collection existingUsers = this.dag2users.get((Object)dagkey);
        if (!existingDags.contains(dagkey) && !existingUsers.contains(username)) {
            return false;
        }
        this.user2dags.remove((Object)username, (Object)dagkey);
        this.dag2users.remove((Object)dagkey, (Object)username);
        this.writeUserDagTuples(this.userDagTuplesPath);
        return true;
    }

    public Boolean isUserSubscribed(String dagkey, String username) {
        Collection existingUsers = this.dag2users.get((Object)dagkey);
        return existingUsers.contains(username);
    }

    private void writeUserDagTuples(Path path) throws JsonProcessingException, IOException {
        ArrayList<UserDagTuple> userdags = new ArrayList<UserDagTuple>();
        Collection entries = this.user2dags.entries();
        for (Map.Entry entry : entries) {
            userdags.add(new UserDagTuple((String)entry.getKey(), (String)entry.getValue()));
        }
        final byte[] bytes = this.mapper.writeValueAsBytes(userdags);
        DocumentHelper.write((Path)path, (ECMHelper.Stream)new ECMHelper.Stream(){

            public String getMimeType() {
                return MediaType.JSON_UTF_8.toString();
            }

            public long getLength() {
                return bytes.length;
            }

            public InputStream getInputStream() {
                return new ByteArrayInputStream(bytes);
            }
        });
    }

    private void readUserDagTuples(Path path) throws JsonProcessingException, IOException {
        InputStream inputStream = DocumentHelper.getInputStream((Path)path);
        if (inputStream == null) {
            throw new FileNotFoundException(path.toString());
        }
        List userdags = (List)this.mapper.readValue(inputStream, (TypeReference)new TypeReference<List<UserDagTuple>>(){});
        for (UserDagTuple tuple : userdags) {
            this.user2dags.put((Object)tuple.user, (Object)tuple.dag);
            this.dag2users.put((Object)tuple.dag, (Object)tuple.user);
        }
    }

    public static void dumpDag(Path path, Dag dag) throws IOException {
        serializer.write(path, dag);
    }

    private static class UserDagTuple {
        @JsonProperty
        String user;
        @JsonProperty
        String dag;

        private UserDagTuple() {
        }

        private UserDagTuple(String user, String dag) {
            this.user = user;
            this.dag = dag;
        }
    }
}

