package net.aequologica.neo.dagr.jaxrs;

import java.io.IOException;
import java.util.List;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;

@javax.ws.rs.Path("/github")
public class GithubResource {

    @SuppressWarnings("unused")
    private static final Logger log = LoggerFactory.getLogger(GithubResource.class);
    
    ObjectMapper mapper = new ObjectMapper();

    public GithubResource() throws IOException {
        mapper.registerModule(new JSR353Module());
    }

    /*
     * cf. https://developer.github.com/v3/orgs/hooks/
     */
    @POST
    @javax.ws.rs.Path("/notification")
    @Consumes("application/json")
    public Response receiveNotification(String payload) throws IOException {
        
        JsonObject ob = mapper.readValue(payload, JsonObject.class);
        
        System.out.println("ref is "+ob.get("ref"));
        
        JsonObject repositoryObject = ob.getJsonObject("repository");
        if (repositoryObject != null) {
            System.out.println("repository url is "+repositoryObject.get("url"));
        } else {
            System.out.println("repository is null");
        }
        
        JsonObject head_commitObject = ob.getJsonObject("head_commit");
        
        if (head_commitObject != null) {
            System.out.println("head_commit message is "+head_commitObject.get("message"));
            System.out.println("head_commit timestamp is "+head_commitObject.get("timestamp"));
        } else {
            System.out.println("head_commit is null");
        }
        
        JsonObject organizationObject = ob.getJsonObject("organization");
        if (organizationObject != null) {
            System.out.println("organization url is "+organizationObject.get("url"));
            System.out.println("organization login is "+organizationObject.get("login"));
        } else {
            System.out.println("organization is null");
        }
        
        return Response.noContent().build();
    }
    
    public static class User {
        private String name;
        private String email;
    }
    
    public static class Commit {
        private String id;
        private String message;
        private String timestamp;
        private String url;
        private List<String> added;
        private List<String> removed;
        private List<String> modified;
        private User author;
    }
    
    public static class Repository {
        private String name;
        private String url;
        private String description;
        private int watchers;
        private int forks;
        private boolean private_;
        private User owner;

        public boolean isPrivate() {
            return this.private_;
        }

        public void setPrivate(boolean private_) {
            this.private_ = private_;
        }
    }
    
    public static class Payload {
        private User pusher;
        private String ref;
        private List<Commit> commits;
        private Commit head_commit;
        private Repository repository;
    }
}
