<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
%><%@taglib prefix="c"  uri="http://java.sun.com/jstl/core_rt"
%><%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@taglib prefix="t"  tagdir="/WEB-INF/tags"
%><%
%><!DOCTYPE html>
<c:set var="baseURL" value="${pageContext.request.scheme}://${pageContext.request.serverName}:${pageContext.request.serverPort}${pageContext.request.contextPath}"/>
<c:set var="ellipsis"  value="⋯"/> <!-- &#8943; -->
<c:set var="vellipsis" value="⋮"/> <!-- &#8942; -->
<xmp theme="united" style="display:none; padding-top: 120px;">
<%@include file="HOW-TO.md" %>
</xmp>

<t:layout jsmodules="angular moment handlebars zeroclipboard">

<style>
ul {
  list-style-type: none;
}
ul#checks {
  padding-left: 0px;
}
ul#checks li {
  margin: 0 0 2em 0;
}
</style>

<script id="handlebars_source" type="text/x-handlebars-template"><ul style=" list-style-type: none; margin:0; padding:0;">{{#each messages}}<li><address>
  <strong>{{this.key}}</strong><br/>
  {{this.value}}
</address></li>{{/each}}</ul></script>

</t:layout>

<script src='<c:url value="/assets/scripts/strapdown.js"/>' ></script>

<script type="text/javascript">

$(document).ready(function() {
  var handlebars_source   = $("#handlebars_source").html();
  var handlebars_template = Handlebars.compile(handlebars_source);

  $(document).ajaxStart(function() {
      $('#ajaxLoading').attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.gif'/>" });
  });

  $(document).ajaxStop(function() {
    $('#ajaxLoading').attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.png'/>" });
  });

  var format = 'MMMM Do YYYY, h:mm:ss a';

  $('#reload').click(function() {
    $.ajax({
        url: '<c:url value="/dags"/>',
        type: 'POST',
        cache: false,
        contentType: false,
        processData: false
    }).done(function( data, textStatus, jqXHR ) {
      // window.log("ok");
      var now = moment().format(format);
      var messages = handlebars_template({messages: data});
      $("#messages").empty();
      var alert_class   = data.length == 0 ? "alert-success" : "alert-warning";
      var alert_message = data.length == 0 ? "reloaded"      : "reloaded with warnings";
      $( "#alert" ).clone()
                   .addClass(alert_class)
                   .show()
                   .append("["+textStatus+"] "+messages+"<small>"+now+"</small>&nbsp;<strong>"+alert_message+"!</strong>")
                   .appendTo( "#messages" );
    }).fail(function( jqXHR, textStatus, errorThrown ) {
      // window.log("fail");
      var now = moment().format(format);
      $("#messages").empty();
      $( "#alert" ).clone()
                   .addClass("alert-warning")
                   .show()
                   .append("["+textStatus+"] "+now+"| <strong>oops!</strong> something wrong happened while sending a POST to [" +this.url + "]. Error:' '"+ errorThrown + "'")
                   .insertAfter( "#reload" );
    }).always(function( data_jqXHR, textStatus, jqXHR_errorThrown ) {
      // window.log("always");
    });

  });
});

</script>
