<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" tagdir="/WEB-INF/tags"
%><t:layout jsmodules="angular">

  <style>
    .toprightfloatingtoolbar {
      float:right; 
      white-space: nowrap; 
      overflow: hidden;
    }
    ul {
      list-style-type: none;
    }
  </style>

  <span class="toprightfloatingtoolbar">
    <a href="<c:url value='/modules/dagr/'/>"           title="show dag(s)"><i class="fa fa-paw"></i></i></a>
    <a href="<c:url value='/modules/dagr/how-to.jsp'/>" title="how-to"     ><i class="fa fa-question-circle"></i></a>
  </span>

  <div ng-app="ngAppDAGs">
    <h2>all DAGs</h2>
    <div ng-controller="DAGsCtrl">
      <ul class="unstyled col-lg-8">
        <li ng-repeat="dag in dags| orderBy:'name'" style="border-bottom: 1px dashed #999;">
          <input type="checkbox" ng-model="dag.subscribed" ng-change="change()">
            <a href="<c:url value='/dags/'/>{{dag.key}}" target="{{dag.key}}">{{dag.name}}</a>
          </input>
        </li>
      </ul>
    </div>
  </div>

  <span id="back_to_index" class="alert alert-info col-lg-8" >
      <span>Click the <a href="<c:url value='/dags/'/>">top right <i class="fa fa-paw"></i> icon</a> to display selected dag(s)</span>
  </span>

</t:layout>

<script type="text/javascript">

angular.module('ngAppDAGs', ['angular-loading-bar'])
.config(function(cfpLoadingBarProvider) {
  cfpLoadingBarProvider.includeSpinner = true;
})
.controller( 'DAGsCtrl',

  function($scope, $http) {
    $scope.dags   = [];
    $http({
        method: 'GET',
        url: "<c:url value='/dags' />",
      }).success(function(data, status, headers, config) {
        $scope.dags = data;
      }).error(function(data, status, headers, config) {
        $scope.dags = [];
    });

    $scope.change = function() {
        $http({
            method: this.dag.subscribed ? 'POST': 'DELETE',
            url: "<c:url value='/dags/subscription/' />"+this.dag.key
        });
    };
  }
);

</script>
