<%-- cf. http://stackoverflow.com/questions/1296235/jsp-tricks-to-make-templating-easier --%>
<%@ tag       description="Layout Tag" pageEncoding="UTF-8" trimDirectiveWhitespaces="true"%>
<%@ tag       import="net.aequologica.neo.geppaequo.config.ConfigRegistry"%>
<%@ tag       import="net.aequologica.neo.geppaequo.servlet.TitleAndModule"%>
<%@ tag       import="net.aequologica.neo.geppaequo.servlet.WebJar"%>
<%@ tag       import="java.util.HashMap"%>
<%@ tag       import="java.util.Map"%>
<%@ tag       import="org.webjars.WebJarAssetLocator"%>
<%@ taglib    prefix="c"    uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib    prefix="fn"   uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ attribute name="module" required="false"%>
<%@ attribute name="jsmodules" required="false"%>
<%

// compute title and module from a mix of
//     1. optional 'module' tag attribute to force module
//     2. servlet path
//     3. context path
TitleAndModule titleAndModule = TitleAndModule.fromRequest(module, request);

jspContext.setAttribute("title", titleAndModule.getTitle());
jspContext.setAttribute("module2", titleAndModule.getModule());

%><!DOCTYPE html>
<!-- # BEGIN layout.tag / / / / / / / / / / / / / / / / / / / / -->
<html lang="en">
  <head>
    <meta charset="utf-8">

    <title>${title}</title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1">

    <link rel="stylesheet" type="text/css" href="<c:url value='<%=WebJar.locate("css/bootstrap.css")%>'/>" />
    <link rel="stylesheet" type="text/css" href="<c:url value='<%=WebJar.locate("font-awesome.css")%>' />" />

    <c:if test="${fn:contains(jsmodules, 'datatables')}">
    <link rel="stylesheet" type="text/css" href="<c:url value='<%=WebJar.locate("css/jquery.dataTables.css")%>' />" />
    </c:if>

    <style type="text/css">

    @font-face {
      font-family: 'Geppaequo';
      font-size: larger;
      font-style: normal;
      font-weight: 400;
      src: local('Geppaequo'), url(<c:url value='/assets/fonts/geppaequo.woff'/>) format('woff');
    }

    <c:if test="${fn:contains(jsmodules, 'datatables')}">
    div.dataTables_length > label ,
    div.dataTables_filter > label {
      font-weight:inherit;
    }

    table > caption {
      text-align:inherit;
    }

    table.dataTable thead .sorting               { background: #fff url("<c:url value='/assets/images/i_both_arrow.png'          />") no-repeat center right; }
    table.dataTable thead .sorting_asc           { background: #fff url("<c:url value='/assets/images/i_asc_arrow.png'           />") no-repeat center right; }
    table.dataTable thead .sorting_desc          { background: #fff url("<c:url value='/assets/images/i_desc_arrow.png'          />") no-repeat center right; }

    table.dataTable thead .sorting_asc_disabled  { background: #fff url("<c:url value='/assets/images/i_asc_disabled_arrow.png'  />") no-repeat center right; }
    table.dataTable thead .sorting_desc_disabled { background: #fff url("<c:url value='/assets/images/i_desc_disabled_arrow.png' />") no-repeat center right; }
    </c:if>

    </style>

    <link rel="stylesheet" type="text/css" href="<c:url value='/styles/geppaequo.css'/>">
    <link rel="stylesheet" type="text/css" href="<c:url value='/styles/sticky-footer-navbar.css'/>" />

    <c:if test="${fn:contains(jsmodules, 'angular')}">
        <link rel="stylesheet" type="text/css" href="<c:url value='<%=WebJar.locate("loading-bar.css")%>' />" />
    </c:if>

    <c:if test="${fn:contains(jsmodules, 'zeroclipboard')}">
        <link rel="stylesheet" type="text/css" href="<c:url value='/styles/geppaequo-zeroclipboard.css' />" />
    </c:if>

    <!-- link rel="shortcut icon" href="<c:url value='${applicationScope.geppaequo.favicon}'/>" -->
    <!-- BEGIN favicons - generated though http://realfavicongenerator.net/ -->
    <link rel="apple-touch-icon" sizes="57x57" href="<c:url value='/apple-touch-icon-57x57.png' />">
    <link rel="apple-touch-icon" sizes="60x60" href="<c:url value='/apple-touch-icon-60x60.png' />">
    <link rel="apple-touch-icon" sizes="72x72" href="<c:url value='/apple-touch-icon-72x72.png' />">
    <link rel="apple-touch-icon" sizes="76x76" href="<c:url value='/apple-touch-icon-76x76.png' />">
    <link rel="apple-touch-icon" sizes="114x114" href="<c:url value='/apple-touch-icon-114x114.png' />">
    <link rel="apple-touch-icon" sizes="120x120" href="<c:url value='/apple-touch-icon-120x120.png' />">
    <link rel="apple-touch-icon" sizes="144x144" href="<c:url value='/apple-touch-icon-144x144.png' />">
    <link rel="apple-touch-icon" sizes="152x152" href="<c:url value='/apple-touch-icon-152x152.png' />">
    <link rel="apple-touch-icon" sizes="180x180" href="<c:url value='/apple-touch-icon-180x180.png' />">
    <link rel="icon" type="image/png" href="<c:url value='/favicon-32x32.png" sizes="32x32' />">
    <link rel="icon" type="image/png" href="<c:url value='/android-chrome-192x192.png" sizes="192x192' />">
    <link rel="icon" type="image/png" href="<c:url value='/favicon-96x96.png" sizes="96x96' />">
    <link rel="icon" type="image/png" href="<c:url value='/favicon-16x16.png" sizes="16x16' />">
    <link rel="manifest" href="<c:url value='/manifest.json' />">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="msapplication-TileImage" content="<c:url value='/mstile-144x144.png' />">
    <meta name="theme-color" content="#ffffff">
    <!-- END favicons --->
    
  </head>
  <body>

    <!-- title == '${title}' -->
    <!-- module == '${module}' -->
    <!-- module2 == '${module2}' -->

    <%-- BEGIN print the github ribbon --------------------------------------------------------------------------------------------------------------------------------------- --%>
    <c:if test="${applicationScope.geppaequo.showGithubRibbon}">
      <c:if test="${ pageContext.request.isUserInRole('wizard') ||
                     pageContext.request.isUserInRole('LOCAL')}" >
        <c:if test="${!empty applicationScope.geppaequo_configMap[module2].gitRepositoryState.commitURI}">
          <a href="${applicationScope.geppaequo_configMap[module2].gitRepositoryState.commitURI}" id="github_ribbon" target="_blank" class="visible-lg">
            <img src="<c:url value='/assets/images/forkme.png'/>" alt="fork me">
          </a>
        </c:if>
      </c:if>
    </c:if>
    <%-- END print the github ribbon ----------------------------------------------------------------------------------------------------------------------------------------- --%>

    <!-- animated gif displayed while loading dynamic header/footer -->
    <div id="loading">
      <img class="" alt="loading..." src="<c:url value='/assets/images/ajax-loader.gif'/>"/>
    </div>

    <!-- BEGIN calculation of activeModulo  -->
    <c:forEach var="modulo" items="${applicationScope.geppaequo_modules}">
      <c:if test="${fn:endsWith(pageContext.request.servletPath, modulo.name.concat('/index.jsp'))}" >
        <c:set var="activeModulo" value="${modulo.name}"/>
      </c:if>
    </c:forEach>

    <c:if test="${empty activeModulo}" >
      <c:forEach var="modulo" items="${applicationScope.geppaequo_modules}">
        <c:if test="${module2 == modulo.name}" >
          <c:set var="activeModulo" value="${modulo.name}"/>
        </c:if>
      </c:forEach>
    </c:if>

    <c:if test="${empty activeModulo}" >
      <c:if test="${pageContext.request.servletPath == '/index.jsp'}" >
          <c:set var="activeModulo" value="/"/>
      </c:if>
    </c:if>

    <c:if test="${empty activeModulo}" >
      <c:set var="activeModulo" value="geppaequo"/>
    </c:if>
    <!-- END calculation of activeModulo  -->

    <!-- wrap all page content here -->
    <div id="wrap">
      <header class="navbar ${applicationScope.geppaequo.navbarStyle} navbar-fixed-top" role="banner">
        <div class="container">
          <div class="navbar-header">
            <button class="navbar-toggle" type="button" data-toggle="collapse" data-target=".bs-navbar-collapse">
              <span class="sr-only">Toggle navigation</span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
            </button>
            <a href="<c:url value='/'/>" class="navbar-brand<c:if test="${activeModulo == '/'}"> active</c:if>">
              <c:if test="${not empty applicationScope.geppaequo.homeImg}">
                <img src="<c:url value='${applicationScope.geppaequo.homeImg}'/>">
              </c:if>
              <c:if test="${empty applicationScope.geppaequo.homeImg}">
                <i class="fa fa-${applicationScope.geppaequo.homeFontAwesomeIconName}"></i>
              </c:if>
            </a>
          </div>
          <nav class="collapse navbar-collapse bs-navbar-collapse" role="navigation">
            <ul class="nav navbar-nav">
              <c:forEach var="modulo" items="${applicationScope.geppaequo_modules}">
                <li id="${modulo.name}"
                    class="<c:if test="${activeModulo == modulo.name}">active</c:if>">
                  <a href="<c:url value='/modules/${modulo.name}'/>"
                     style='<c:if test="${not empty modulo.subs}">padding-right:7px;</c:if>'>
                     ${modulo.name}
                  </a>
                </li>
                <c:if test="${not empty modulo.subs}">
                  <li style="max-height:50px; height:50px;" class="<c:if test='${activeModulo == modulo.name}'>active</c:if>">
                    <span style="width: 1px; background-color: gray; display: inline-block; height: 20px; margin: 15px 0 15px 0;"></span>
                  </li>
                  <li class="dropdown<c:if test='${activeModulo == modulo.name}'> active</c:if>" >
                    <a href="#"
                       class="dropdown-toggle"
                       data-toggle="dropdown"
                       style="padding-left:7px;">
                      <i class="fa fa-caret-down"></i>
                    </a>
                    <ul class="dropdown-menu">
                      <c:forEach var="sub" items="${modulo.subs}">
                        <li>
                          <a href="<c:url value='/modules/${modulo.name}/${sub.name}${sub.extension}' />">
                            ${modulo.name}&nbsp;<i class="fa fa-caret-right"></i>&nbsp;${sub.name}
                          </a>
                        </li>
                      </c:forEach>
                    </ul>
                  </li>
                </c:if>
              </c:forEach>
            </ul>
            <c:if test="${empty pageContext.request.remoteUser}">
              <ul class="nav navbar-nav navbar-right">
                <li>
                  <a href="<c:url value='/modules/login.jsp' />"  title="login">
                    <b class="fa fa-sign-in"></b><span>Sign in</span>
                  </a>
                </li>
              </ul>
            </c:if>
            <c:if test="${not empty pageContext.request.remoteUser}">
              <ul class="nav navbar-nav navbar-right">
                <li <c:if test='${title == "whoami"}'>class="active"</c:if> >
                  <a  id="pageContext_request_remoteUser"
                      href="<c:url value='/whoami.jsp' />"
                      title="${userInfo.firstname} ${userInfo.lastname}">
                    <b class="fa fa-user"></b><span>${pageContext.request.remoteUser}</span>
                  </a>
                </li>
                <li class="dropdown" >
                  <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                    <b class="fa fa-cog"></b><i class="caret"></i>
                  </a>
                  <ul class="dropdown-menu">
                    <c:if test="${pageContext.request.isUserInRole('wizard') || pageContext.request.isUserInRole('LOCAL')}">
                      <c:forEach var="wizard" items="${applicationScope.geppaequo_wizardry}">
                        <li>
                          <a href="<c:url value='/wizardry/${wizard.name}${wizard.extension}' />"><span>${wizard.name}</span></a>
                        </li>
                      </c:forEach>
                      <li class="divider"></li>
                    </c:if>
                    <li>
                      <a href="<c:url value='/logout.jsp' />"  title="logout">
                        <b class="fa fa-sign-out"></b><span>Sign out</span>
                      </a>
                    </li>
                  </ul>
                </li>
              </ul>
            </c:if>
          </nav>
        </div>
      </header>
      <div class="container">
        <c:if test="${applicationScope.geppaequo.dynamicHTML}">
          <div id="loaded" style="visibility:hidden;">
            <div id="geppaequo-header" class="col-lg-12" >
          </div>
          <div id="geppaequo-body">
<!-- # BEGIN jsp:doBody // // // // // // // // // // // // // // // // -->
<jsp:doBody/>
<!-- # END   jsp:doBody \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ -->
          </div> <!-- /#geppaequo-body -->
          <div id="geppaequo-footer" class="col-lg-12" >
            </div>
          </div><!--/#loaded -->
        </c:if>
        <c:if test="${!applicationScope.geppaequo.dynamicHTML}">
          <div id="geppaequo-body">
<!-- # BEGIN jsp:doBody // // // // // // // // // // // // // // // // -->
<jsp:doBody/>
<!-- # END   jsp:doBody \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ -->
          </div> <!-- /#geppaequo-body -->
        </c:if>
      </div><!-- /.container -->
    </div><!--/#wrap -->
    <div class="container">
      <footer>
        <p class="pull-right">&copy; ${applicationScope.geppaequo.copyright}</p>
      </footer>
    </div><!--/.container -->
  </body>

  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("underscore-min.js")%>' />" ></script>

  <c:if test="${fn:contains(jsmodules, 'modernizr')}">
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("modernizr.min.js")%>' />" ></script>
  </c:if>

  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("2.1.4/jquery.min.js")%>' />" ></script>
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("js/bootstrap.min.js")%>' />" ></script>

  <c:if test="${fn:contains(jsmodules, 'bootbox')}">
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("bootbox.js")%>' />" ></script>
  </c:if>

  <c:if test="${fn:contains(jsmodules, 'typeahead')}">
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("typeahead.bundle.min.js")%>' />" ></script>
  </c:if>

  <c:if test="${fn:contains(jsmodules, 'datatables')}">
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("jquery.dataTables.js")%>' />" ></script>
  </c:if>

  <c:if test="${fn:contains(jsmodules, 'handlebars')}">
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("handlebars.min.js")%>' />" ></script>
  </c:if>

  <c:if test="${fn:contains(jsmodules, 'moment')}">
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("moment.min.js")%>' />" ></script>
  </c:if>

  <c:if test="${fn:contains(jsmodules, 'angular')}">
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("angular.min.js")%>' />" ></script>
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("angular-animate.min.js")%>' />" ></script>
  <script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("loading-bar.min.js")%>' />" ></script>
  </c:if>

  <c:if test="${fn:contains(jsmodules, 'zeroclipboard')}">
  <script type="text/javascript"            src="<c:url value='<%=WebJar.locate("ZeroClipboard.js")%>' />"></script>
  <script type="text/javascript"            src="<c:url value='/scripts/geppaequo-zeroclipboard.js' />"></script>
  </c:if>

  <script type="text/javascript" charset="utf8" src="<c:url value='/assets/scripts/base64.js' />" ></script>

  <script type="text/javascript" charset="utf8" src="<c:url value='/scripts/ie.js' />" ></script>
  <script type="text/javascript" charset="utf8" src="<c:url value='/scripts/geppaequo-2.js' />" ></script>

  <script type="text/javascript">

    // http://www.browser-update.org/#
    {
        var $buoop = {c:2}; 
    	function $buo_f(){ 
    	 var e = document.createElement("script"); 
    	 e.src = "//browser-update.org/update.js"; 
    	 document.body.appendChild(e);
    	};
    	try {document.addEventListener("DOMContentLoaded", $buo_f,false)}
    	catch(e){window.attachEvent("onload", $buo_f)}
    }

    Geppaequo.setContextPath('<c:url value="/"/>');

    jQuery(document).ready(function($) {

      if (IE.isTheBrowser) {
         if (IE.actualVersion < 9) {
            $("div#wrap > div.container").html("<div class='alert alert-danger'><i class='fa fa-ban' style='font-size:48px;'></i> Internet Explorer versions <strong>&lt; 9</strong> are not supported.</div>");
            Geppaequo.showBody(false);
            return;
         } else if (IE.actualVersion < 10) {
            $("div#wrap > div.container").prepend("<div class='alert alert-warning'><i class='fa fa-exclamation-triangle' style='font-size:48px; color: gold;'></i> Limited support for Internet Explorer version <strong>9</strong>. Use at your own risk.</div>");
         }
      }

      Geppaequo.showBody("<c:if test='${applicationScope.geppaequo.dynamicHTML}'>true</c:if>");

      <c:if test="${fn:contains(jsmodules, 'zeroclipboard')}">zeroClipboardSetup(Geppaequo.contextPath);</c:if>

    });
  </script>

</html>
<!-- # END layout.tag \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ -->
