<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ page import="net.aequologica.neo.geppaequo.servlet.WebJar"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" tagdir="/WEB-INF/tags"
%><% net.aequologica.neo.geppaequo.servlet.ZeroUtils.HostContextUserAccountAndApp(request);
%><t:layout module="dagr" jsmodules="datatables moment handlebars">

<style>
.toprightfloatingtoolbar {
    float:right; 
    white-space: nowrap; 
    overflow: hidden;
}

.dag svg {
    border: 1px solid #ccc;
    padding-left: 40px;
}

.dag .node rect {
  stroke: #bbb;
  fill: none;
}

.dag .edgePath path {
  stroke: #444;
  stroke-width: 1px;
  fill: none;
}

td, th  {
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

a > span.date {
  margin-left: .5em;
  font-size: smaller;
}

g.node, g.node > rect, g.node > g > g > text {
   cursor: pointer;
}

</style>

  <span class="toprightfloatingtoolbar">
    <a href="javascript:void(0)"            id="shorten" title="short label"  ><i class="fa fa-minus-square"></i></a>
    <a href="<c:url value='/modules/dagr/dags.jsp'/>"    title="select dag(s)"><i class="fa fa-list"></i></a>
    <a href="<c:url value='/modules/dagr/how-to.jsp'/>"  title="how-to"       ><i class="fa fa-question-circle"></i></a>
  </span>

  <div id="container">
    <span id="no_tab_defined" class="alert alert-warning col-lg-8" style="display:none" >
      <span class="label label-warning">warning</span>
      <span>no DAG selected. Click the <a href="<c:url value='/modules/dagr/dags.jsp'/>">top right <i class="fa fa-list"></i> icon</a> to select a DAG.</span>
    </span>
  </div>

<%-- BEGIN ------------------ handlebars templates ------------------ BEGIN --%>

<script id="tab_url" type="text/x-handlebars-template"
><a
  href="url"
  target="target"
>url</a>
</script>

<script id="basic_template" type="text/x-handlebars-template"
><tr id="{{this.key}}" >
<td ><span class="index"    >{{this.index   }}</span></td>
<td ><span class="artifact" >{{this.artifact}}</span></td>
</tr></script>

<script id="gav_template" type="text/x-handlebars-template"
><tr id="{{this.key}}" >
<td ><span class="index"    >{{this.index   }}</span></td>
<td ><span class="group"    >{{this.group   }}</span></td>
<td ><span class="artifact" >{{this.artifact}}</span></td>
<td ><span class="version"  >{{this.version }}</span></td>
<td ><span class="latest"   ><img class="ajaxLoading" ></img></span></td>
<td ><span class="release"   ><img class="ajaxLoading" ></img></span></td>
<td >
  <span class="travis" id="span_{{this.repoid}}" >
    <a href="https://travis-ci.org/{{this.reponame}}" target="travis">
    {{#if this.branch}}
      <img src="https://travis-ci.org/{{this.reponame}}.svg?branch={{this.branch}}" onerror="this.src=''" ></img>
    {{/if}}
    </a>
    &nbsp;
    <a class="trigger" id="{{this.repoid}}" title="trigger a rebuild of {{this.reponame}}" href="javascript:void(0)">
      
    </a>
  </span>
</td>
<td ><span class="scm"      ><a href="{{this.scm}}/tree/{{this.branch}}" target="github">{{this.scm}}</a></span></td>
</tr></script>

<script id="tab_definitions" type="text/x-handlebars-template"
 ><ul class="nav nav-tabs">
  {{#each items}}
    <li><a id="tab_{{this.id}}" href="#tab{{this.id}}" data-toggle="tab">{{this.name}}<span class="date"></span></a></li>
  {{/each}}
</ul>

<div id="dag-name" style="display:none;"></div>

<div id="myTabContent" class="tab-content">
  {{#each items}}
    <div class="tab-pane fade in" id="tab{{this.id}}">
      <div class="row">
        <div class="col-lg-12">
          <div style="margin:20px 0 20px 0;">
            <div class="dag" id="dag{{this.id}}">
                <svg id="svg{{this.id}}" height="80" width="100%">
                    <g transform="translate(30, 20)" />
                </svg>
            </div>
          </div>
        </div>
        <div class="col-lg-12">
            <h3>Topological Sort</h3>
            <div class="topo" id="topo{{this.id}}">
            </div>
        </div>
      </div>
    </div>
  {{/each}}
</div></script>
<%-- END ------------------ handlebars templates ------------------ END --%>
</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("d3.min.js")%>' />" ></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dagre-d3.js")%>' />" ></script>

<script src="<c:url value="/scripts/zero.js"/>"></script>

<script type="text/javascript">

  var formatDate = function(datetime, format) {
    if (moment) {
      return moment(datetime).format(format);
    } else {
      return datetime;
    }
  }

  Handlebars.registerHelper("formatDate", formatDate);

  var theGraph;
  var theSVGParent;

  var items = {
    items : [
      <c:forEach items="${model}" var="_this_" varStatus="status">
        <c:if test="${_this_.subscribed}">
        {
          id         : '${status.count}',
          name       : '${_this_.name}',
          key        : '${_this_.key}',
          source     : '${_this_.url}',
          subscribed :  ${_this_.subscribed},
        },
        </c:if>
      </c:forEach>
    ]
  };

  $(document).ready(function(){

    $('#shorten').click(function(event) {
        event.preventDefault();
        var $i = $(this).children("i");
        var plus = $i.attr("class").indexOf('fa-plus-square');
        if (plus != -1) {
          $i.removeClass('fa-plus-square');
          $i.addClass('fa-minus-square');
          $(this).attr('title', 'short label');
        } else {
          $i.removeClass('fa-minus-square');
          $i.addClass('fa-plus-square');
          $(this).attr('title', 'long label');
        }
        DAG.renderGraph(theGraph, theSVGParent);
        wire();
    });

    function wire () {
      $( "g.node" ).on('click', function(event) {
        window.log(this);
        var where = $("tr#"+this.id+" > td > span.scm > a").attr('href');
        if (where) {
          window.open(where,'_blank');
        }
      });
      
      $( "g.node" ).mouseenter(function(event) { 
        var $rect = $(this).find("rect");
        if ($rect.length) {
          var dataBG = $rect.attr('data-bg');
          if (!dataBG) {
            $rect.attr('data-bg', $rect.css('fill')) 
          }
          $rect.css('fill', '#efefef');
        } 
        if (this.__data__) {
          $('tr#'+this.__data__).css('background-color', '#efefef');
        }
      });
      
      $( "g.node" ).mouseleave(function(event) {
        var $rect = $(this).find("rect");
        if ($rect.length) {
          var dataBG = $rect.attr('data-bg');
          if (!dataBG) {
            $rect.css('fill', "none");
          } else {
            $rect.css('fill', dataBG);
          }
        }
        if (this.__data__) {
          $('tr#'+this.__data__).css('background-color', 'inherit');
        }
      });
      $( "table.table tr" )
      .mouseenter(function(event) {
        if (this.id) {
          var $rect = $('.node#'+this.id).find('rect');
          if ($rect.length) {
            var dataBG = $rect.attr('data-bg');
            if (!dataBG) {
              $rect.attr('data-bg', $rect.css('fill')) 
            }
            $rect.css('fill', '#efefef');
          } 
        }
        $(this).css('background-color', '#efefef');
      })
      .mouseleave(function(event) {
        if (this.id) {
          var $rect = $('.node#'+this.id).find('rect');
          if ($rect.length) {
            var dataBG = $rect.attr('data-bg');
            if (!dataBG) {
                $rect.css('fill', "none");
            } else {
                $rect.css('fill', dataBG);
            }
          }
        }
        $(this).css('background-color', 'inherit');
      });      
    }

    var ajaxLoading = "<c:url value='/assets/images/animated_orange_refresh_22.gif'/>",
        ajaxLoaded  = "<c:url value='/assets/images/animated_orange_refresh_22.png'/>";

    var nexus      = "${applicationScope.geppaequo.nexus}";
    var repository = "${applicationScope.geppaequo.repository}";

    zeroModule.init("${pageContext.request.serverName}",
                    nexus,
                    "<c:url value='/proxy.jsp?'/>");

    var tab_definitions_template = Handlebars.compile($("#tab_definitions").html());
    var tab_url_template         = Handlebars.compile($("#tab_url").html());
    var gav_template             = Handlebars.compile($("#gav_template").html());
    var basic_template           = Handlebars.compile($("#basic_template").html());

    if (items.items.length == 0 ) {
      $('#no_tab_defined').show();
    } else {
      $('#container').html(tab_definitions_template(items));
      $('#container ul li:first-child').addClass('active');
      $('#container div div:first-child').addClass('active');

      $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        DAG.renderGraph(theGraph, theSVGParent);
        wire();
      });

      $.each(items.items, function( index, dagInfo ) {

        $.ajax({
            url: '<c:url value="/dags/"/>' + dagInfo.key,
            dataType: "json",
        }).done(function(data) {
            
           if (data.date) {
             $("a#tab_"+dagInfo.id+" span.date").text('[' + formatDate(new moment(data.date), "dddd, MMMM Do YYYY, h:mm:ss a") + ']');
           }
            
           $.each(data.nodes, function( index, node ) {
             node.value.label0 = node.value.label;
           });

          loadData(data, dagInfo.id);

          $.ajax({
              url: '<c:url value="/dags/"/>' + dagInfo.key + '/topological',
              dataType: "json",
          }).done(function(topologicalSort) {

            var $topotable = $('<table class="table"></table>');
            
            $('#topo'+dagInfo.id).html($topotable);

            // map node key to node value
            var nodeKey2ValueMap = {};
            $.each(data.nodes, function( index, node ) {
              nodeKey2ValueMap[node.id] = node.value;
            });

            var countoks = 0;
            $.each(topologicalSort, function( index, dagkey ) {
              var nodeValue = nodeKey2ValueMap[dagkey];
              var gav = gavpce(nodeValue.gav);
              var selector = dagkey.replace(/\./gi, "\\.");

              if (gav.ok()) {
                 countoks += 1;
              }
              // row
              {
                var instantiatedTemplate;
                if (gav.ok()) {
                  var shortgav = gav.g.replace(/net\.(.*)\.neo/g, "$1");
                  var reponame = shortgav+"/"+gav.a;
                  var repoid = reponame.replace(/\//g, "_");
                  var github = "";
                  if (nodeValue.scm !== "undefined" && nodeValue.scm != null) {
                      github = nodeValue.scm.replace(/\.git/g, "");
                  }
                  var shortbranch = "";
                  if (nodeValue.branch !== "undefined" && nodeValue.branch != null ) {
                      shortbranch = nodeValue.branch.replace(/refs\/heads\//g, "");
                  }
                  instantiatedTemplate = gav_template({index:index, key:dagkey, scm:github, branch:shortbranch, group:gav.g, artifact:gav.a, version:gav.v, reponame:reponame, repoid:repoid});
                  $.ajax({
                    url: "https://api.travis-ci.org/repos/"+reponame+"/branches",
                    crossDomain: true,
                    headers: { 'Accept'        : 'application/vnd.travis-ci.2+json', 
                               'Authorization' : 'token 8W0KwXx3rb-5PFC721NTJA'}
                  })
                  .fail(function( data ) {
                      $( "span.travis#_span"+repoid ).css( {'display' : 'none'});
                  })
                  .done(function( data ) {
                    var foundJob = null;{
                      // search in commits array for the branch
                      var foundCommit = null;
                      {
                        for (var commit of data.commits) {
                          if (commit.branch==shortbranch) {
                            foundCommit = commit.id;
                            break;
                          }
                        }
                      }
                      if (foundCommit != null) {
                        // search in commits array for the branch
                        for (var branch of data.branches) {
                          if (branch.commit_id==foundCommit) {
                            foundJob = branch.job_ids[0];
                            break;
                          }
                        }
                      }
                    }
                    if (foundJob != null) {
                      $( "a.trigger#"+repoid ).click(function() {
                        $.ajax({
                          url: 'https://api.travis-ci.org/jobs/'+foundJob+'/restart',
                          method: "POST",
                          crossDomain: true,
                          headers: {'Accept'        : 'application/vnd.travis-ci.2+json', 
                                    'Authorization' : 'token 8W0KwXx3rb-5PFC721NTJA'}
                        });
                      }).html( $('<i class="fa fa-play"/>') );
                    } else {
                      $( "a.trigger#"+repoid ).html( '' );
                    }
                  });
                } else {
                  instantiatedTemplate = basic_template({index:index, key:dagkey, artifact:nodeValue.label});
                }
                $topotable.append(instantiatedTemplate);
              }

              if (gav.ok()) {
                zeroModule.getIt(
                  {
                    group      : gav.g,
                    artifact   : gav.a,
                    packaging  : gav.p
                  },
<c:if test="${fn:startsWith(app, 'prod')}">
                  "snapshots",
</c:if>
<c:if test="${not fn:startsWith(app, 'prod')}">
                  repository,
</c:if>
                  function () {
                    $('tr#'+selector+' td img.ajaxLoading').attr({src:ajaxLoading}).css('visibility', 'visible');
                  },
                  function(it, where) {
                    if (!it.status) {
                      $('tr#'+selector+' td span.'+where).empty();
                    } else {
                      $('tr#'+selector+' td span.'+where)
                        .html(it.version)
                        .wrap($('<a>')
                        .attr({ href : it.buildContentURL,
                                title : 'download'
                        }));
                    }
                    $('tr#'+selector+' td span.version')
                      .wrap($('<a>')
                      .attr({ href: it.browseURL,
                              target: it.browseTarget }));
                  },
                  function() {
                    $('tr#'+selector+' td img.ajaxLoading').attr({src:ajaxLoaded}).css('visibility', 'hidden');
                  }
                );   // zeroModule.getIt
              }    // topological item has a gav ?
            });  // each topological item
            if (countoks == topologicalSort.length) {
              $topotable.prepend("<tr><th>order</th><th>group</th><th>artifact</th><th>version</th><th><a href='"+zeroModule.artifactSnapshotServer.URL+"' target='_blank'>"+"snapshot"+"</a></th><th><a href='"+zeroModule.artifactReleaseServer.URL+"' target='_blank'>"+"release"+"</a></th><th>build</th><th>sources</th></tr>");
            }

            wire();

          });  // ajax load topological sort
        });  // ajax load dag
      });  // for each of the dag selected
    }    // any dag selected ?
  });  // document ready

  (function () {
      'use strict';
      window.DAG = {
          displayGraph: function (graph, dagNameElem, svgElem) {
              dagNameElem.text(graph.name);
              this.renderGraph(graph, svgElem);
          },

          renderGraph: function(graph, svgParent) {
              theGraph = graph;
              theSVGParent = svgParent;
              var nodes = graph.nodes;
              var links = graph.links;

              var plus = $('#shorten').children("i").attr("class").indexOf('fa-plus-square');
              $.each(nodes, function( index, node ) {
                var value = node.value;
                  if (plus == -1) {
                    value.label = value.label0;
                  } else {
                    var space =  value.label0.indexOf(' ');
                    if (space== -1) {
                        value.label = value.label0;
                    } else {
                        value.label = value.label0.substr(0,space);
                    }
                  }
              });

              var graphElem = svgParent.children('g').get(0);
              $(graphElem).empty();

              // Create the renderer
              var render = new dagreD3.render();

              // Set up an SVG group so that we can translate the final graph.
              var svg   = d3.select(graphElem),
                  inner = svg.append("g");

              var createGraph = function(nodes, edges) {
                var graph = new dagreD3.graphlib.Graph()
                  .setGraph({})
                  .setDefaultEdgeLabel(function() { return {}; });

                nodes.forEach(function(u) {
                  u.value.labelStyle = "font-family: Geppaequo; font-size: 11px;";
                  graph.setNode(u.id, u.value);
                });

                edges.forEach(function(e) {
                  e.value.lineInterpolate = 'basis';
                  e.value.arrowheadStyle = "fill: #000";
                  graph.setEdge(e.u, e.v, e.value);
                });

                return graph;
              };

              var g = createGraph(nodes, links);

              g.nodes().forEach(function(v) {
                var node = g.node(v);
                // Round the corners of the nodes
                node.id = v;
                node.rx = node.ry = 5;
              });

              // Run the renderer. This is what draws the final graph.
              render(inner, g);

              // Adjust SVG height to content
              var main = svgParent.find('g > g');
              var h = main.get(0).getBoundingClientRect().height;
              var newHeight = h + 40;
              newHeight = newHeight < 80 ? 80 : newHeight;
              svgParent.height(newHeight);

              // Zoom
              d3.select(svgParent.get(0)).call(d3.behavior.zoom().on('zoom', function() {
                  var ev = d3.event;
                  svg.select('g')
                      .attr('transform', 'translate(' + ev.translate + ') scale(' + ev.scale + ')');
              }));

          }
      };
  })();

  (function () {
      'use strict';

      // callback for graph data loading
      window.loadData = function (data, id) {
            DAG.displayGraph(data, $('#dag-name'), $('#dag'+id+' > svg'));
      };
  }());

  function gavpce(str) {
      var _this_ = {};

      function isok(x) {
          if (typeof x === "undefined" || x === null || x.length === 0) {
              return false;
          }
          return true;
      }

/*
g    Group id of the artifact (Required)
a    Artifact id of the artifact (Required)
t    Type of the artifact (Required)
v    Version of the artifact (Required) Supports resolving of "LATEST", "RELEASE" and snapshot versions ("1.0-SNAPSHOT") too
p    Packaging type of the artifact (Optional)
c    Classifier of the artifact (Optional)
e    Extension of the artifact (Optional)

[r    Repository that the artifact is contained in (Required)] <-- not needed

str = "g:a:t:v:p:c:e";

*/
      // verify that parameter is fine. if not, return object containing 'ok' function returning false.
      if (!isok(str)) {
          _this_.ok = function() {return false;}
          return _this_;
      }

      var arr = str.split(":");

      _this_.g = arr[0];
      _this_.a = arr[1];
      _this_.t = arr[2];
      _this_.v = arr[3];
      _this_.p = arr[4];
      _this_.c = arr[5];
      _this_.e = arr[6];

      // if no package , package is type
      if (typeof _this_.p === 'undefined' || _this_.p === null || _this_.p.length === 0) {
          _this_.p = _this_.t;
      }

      _this_.ok = function() {
         var mandatories = [_this_.g, _this_.a, _this_.t, _this_.v];
         for (j=0;j<mandatories.length;j++) {
             if (!isok(mandatories[j])) {
                 return false;
             }
         }
         return true;
      }

      return _this_;
  }


</script>