/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aequologica.neo.dagr.jgrapht.DagJGraphT;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.DagDocumentSerializer;
import net.aequologica.neo.geppaequo.document.DocumentHelper;

public class Dags {
    private static DagDocumentSerializer serializer = new DagDocumentSerializer();
    private Map<String, Dag> dags = null;
    private Map<String, DagJGraphT> dag2s = null;
    private Multimap<String, String> user2dags = null;
    private Multimap<String, String> dag2users = null;
    private static Dags instance = null;

    public static Dags getInstance() {
        if (instance == null) {
            instance = new Dags();
        }
        return instance;
    }

    private Dags() {
    }

    public Collection<Dag> getDAGs() {
        return this.dags.values();
    }

    public Set<String> getDAGKeys() {
        return this.dags.keySet();
    }

    public Dag getDAG(String dagkey) {
        return (Dag)this.dags.get(dagkey);
    }

    public DagJGraphT getDAG2(String dagkey) {
        return (DagJGraphT)this.dag2s.get(dagkey);
    }

    public List<Dag> getUserDAGs(String username) {
        Collection thisUserDags = this.user2dags.get((Object)username);
        ArrayList<Dag> ret = new ArrayList<Dag>(thisUserDags.size());
        for (String dagkey : thisUserDags) {
            Dag dag = (Dag)this.dags.get(dagkey);
            if (dag == null) continue;
            ret.add(dag);
        }
        return ret;
    }

    public List<Map.Entry<String, String>> load() {
        List sources;
        ArrayList exceptions = Lists.newArrayList();
        Multimap dag2Users0 = null;
        if (this.dag2users != null) {
            dag2Users0 = this.dag2users;
        }
        this.dags = new HashMap();
        this.dag2s = new HashMap();
        this.user2dags = ArrayListMultimap.create();
        this.dag2users = ArrayListMultimap.create();
        Path path = Paths.get("/dags", new String[0]);
        try {
            sources = DocumentHelper.list((Path)path);
        }
        catch (Exception e) {
            exceptions.add(new AbstractMap.SimpleImmutableEntry<String, String>(path.toString(), e.getMessage()));
            return exceptions;
        }
        for (Path source : sources) {
            try {
                Dag dag;
                if (!source.getFileName().toString().toLowerCase().endsWith(".json") || (dag = serializer.read(source)) == null) continue;
                dag.setSource(source.toString());
                String dagkey = source.getFileName().toString();
                dag.setKey(dagkey);
                this.dags.put(dagkey, dag);
                this.dag2s.put(dagkey, new DagJGraphT(dag));
                if (dag2Users0 == null) continue;
                Collection users = dag2Users0.get((Object)dagkey);
                for (String user : users) {
                    this.user2dags.put((Object)user, (Object)dagkey);
                    this.dag2users.put((Object)dagkey, (Object)user);
                }
            }
            catch (Exception e) {
                exceptions.add(new AbstractMap.SimpleImmutableEntry<String, String>(source.toString(), e.getMessage()));
            }
        }
        return exceptions;
    }

    public boolean subscribe(String dagkey, String username) throws IOException {
        Dag dag = (Dag)this.dags.get(dagkey);
        if (dag == null) {
            throw new IOException("[" + dagkey + "] not found");
        }
        Collection existingDags = this.user2dags.get((Object)username);
        Collection existingUsers = this.dag2users.get((Object)dagkey);
        if (existingDags.contains(dagkey) && existingUsers.contains(username)) {
            return false;
        }
        this.user2dags.put((Object)username, (Object)dagkey);
        this.dag2users.put((Object)dagkey, (Object)username);
        return true;
    }

    public boolean unsubscribe(String dagkey, String username) throws IOException {
        Dag dag = (Dag)this.dags.get(dagkey);
        if (dag == null) {
            throw new IOException("[" + dagkey + "] not found");
        }
        Collection existingDags = this.user2dags.get((Object)username);
        Collection existingUsers = this.dag2users.get((Object)dagkey);
        if (!existingDags.contains(dagkey) && !existingUsers.contains(username)) {
            return false;
        }
        this.user2dags.remove((Object)username, (Object)dagkey);
        this.dag2users.remove((Object)dagkey, (Object)username);
        return true;
    }

    public Boolean isUserSubscribed(String dagkey, String username) {
        Collection existingUsers = this.dag2users.get((Object)dagkey);
        return existingUsers.contains(username);
    }

    public static void dumpDag(Path path, Dag dag) throws IOException {
        serializer.write(path, dag);
    }
}

