/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.Dags;
import net.aequologica.neo.dagr.model.Dag;
import org.glassfish.jersey.server.mvc.Viewable;

@Path(value="/")
public class Resource<T> {
    @Context
    ServletContext context;
    Dags dags = Dags.getInstance();
    public static String ANONYMOUS = "anonymous";

    public Resource() throws IOException {
        this.dags.load();
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public List<DagInfo> getAllDAGs(@Context HttpServletRequest request) {
        String username = Resource.getUsername(request);
        Collection<Dag> dagsCollection = this.dags.getDAGs();
        List<DagInfo> ret = this.buildDagInfoList(dagsCollection, username);
        return ret;
    }

    @GET
    @Path(value="")
    @Produces(value={"text/html"})
    public Viewable getAllDAGsAsHtml(@Context HttpServletRequest request) throws IOException {
        return new Viewable("/WEB-INF/dagr/dags", this.getAllDAGs(request));
    }

    @POST
    @Path(value="")
    @Produces(value={"application/json"})
    public Response reload() {
        return Response.status((Response.Status)Response.Status.OK).entity(this.dags.load()).build();
    }

    @GET
    @Path(value="{dag : .+}")
    @Produces(value={"text/html"})
    public Viewable getDAGasHTML(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws Exception {
        List<DagInfo> allDAGs = this.getAllDAGs(request);
        for (DagInfo di : allDAGs) {
            this.unsubscribe(di.key, request);
        }
        this.subscribe(dagkey, request);
        return new Viewable("/WEB-INF/dagr/dags", this.getAllDAGs(request));
    }

    @GET
    @Path(value="{dag : .+}")
    @Produces(value={"application/json"})
    public Dag getDAG(@PathParam(value="dag") String dagkey) throws Exception {
        return this.dags.getDAG(dagkey);
    }

    @GET
    @Path(value="{dag : .+}/topological")
    @Produces(value={"application/json"})
    public List<String> getTopological(@PathParam(value="dag") String dagkey) throws Exception {
        return this.dags.getDAG2(dagkey).getTopologicalOrder();
    }

    @GET
    @Path(value="{dag : .+}/topologicartifacts")
    @Produces(value={"application/json"})
    public List<String> getTopologicartifacts(@PathParam(value="dag") String dagkey) throws Exception {
        return this.dags.getDAG2(dagkey).getTopologicartifactsOrder();
    }

    @GET
    @Path(value="subscription")
    @Produces(value={"application/json"})
    public List<DagInfo> getUserDAGs(@Context HttpServletRequest request) throws Exception {
        String username = Resource.getUsername(request);
        if (username == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<Dag> dagsCollection = this.dags.getUserDAGs(username);
        List<DagInfo> ret = this.buildDagInfoList(dagsCollection, "");
        return ret;
    }

    private List<DagInfo> buildDagInfoList(Collection<Dag> dagsCollection, String username) {
        ArrayList<DagInfo> ret = new ArrayList<DagInfo>(dagsCollection.size());
        for (Dag dag : dagsCollection) {
            DagInfo dagInfo = new DagInfo();
            dagInfo.name = dag.getName();
            dagInfo.key = dag.getKey();
            dagInfo.url = dag.getSource();
            dagInfo.subscribed = username == null ? null : Boolean.valueOf(username.length() == 0 ? true : this.dags.isUserSubscribed(dag.getKey(), username));
            ret.add(dagInfo);
        }
        return ret;
    }

    @POST
    @Path(value="subscription/{dag : .+}")
    public Response subscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = Resource.getUsername(request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.subscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    @DELETE
    @Path(value="subscription/{dag : .+}")
    public Response unsubscribe(@PathParam(value="dag") String dagkey, @Context HttpServletRequest request) throws IOException {
        String username = Resource.getUsername(request);
        if (username == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.dags.unsubscribe(dagkey, username)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    private static String getUsername(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            return ANONYMOUS;
        }
        String username = userPrincipal.getName();
        if (username == null || username.isEmpty()) {
            return ANONYMOUS;
        }
        return username;
    }

    public static class DagInfo {
        private String name;
        private String key;
        private String url;
        private Boolean subscribed;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Boolean getSubscribed() {
            return this.subscribed;
        }

        public void setSubscribed(Boolean subscribed) {
            this.subscribed = subscribed;
        }
    }
}

