package net.aequologica.neo.dagr.jgrapht;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.Dag.Link;
import net.aequologica.neo.dagr.model.Dag.Node;
import net.aequologica.neo.dagr.model.Dag.NodeValue;

public class DagJGraphT {

    private final Map<String, Dag.Node> nodes;
    private final DirectedGraph<String, DefaultEdge> g;

    public DagJGraphT(Dag dag) {
        super();
        this.g = new DirectedAcyclicGraph<>(DefaultEdge.class);
        this.nodes= new HashMap<String, Dag.Node>(dag.getNodes().size());
        for (Node node : dag.getNodes()) {
            nodes.put(node.getId(), node);
            this.g.addVertex(node.getId());
        }
        for (Link link : dag.getLinks()) {
            this.g.addEdge(link.getU(), link.getV());
        }
    }

    private Iterator<String> getTopologicalOrderIterator() {
        return new TopologicalOrderIterator<String, DefaultEdge>(this.g);
    }

    public List<String> getTopologicalOrder() {
        return Lists.newArrayList(getTopologicalOrderIterator());
    }

    private Function<String, String> key2artifactIdIfAny = new Function<String, String>() {
        public String apply(String key) {
            Dag.Node node = nodes.get(key);
            if (node == null) {
                return key;
            }
            NodeValue value = node.getValue();
            if (value == null) { 
                return key;
            }
            String gav = value.getGav();
            if (gav == null || gav.length()==0) {
                return key;
            }
            Iterable<String> split = Splitter.on(':').split(gav);
            Iterator<String> iterator = split.iterator();
            if (!iterator.hasNext()) {
                return key;
            }                
            @SuppressWarnings("unused")
            String groupId = iterator.next();
            if (!iterator.hasNext()) {
                return key;
            }
            String artifactId = iterator.next();
            if (artifactId == null || artifactId.length()==0) {
                return key; 
            }
            return artifactId;
        }
    };
    
    private Iterator<String> getTopologicartifactsOrderIterator() {
        TopologicalOrderIterator<String, DefaultEdge> topologicalOrderIterator = new TopologicalOrderIterator<String, DefaultEdge>(this.g);
        return Iterators.transform(topologicalOrderIterator, key2artifactIdIfAny);
    }

    public List<String> getTopologicartifactsOrder() {
        return Lists.newArrayList(getTopologicartifactsOrderIterator());
    }

}
