<%@page contentType="text/html" pageEncoding="UTF-8"
%><%@taglib prefix="c"   uri="http://java.sun.com/jstl/core_rt"
%><%@taglib prefix="fn"  uri="http://java.sun.com/jsp/jstl/functions"
%><%@taglib prefix="t"   tagdir="/WEB-INF/tags"
%><%@ page import="net.aequologica.neo.geppaequo.servlet.ZeroUtils" 
%><% ZeroUtils.HostContextUserAccountAndApp(request);
%><!DOCTYPE html><xmp theme="united" style="display:none; padding-top: 120px;">
<%@include file="ZERO.md" %>
</xmp>
<t:layout module="geppaequo" jsmodules="angular handlebars zeroclipboard">

<style>
body div.container#content p:first-child {
   margin-top:40px;
}
footer {
   display: none;
}
.ajaxLoading {
  margin-left: .5em;
}

html {
  font-size: 12px;
}
.gav {
  font-size: 0;
}
.gav:after {
  content: "\2060";
}
.gav span {
  font-size: 1rem;
}
</style>

</t:layout>

<script src='<c:url value="/assets/scripts/strapdown.js"/>' ></script>

<script src='<c:url value="/scripts/zero.js"/>'></script>

<script type="text/javascript">

$(document).ready(function() {

  var ajaxLoading = "<c:url value='/assets/images/animated_orange_refresh_22.gif'/>",

      ajaxLoaded  = "<c:url value='/assets/images/animated_orange_refresh_22.png'/>";

  zeroModule.init("${pageContext.request.serverName}",
                  "http://nexus.wdf.sap.corp:8081/nexus",
                  "<c:url value='/redirect.jsp'/>");

  $('.artifact-server').html(zeroModule.artifactServer.title).wrap($('<a>').attr({ href : zeroModule.artifactServer.URL }));

  zeroModule.getIt(
    {
      group     : $('#neo-group').text(),
      artifact  : $('#neo-artifact').text(),
      packaging : $('#neo-packaging').text()
    },
    "deploy.milestones",
    function () {
        $('.ajaxLoading#neo').attr({src:ajaxLoading}).css({display:"visible"});
    },
    function(it) {
        $('#neo-version').html(it.version);

        if (it.buildContentURL) {
            $('#neo-download').wrap($('<a>').attr({ href : it.buildContentURL }));
        }

        $('.gav#neo').wrap($('<a>').attr({ href   : it.browseURL,
                                           target : it.browseTarget }));

    },
    function() {
        $('.ajaxLoading#neo').attr({src:ajaxLoaded}).css({display:"none"});
    }
  );

  zeroModule.getIt(
    {
      group     : $('#runciter-group').text(),
      artifact  : $('#runciter-artifact').text(),
      packaging : $('#runciter-packaging').text()
    },
<c:if test="${fn:startsWith(app, 'prod')}">
    "releases",
</c:if>
<c:if test="${not fn:startsWith(app, 'prod')}">
    "snapshots",
</c:if>
    function () {
        $('.ajaxLoading#runciter').attr({src:ajaxLoading}).css({display:"visible"});
    },
    function(it) {
        $('#runciter-version').html(it.version);

        if (it.buildContentURL) {
            $('#runciter-download').wrap($('<a>').attr({ href : it.buildContentURL }));
        }

        $('.gav#runciter').wrap($('<a>').attr({ href   : it.browseURL,
                                                target : it.browseTarget }));

    },
    function() {
        $('.ajaxLoading#runciter').attr({src:ajaxLoaded}).css({display:"none"});
    }
  );

});

</script>

