<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="t" tagdir="/WEB-INF/tags"
%><t:layout module="geppaequo" jsmodules="datatables typeahead" >

  <style type="text/css">
    /* cf. http://www.quirksmode.org/dom/inputfile.html */
    div.fileinputs {
      position: relative;
      cursor: pointer;
    }

    div.fakefile {
      position: absolute;
      top: 0px;
      left: 0px;
      z-index: 1;
    }

    div.fakefile input {
      -moz-opacity:0.5 ;
      filter:alpha(opacity: 0.5);
      opacity: 0.5;
    }

    input.file {
      position: relative;
      text-align: right;
      -moz-opacity:0 ;
      filter:alpha(opacity: 0);
      opacity: 0;
      z-index: 2;
    }

    .dataTables_length label {
        opacity:0;
    }
  </style>

  <div class="row">
    <div class="col-lg-12">

    <%-- useful regular expressions
      remove 'if wizard' filter
        <c\:if([^>]*)>([\S\s]*?)<\/c\:if>
        <!-- c\:if$1 -->$2<!-- \/c\:if -->
      restore 'if wizard' filter
        <!-- c\:if([^>]*) -->([\S\s]*?)<!-- \/c\:if -->
        <c\:if$1>$2<\/c\:if>
    --%>

    <c:if test="${pageContext.request.isUserInRole('wizard') || pageContext.request.isUserInRole('LOCAL')}">
      <form id="uploadForm" action="" class="form-horizontal" enctype="multipart/form-data" method="POST" style="background-color:#fafafa; padding: 10px 10px 0 10px; border: 1px solid #f0f0f0; margin: 0 0 10px 0;">
        <div class="form-group">
          <label class="col-lg-2 control-label" for="path">path to upload to</label>
          <div class="col-lg-6">
            <span class="input-group">
              <span class="input-group-addon">/</span>
              <input id="path" name="path" value="${model}" class="typeahead form-control" type="text" placeholder="path">
            </span>
            <span id="alertWrapper"></span>
          </div>
        </div>
        <div class="form-group">
          <label class="col-lg-2 control-label" for="encoding">
          </label>
          <div class="col-lg-6">
            <label class="checkbox"> <input id="encoding" name="encoding" type="checkbox" value="true" checked> UTF-8</label>
            <label class="checkbox"> <input id="unzip"    name="unzip"    type="checkbox" value="false" > unzip (if applicable)</label>
            <span id="alertWrapper3"></span>
          </div>
        </div>
        <div class="form-group">
          <label class="col-lg-2 control-label" for="file">file to upload</label>
          <div class="col-lg-6">
            <div class="fileinputs">
              <input id="file" class="file form-control" name="file" type="file" >
              <div class="fakefile">
                <span class="input-group">
                  <input value="no file selected" class="form-control" >
                  <span class="input-group-addon"><i class="fa fa-search" style="vertical-align:middle; margin:0 0 0 5px; cursor: pointer;"></i></span>
                </span>
              </div>
            </div>
            <span id="alertWrapper2"></span>
          </div>
        </div>
        <div class="form-group">
          <div class="col-lg-offset-2 col-lg-6" style="display: table; text-align: center; vertical-align: middle;">
            <button id="upload" class="btn btn-primary" name="upload" type="submit" value="upload" style="display: table-cell;  text-align: center; vertical-align: middle">
              upload <i class="fa fa-cloud-upload"></i>
            </button>
            <div style="display: table-cell;  text-align: center; vertical-align: middle" >&nbsp;</div>

            <div  style="display: table-cell; width:100%;  text-align: center; vertical-align: middle">
              <div id="uploadProgress" class="progress" style="margin-bottom:0;">
                <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                  <span class="sr-only">0% Complete (success)</span>
                </div>
              </div>
            </div>

          </div>
        </div>
      </form>

    </c:if>

    <table cellpadding="0" cellspacing="0" border="0" id="allDocs">
      <thead>
        <span id="theZipButton" style="white-space: nowrap; overflow: hidden; font-size:larger; cursor: pointer;" title="download everything in a zip">
          <a href="<c:url value='/stnemucod/zip/${model}' />" target="help"><i class="fa fa-file-archive-o"></i></i></a>
        </span>
        <tr>


          <th style="width:16px;"><i class="fa fa-cloud-download" title="right-click -> save link as ... to download"></i></th>
          <th>d&nbsp;o&nbsp;c&nbsp;u&nbsp;m&nbsp;e&nbsp;n&nbsp;t&nbsp;s</th>
        </tr>
      </thead>
      <tbody>
      </tbody>
    </table>
    <c:if test="${pageContext.request.isUserInRole('wizard') || pageContext.request.isUserInRole('LOCAL')}">
      <div class="row">
        <div class="col-lg-12">
          <button type="button" id='delete' class="col-lg-2 btn disabled">Delete Selected</button>
        </div>
      </div>
    </c:if>
    </div> <!-- /.col-lg-12 -->
  </div> <!-- /.row -->

</t:layout>

<script type="text/javascript">

  $(document).ready(function(){

    $("#file").change(function() {
      if ($(this).val()) {
        $('.fakefile input').attr('value', $(this).val());
      } else {
        $('.fakefile input').attr('value', 'no file selected');
      }
    }).change();

    function getModulePaths() {
      return [
        <c:forEach var="module" items="${applicationScope.geppaequo_modules}">
          { value: 'modules/${module}', tokens: ['${module}', 'modules/${module}']},
        </c:forEach>
        ];
    }

      $("#path.typeahead").typeahead({
        name: 'path',
        local: getModulePaths()
      });
      $( ".twitter-typeahead" ).css({ display: "inline"});

      var allDocsDatatable = $('#allDocs').dataTable(
      {
        bProcessing    : true,

        iDisplayLength : -1,
        sAjaxSource    : "<c:url value='/stnemucod/json/${model}?sort=true' />",
        aaSorting      : [[ 1, "asc" ]],
        aoColumnDefs   : [
                          { "bSortable": false, "aTargets": [ 0 ] }
                         ],
        fnServerData   : function ( sSource, aoData, fnCallback, oSettings ) {

          var dat = new Array();

          $.ajax(
            {
              xhrFields   : { withCredentials: true },
                type        : "GET",
                dataType    : "json",
                cache       : false,
                crossDomain : true,
                url         : sSource,
              }).done(function(data, textStatus, jqXHR) {

                jQuery.each(data, function() {
                    var propOut = new Array();

                    var t = this.replace(/\\/g, '/')
                                .replace('C:/Users/i051108/AppData/Local/Temp/.geppaequo/stnemucod', '')
                                .replace('./work/tmp/.geppaequo/stnemucod', '');

                    propOut.push('<a href="' + '<c:url value="/stnemucod/document"/>' + t + '" target="_blank"><i class="fa fa-cloud-download"></i></a>');
                    propOut.push(t);

                    dat.push(propOut);

                    return true;
                });

                fnCallback({"aaData":dat});

                $("#allDocs tbody tr td a").click(function(event) {
                  event.preventDefault();
                  window.open($(this).attr('href'), $(this).attr('target'));
                  return false;
                });

                /* Add a click handler to the rows */
                $("#allDocs tbody tr").click(function(event) {
                  if ( $(this).hasClass('row_selected') ) {
                    $(this).removeClass('row_selected');
                    $('#delete').addClass('disabled');
                  } else {
                    $('#allDocs tbody tr.row_selected').removeClass('row_selected');
                    $(this).addClass('row_selected');
                    $('#delete').removeClass('disabled');
                  }
                });

              }).fail(function(jqXHR, textStatus, errorThrown) {
                fnCallback({"aaData":[]});
              }).always(function(data_jqXHR, textStatus, jqXHR_errorThrown) {
                var percent = 0;
                $("#theZipButton").prependTo(".dataTables_length");
                $('#uploadProgress > .progress-bar').attr({"aria-valuenow":percent}).css({width:percent+'%'});
                $('#uploadProgress > .progress-bar > .sr-only').text(percent+"% Complete (success)");
            }
          );
        }
      }
    );

    /* Get the rows which are currently selected */
    function fnGetSelected( oTableLocal ) {
      var aReturn = new Array();
      var aTrs = oTableLocal.fnGetNodes();

      for ( var i=0 ; i<aTrs.length ; i++ ) {
        if ( $(aTrs[i]).hasClass('row_selected') ) {
          aReturn.push( aTrs[i] );
        }
      }
      return aReturn;
    }

    function onDelete() {
      var anSelected = fnGetSelected( allDocsDatatable );
      if (anSelected.length >0 ) {
        var path = $(anSelected[0]).children('td:last').text();
        if (!path || path == null || path === '' || !path.startsWith('/')) {
          $('#alertWrapper').html(
            '<div class="alert alert-warning"><button type="button" class="close" data-dismiss="alert">&times;</button>path is null, or path is empty, or path does not start with "/".</div>'
          );
        } else {
          $.ajax(
            {
                type        : "DELETE",
                url         : "<c:url value='/stnemucod/document' />" + path,
              }).done(function(data, textStatus, jqXHR) {
                // alert('deleted');
                allDocsDatatable.fnDeleteRow( anSelected[0] );
              }).fail(function(jqXHR, textStatus, errorThrown) {
                alert(errorThrown);
              }).always(function(data_jqXHR, textStatus, jqXHR_errorThrown) {
            }
          );
        }
      }
    }

    <c:if test="${pageContext.request.isUserInRole('wizard') || pageContext.request.isUserInRole('LOCAL')}">
      /* Add a click handler for the delete row */
      $('#delete').click(onDelete);

      $('html').keyup(function(e){
        if(e.keyCode == 46) {
          onDelete();
        }
      })
    </c:if>

    $('#upload:button').click(function(e){

        e.preventDefault();

        var submitIt = true;
        $('.alert').alert('close');
        var path = $('#path').val();
        var isUTF8 = $('#encoding').is(':checked');
        var doUnzip = $('#unzip').is(':checked');
        var file = $('#file').val();
        /*
        if (!path || path == null || path === '' || path.startsWith('/')) {
          $('#alertWrapper').html(
            '<div class="alert alert-warning"><button type="button" class="close" data-dismiss="alert">&times;</button>path is null, or path is empty, or path starts with "/".</div>'
          );
          submitIt = false;
        }
        */
        if (!file) {
          $('#alertWrapper2').html(
            '<div class="alert alert-warning"><button type="button" class="close" data-dismiss="alert">&times;</button>no file selected.</div>'
          );
          submitIt = false;
        }

        if (submitIt){
          var action = "<c:url value='/stnemucod/upload' />"+'/'+path;
          if (isUTF8) {
            action += '?isUTF8=true';
            if (doUnzip) {
              action += '&doUnzip=true';
            }
          } else {
            if (doUnzip) {
              action += '?doUnzip=true';
            }
          }

          $('#uploadProgress').show().addClass('progress-striped active');

          function progressHandlingFunction(e){
            if(e.lengthComputable){
                // $('#uploadProgress').attr({value:e.loaded,max:e.total});
                var percent = 100*(e.loaded/e.total);
                $('#uploadProgress > .progress-bar').attr({"aria-valuenow":percent}).css({width:percent+'%'});
                $('#uploadProgress > .progress-bar > .sr-only').text(percent+"% Complete (success)");

            }
          }

          var formData = new FormData($('#uploadForm')[0]);
          $.ajax({
              url: action,  //Server script to process data
              type: 'POST',
              xhr: function() {  // Custom XMLHttpRequest
                  var myXhr = $.ajaxSettings.xhr();
                  if(myXhr.upload){ // Check if upload property exists
                      myXhr.upload.addEventListener('progress',progressHandlingFunction, false); // For handling the progress of the upload
                  }
                  return myXhr;
              },
              // Form data
              data: formData,
              //Options to tell jQuery not to process data or worry about content-type.
              cache: false,
              contentType: false,
              processData: false
          }).done(function( data, textStatus, jqXHR ) {
          }).fail(function( jqXHR, textStatus, errorThrown ) {
          }).always(function( data_jqXHR, textStatus, jqXHR_errorThrown ) {

            $( allDocsDatatable ).DataTable().ajax.reload();

            $('#uploadProgress').removeClass('progress-striped active');;

          });

        }
        return false;
    });

    $('#allDocs').delegate('tbody > tr > td:last-child > a', 'click', function () {
      // 'this' refers to the current <td>, if you need information out of it
      var url = $(this).attr('href');
      $('#delete').addClass('disabled');
      window.log(url);
    });

  });
</script>
