/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jgrapht;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.aequologica.neo.dagr.model.Dag;
import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class DagJGraphT {
    private final Map<String, Dag.Node> nodes;
    private final DirectedGraph<String, DefaultEdge> g;
    private Function<String, String> key2artifactIdIfAny = new Function<String, String>(){

        public String apply(String key) {
            Dag.Node node = (Dag.Node)DagJGraphT.this.nodes.get(key);
            if (node == null) {
                return key;
            }
            Dag.NodeValue value = node.getValue();
            if (value == null) {
                return key;
            }
            String gav = value.getGav();
            if (gav == null || gav.length() == 0) {
                return key;
            }
            Iterable split = Splitter.on((char)':').split((CharSequence)gav);
            Iterator iterator = split.iterator();
            if (!iterator.hasNext()) {
                return key;
            }
            String groupId = (String)iterator.next();
            if (!iterator.hasNext()) {
                return key;
            }
            String artifactId = (String)iterator.next();
            if (artifactId == null || artifactId.length() == 0) {
                return key;
            }
            return artifactId;
        }
    };

    public DagJGraphT(Dag dag) {
        this.g = new DirectedAcyclicGraph(DefaultEdge.class);
        this.nodes = new HashMap<String, Dag.Node>(dag.getNodes().size());
        for (Dag.Node node : dag.getNodes()) {
            this.nodes.put(node.getId(), node);
            this.g.addVertex((Object)node.getId());
        }
        for (Dag.Link link : dag.getLinks()) {
            this.g.addEdge((Object)link.getU(), (Object)link.getV());
        }
    }

    private Iterator<String> getTopologicalOrderIterator() {
        return new TopologicalOrderIterator(this.g);
    }

    public List<String> getTopologicalOrder() {
        return Lists.newArrayList(this.getTopologicalOrderIterator());
    }

    private Iterator<String> getTopologicartifactsOrderIterator() {
        TopologicalOrderIterator topologicalOrderIterator = new TopologicalOrderIterator(this.g);
        return Iterators.transform((Iterator)topologicalOrderIterator, this.key2artifactIdIfAny);
    }

    public List<String> getTopologicartifactsOrder() {
        return Lists.newArrayList(this.getTopologicartifactsOrderIterator());
    }
}

