;(function() {

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('nodeProgress', [ function() {
  
    var controller = [
      '$scope',
      'GaranceRestangular',
      'theTimer',
      'theContext',
      '$websocket',
      function($scope, GaranceRestangular, $theTimer, $theContext, $websocket) {
        
        var Progress = (function(nodeId) {
          var startDate           = moment();
          var durationmaxexpected = moment.duration(20000);

          var start = function(expected, ellapsed) {
            if (ellapsed) {
              startDate = moment().subtract(moment.duration(Math.floor(ellapsed / 1000) * 1000));
            } else {
              startDate = moment();
            }
            if (expected) {
              durationmaxexpected = moment.duration(Math.ceil(expected / 1000) * 1000);
            } else {
              durationmaxexpected = moment.duration(20000);
            }
            // window.log('duration max expected:', durationmaxexpected);

            $scope.maxElement.html(durationmaxexpected.humanize())

            $scope.progressElement.attr('value', 0);

            $theTimer.add(nodeId, this);
          }

          // cf. http://drupalmotion.com/article/debounce-and-throttle-visual-explanation
          var update = _.throttle(function(text) {
            var percentage_complete = (moment() - startDate) / durationmaxexpected * 100;
            var percentage_rounded = Math.round((Math.round(percentage_complete * 100) / 100));
            if (isFinite(percentage_rounded)) {
              $scope.progressElement.attr('value', percentage_rounded);
            }
            var percent = '' + percentage_rounded + '%';
            if (text) {
              percent = percent + '&nbsp;' + text;
            }
            $scope.textElement.html(percent);
          }, 500);

          var reset = function() {
            startDate = moment();

            $theTimer.remove(nodeId);
          };

          reset();

          return {
            startProgress  : start  ,
            updateProgress : update ,
            resetProgress  : reset  ,
          }
        }); // END var Progress = (function(nodeId) 

        $scope.cleaner.progress = new Progress($scope.node.id);

        $scope.cleaner.cleaningOrderedOrBeingCleaned = function() {
          if ($scope.cleaner.state == 'CLEANING_ORDERED' || $scope.cleaner.state == 'BEING_CLEANED') {
            return true;
          }
          return false;
        }
        
        $scope.cleaner.onCleaningStopped = function() {
          $scope.cleaner.progress.resetProgress();
          $scope.cleaner.id = undefined;
        }

        $scope.cleaner.onCleaningStarted = function(cleanerId, duration) {

          function validateCleaner(cleanerId) {
            // cf. http://stackoverflow.com/questions/7905929/how-to-test-valid-uuid-guid
            var re = /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
            return re.test(cleanerId);
          }

          function websock() {
            if (!validateCleaner(cleanerId)) {
              // window.log("invalid cleaner id", cleanerId);
              return;
            }
            
            $scope.cleaner.id = cleanerId;
            
            var url = $theContext.jevaispasmefairechierWS + 'hub/' + cleanerId;

            // Open a WebSocket connection
            // window.log("opening cleaner websocket from", url, 'for node', $scope.node.id, cleanerId);
            var dataStream = $websocket(url);
            // window.log("cleaner websocket opened", dataStream);

            dataStream.onMessage(function(atmosphereMessage) {

              if (atmosphereMessage.type == "message" && atmosphereMessage.data == 'X') {
                return;
              }
              var message = atmosphereMessage.data;

              var datum = $theContext.tryParseJSON(message)
              if (datum) {
                $scope.cleaner.progress.updateProgress(datum.value);
                if (datum.key === "writeOnClose" && datum.value === "true") {
                  dataStream.close(true);
                }
              }
            });

            dataStream.onClose(function() {
              // window.log($scope.node.id, 'cleaner socket received onClose event from', cleanerId);
            });

            dataStream.onError(function() {
              // window.log($scope.node.id, 'cleaner socket received onError event from', cleanerId);
            });
            
          } // end of function websock() {

          {
            var parse = function(name) {
              var regExp    = /^(.*)\/subs\/(.*)$/;
              var dagAndSub = regExp.exec(name);
              if (dagAndSub && dagAndSub.length==3) {
                return {
                  dagName : dagAndSub[1],
                  subKey  : dagAndSub[2],
                }
              } else {
                return {
                  dagName : name,
                  subKey  : undefined,
                }
              }
            } 
            
            var garanceKey        = parse($scope.node.dagName).dagName + "::" + $scope.cleaner.scope + "::" + $scope.node.name;
            var garanceKeyBase64  = btoa(unescape(encodeURIComponent(garanceKey)));
            var garanceRes        = GaranceRestangular.one('series', garanceKeyBase64).one('estimate');

            // 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 
            garanceRes.get().then(function(garanceJson) {
              $scope.cleaner.progress.startProgress(garanceJson, 0);
              websock(); // always
            }, function(response) {
              $scope.cleaner.progress.startProgress(150000, $scope.cleaner.duration);
              window.log('garance ooooooooooops:', garanceKey, garanceKeyBase64, response);
              websock(); // always
            });
          }

        } // end of onCleaningStarted function
        
        // window.log("cleaner", $scope.cleaner, "for node", $scope.node, "with scope", $scope.scope, "INITED!");

        if ($scope.cleaner.id) {
          $scope.cleaner.onCleaningStarted($scope.cleaner.id, $scope.cleaner.duration);
        }

    }]; // controller definition

    return {
      restrict     : 'E',
      templateUrl  : Geppaequo.contextPath + 'modules/dagr/templates/node-progress.html',
      scope: {
        cleaner       : '=cleaner',
        node          : '=node'   ,
        scope         : '=scope'  ,
      },
      link: function link(scope, element, attrs) {
        scope.progressElement = element.find('div.outer > progress');
        scope.textElement     = element.find('div.outer > span.inner#left > span');
        scope.maxElement      = element.find('div.outer > span.inner#right > span');
      },
      controller   : controller,
      controllerAs : 'ctrl',
    };

  }]); // angular.module('dagsApplication').directive('nodeProgress', [ function() s{
  
})();
