;(function() {

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive(
      'dag',
      [
        function() {

          // 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
          var controller = [
              '$scope',
              'Restangular',
              'theContext',
              '$websocket',
              function($scope, Restangular, $theContext, $websocket) {

                $scope.dag = {};

                displayError = function(response, err, display) {
                  err = $scope.enhanceError(err, response);
                  display(err);
                }

                $scope.downloadDAG = function() {
                  // http://stackoverflow.com/a/38345771/1070215 hints to FileSaver.js (https://github.com/eligrey/FileSaver.js)
                  // http://stackoverflow.com/a/11065286/1070215 explains jquery $.ajax accepts: and dataType: attributes
                  var url = $scope.dagInfo.downloadURL; // store url here, as $scope.dagInfo may have change when we get a response error and we want to display it 
                  $.ajax({
                    accepts     : { text:'application/json' },
                    url         : url,
                    processData : false, 
                    dataType    : 'json'
                  }).done(function(data) {
                    var blob = new Blob([JSON.stringify(data, undefined, 2)], {type: "application/json;charset=utf-8"});
                    $scope.saveAs(blob, $scope.dagInfo.name + ".json");
                  })
                  .fail(function(jqXHR, textStatus, errorThrown) {
                    alert("error downloading:\n\"" + url + "\"\n\nHTTP says:\n" + jqXHR.status +"\n" + jqXHR.responseText); 
                  });
                }

                $scope.reloadDAG = function() {
                  dagReloadResource = Restangular.one('dags', $scope.dagInfo.name)
                                                 .one('reload');
                  dagReloadResourcePromise = dagReloadResource.post();
                  dagReloadResourcePromise.then(function() { // 204 no content

                    window.location.reload(); // while waiting for : $scope.dagInfo.reload();

                    $scope.loaded = false;
                    $scope.loadOnce();
                    $('#tip').html("<i>" + $scope.dagInfo.name + "</i> reloaded!").show();
                  }, function(response) {
                    $('#tip').text(response.status + " - " + response.data.error).show();
                  });
                }
                
                var setupNodeValueSCM = function(nodeValue) {
                  if (nodeValue) {
                    nodeValue.giturl = parseGitUrl({
                      scm : nodeValue.scm,
                      commit : nodeValue.commit,
                      shortMessage : nodeValue.shortMessage,
                    });
                    if (nodeValue.branch) {
                      if (nodeValue.branch.match(/^[0-9a-f]{40}$/) != null) {
                        nodeValue.shortbranch = nodeValue.giturl.hash;
                      } else {
                        nodeValue.shortbranch = nodeValue.branch.replace(/^refs\/heads\//gi, "");
                      }
                    }
                  }
                } 

                // 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 
                $scope.loaded = false;
                $scope.loading = false;
                $scope.loadOnce = function() {

                  if (!$scope.dagInfo) {
                    return;
                  }

                  if ($scope.loaded || $scope.loading) {
                    return;
                  }
                  $scope.loading = true;

                  $scope.hideCleaner = !$scope.dagInfo.cleaner.urlobj.host;

                  var dagRestResource;
                  var dagRestResourcePromise;

                  dagRestResource = Restangular.one('dags', $scope.dagInfo.name);
                  if ($scope.dagInfo.subDagId) {
                    dagRestResource = dagRestResource.one('subs', $scope.dagInfo.subDagId);
                  }
                  dagRestResourcePromise = dagRestResource.get({
                    'with' : $scope.dagInfo.with_
                  });

                  // 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  
                  dagRestResourcePromise.then(function(dag) {

                    var nodeArray = [];

                    dag.nodes.forEach(function(node) {
                      if (node.clazz !== "cluster") {
                        nodeArray.push(node);
                      }
                    });

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4
                    // get subdags
                    (function(leDagName) {
                      // cf. http://stackoverflow.com/questions/13304543/javascript-sort-array-based-on-another-array
                      $scope.subDags = [];
                      var subDagsRestResource = Restangular.one('dags', leDagName)
                                                           .one('subs');
                      subDagsRestResource.get().then(function(subDagMapEntryArray) {
                        var subs = [];
                        subDagMapEntryArray.forEach(function(mapEntry) {
                          subs.push({
                            id        : Object.keys(mapEntry)[0],
                            nodeNames : mapEntry[Object.keys(mapEntry)[0]].join(' '),
                            go        : function() {
                                window.location.replace($theContext.jevaispasmefairechierHTTP + "api/dagr/v1/views/dags/"+leDagName+"/subs/"+Object.keys(mapEntry)[0]);
                            }
                          });
                        });
                        $scope.subDags = subs;
                      });
                    }($scope.dagInfo.name));
                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    
                    setupNodeValueSCM(dag.value);

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    var setTopo = function(topo) {
                      // cf. http://stackoverflow.com/questions/13304543/javascript-sort-array-based-on-another-array
                      $scope.topological = (function(items, sorted) {
                        var result = [];
                        sorted.forEach(function(key) {
                          var found = false;
                          items = items.filter(function(item) {
                            if (!found && item.id == key) {
                              result.push(item);
                              found = true;
                              return false;
                            } else {
                              return true;
                            }
                          });
                        });
                        return result;
                      }(nodeArray, topo));
                    }

                    // load topological sort
                    if (!dag.topologicalNodeIds) {
                      var topologicalSortRestResource = Restangular.one('dags', $scope.dagInfo.name)
                                                                   .one('topological');
                      topologicalSortRestResource.get().then(function(topo) {
                        setTopo(topo);
                        $scope.loaded = true;
                        $scope.loading = false;
                      });
                    } else {
                      setTopo(dag.topologicalNodeIds);
                      $scope.loaded = true;
                      $scope.loading = false;
                    }
                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 

                    var nodeMap = {};
                    nodeArray.forEach(function(node) {
                      nodeMap[node.id] = node;
                      node.selected = false;
                      node.predecessors = [];
                      node.successors = [];
                      node.nodeClasses = ""; 
                      node.malaxClasses = function(removed, added) {
                        var existing = this.nodeClasses.split(" ");
                        existing = _.difference(existing, removed);
                        existing = _.unionBy(existing, added);
                        this.nodeClasses = existing.join(" ");
                        DAGRE_D3_HELPER.putTheStuffMan( this.id, removed, added );
                        return this.nodeClasses;
                      }
                      node.setSelected = function(selected) {
                        if (this.selected != selected) {
                          this.selected = selected;
                          if (selected) {
                            this.malaxClasses([], ["_selected_"]);
                          } else {
                            this.malaxClasses(["_selected_"], []);
                          }
                        }
                      };
                      node.setHover = function(bool) {
                        if (bool) {
                          this.malaxClasses([], ["HOVER"]);
                        } else {
                          this.malaxClasses(["HOVER"], []);
                        }
                      }
                      node.isVisible = function() {
                        if (!$scope.hasVisible()) {
                          return true;
                        }
                        return visibleNodes[this.id];
                      };
                    });
                    $scope.nodeWhosePredecessorsShallBeShown = null;
                    $scope.nodeWhoseSuccessorsShallBeShown = null;
                    $scope.nodeMap = nodeMap;
                    
                    ///////////////////////////////////////////////
                    var visibleNodes         = {}; // none means all

                    $scope.hasSelection = function() {
                      var selectedNodes = _.filter(
                          nodeArray, 
                          function(node) {
                            if (node.selected) {
                              return true;
                            } else {
                              return false;
                            }
                          }
                      );
                      return selectedNodes.length > 0;
                    }
                    
                    $scope.hasVisible = function() {
                      return !_.isEmpty(visibleNodes);
                    }
                    
                    calcVisibleAndSelected = function() {
                      var clazzes = {};
                      _.forEach(nodeArray, function(node) {
                        clazzes[node.id] = {
                          removed : ["_visible_", "_dimmed_", "_parent_", "_selected_", "_checked_up_", "_checked_down_"],
                          added   : []
                        };
                      });                        
                      var allVisibleNodes;
                      if (!$scope.hasVisible()) {
                        allVisibleNodes = nodeArray; 
                      } else {
                        allVisibleNodes = _.filter(
                            nodeArray, 
                            function(node) {
                              if (visibleNodes[node.id] !== undefined) {
                                clazzes[node.id].added.push("_visible_");
                                if (visibleNodes[node.id] === 'parent') {
                                  clazzes[node.id].added.push("_parent_");
                                }
                                return true;
                              } else {
                                clazzes[node.id].added.push("_dimmed_");
                                return false;
                              }
                            }
                          ); 
                      }
                      if ($scope.nodeWhosePredecessorsShallBeShown) {
                        clazzes[$scope.nodeWhosePredecessorsShallBeShown.id].added.push("_checked_up_")
                      }
                      if ($scope.nodeWhoseSuccessorsShallBeShown) {
                        clazzes[$scope.nodeWhoseSuccessorsShallBeShown.id].added.push("_checked_down_")
                      }
                      
                      var visibleSelectedNodes = _.filter(
                          allVisibleNodes, 
                          function(node) {
                            if (node.selected) {
                              clazzes[node.id].added.push("_selected_");
                              return true;
                            } else {
                              return false;
                            }
                          }
                      );
                      
                      _.forOwn(clazzes, function(clazz, nodeId) {
                        nodeMap[nodeId].malaxClasses(clazz.removed, clazz.added);
                      } );                      
                      
                      return visibleSelectedNodes;
                    };

                    calcVisibleAndSelected();
                    
                    $scope.toggleAllVisibleNodes = function() {
                      var noVisibleSelectedNode = calcVisibleAndSelected().length == 0;
                      nodeArray.forEach(function(node) {
                        if (node.isVisible()) {
                          node.setSelected(noVisibleSelectedNode);
                        }
                      });
                      calcVisibleAndSelected();
                    };

                    $scope.back2dag = function() {
                      window.location.replace($theContext.jevaispasmefairechierHTTP + "api/dagr/v1/views/dags/"+$scope.dagInfo.name);
                    };
                    
                    $scope.go2sub = function() {
                      // create subdag
                      var thisDag = Restangular.one('dags', $scope.dagInfo.name);
                      var selectedNodes = _.map(calcVisibleAndSelected(), 'name');
                      $scope.subdag = {};
                      thisDag.post('subs', selectedNodes, undefined, {
                        'Content-Type' : 'application/json'
                      }).then(function(subDagKey) {
                        // window.log(subDagKey);
                        window.location.replace($theContext.jevaispasmefairechierHTTP + "api/dagr/v1/views/dags/"+$scope.dagInfo.name+"/subs/"+subDagKey);
                      }, function(response) {
                        displayError(response, 'unable to create subDag for [' + selectedNodes + ']', function(enhancedErrorText) {
                          $scope.subdag.error = enhancedErrorText;
                          console.log(enhancedErrorText);
                        });
                      });                      
                    }

                    // cf .https://gist.github.com/kevinfjbecker/1524215
                    var breadthFirstGraphTraversal = function (nodes, visibles, start, functor) {
                      var Q = [];
                      var G = _.keyBy(nodes, 'id');
                      _.forOwn(G, function(o) { o.color ='white';});
                      G[start].color = 'grey';
                      Q.push(start);
                      // console.log(Q);
                      while (Q.length > 0) {
                        var u = Q.splice(0, 1)[0];
                        // console.log(Q);
                        G[u][functor].forEach(function(p) {
                          if (G[p.id].color === 'white') {
                            G[p.id].color = 'grey';
                            
                            // window.log(start, functor+':', '/' + p.name + '/', p.id, '(' + p.clazz + ')');
                            visibles[p.id] = p.clazz;
                            
                            Q.push(p.id);
                            // console.log(Q);
                          }
                        });
                      }
                    }
                    
                    var showPredecessors = function(node) {
                      visibleNodes = {}; // none means all
                      if (node) {
                        visibleNodes[node.id] = "checked";
                        breadthFirstGraphTraversal(nodeArray, visibleNodes, node.id, "predecessors");
                      }
                      calcVisibleAndSelected();
                    };

                    $scope.togglePredecessors = function(node) {
                      $scope.nodeWhoseSuccessorsShallBeShown = null;
                      if (node == $scope.nodeWhosePredecessorsShallBeShown) {
                        $scope.nodeWhosePredecessorsShallBeShown = null;
                      } else {
                        $scope.nodeWhosePredecessorsShallBeShown = node;
                      }
                      showPredecessors($scope.nodeWhosePredecessorsShallBeShown);
                    };

                    var showSuccessors = function(node) {
                      visibleNodes = {}; // none means all
                      if (node) {
                        visibleNodes[node.id] = "checked";
                        breadthFirstGraphTraversal(nodeArray, visibleNodes, node.id, "successors");
                      }
                      calcVisibleAndSelected();
                    };

                    $scope.toggleSuccessors = function(node) {
                      $scope.nodeWhosePredecessorsShallBeShown = null;
                      if (node == $scope.nodeWhoseSuccessorsShallBeShown) {
                        $scope.nodeWhoseSuccessorsShallBeShown = null;
                      } else {
                        $scope.nodeWhoseSuccessorsShallBeShown = node;
                      }
                      showSuccessors($scope.nodeWhoseSuccessorsShallBeShown);
                    };

                    ///////////////////////////////////////////////

                    var clusterCount = 0;

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    dag.nodes.forEach(function(node) {
 
                      node.dagName = dag.id.name;
                      
                      node.slug = {};
                      node.jobNames = {};
                      _.forOwn($scope.dagInfo.cleaner._nameTemplates_, function(_nameTemplate_, scope) {
                        node.jobNames[scope] = _nameTemplate_({
                          node : node,
                          dag : dag
                        });
                      });

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // cluster ?
                      {
                        if (node.clazz == "cluster") {
                          clusterCount = clusterCount + 1;
                          if (!node.value) {
                            node.value = {};
                          }
                          node.value.clusterLabelPos = 'top';
                        }
                      } // cluster ?
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5
                      // get GAV
                      {
                        node.gav = gatcvs(node.value && node.value.gucrid ? node.value.gucrid : null);
                      }

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup short (artifactId) and medium (artifactId+version) and full (groupId+artifactId+version)labels
                      {

                        if (typeof node.value == "undefined" || node.value == null) {
                          node.value = {};
                        }

                        node.value.labelShort = node.name

                        if (node.gav.ok()) {
                          node.value.labelFull = node.gav.g + ' ' + node.gav.a + ' ' + node.gav.v;
                          node.value.labelMedium = node.gav.a + ' ' + node.gav.v;

                        } else {
                          node.value.labelFull = node.value.label || node.value.labelShort;

                          var name = node.value.labelFull;
                          var version = "";

                          var labelFullSplit = node.value.labelFull.split(' ');
                          if (labelFullSplit.length > 1) {
                            name = labelFullSplit.shift();
                            version = labelFullSplit.join(' ');
                          }

                          var shortName = name;
                          var lastDot = name.lastIndexOf('.');
                          if (lastDot != -1) {
                            shortName = name.substr(lastDot + 1);
                          }
                          node.value.labelMedium = shortName + ' ' + version;
                        }
                      } // setup short and medium and full labels
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup scm
                      setupNodeValueSCM(node.value);

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup gatcvs
                      {
                        if (node.gav.ok()) {
                          if (!node.value.scm) {
                            var shortgav = node.gav.g.replace(/net\.(.*)\.neo/g, "$1");
                            node.reponame = shortgav + "/" + node.gav.a;
                          } else {
                            node.reponame = node.value.giturl.slug;
                          }
                          node.repoid = node.reponame.replace(/\//g, "_");
                          if ($scope.dagInfo.cleaner && 
                              $scope.dagInfo.cleaner.bumper && 
                              $scope.dagInfo.cleaner.bumper.getBumpForNode &&
                              _.isFunction($scope.dagInfo.cleaner.bumper.getBumpForNode)) {
                            node.gav.bump = $scope.dagInfo.cleaner.bumper.getBumpForNode(node.name);
                          } else {
                            node.gav.bump = "PATCH";
                          }
                        } else {
                          node.gav = {
                            a : node.value.labelFull
                          };
                        }
                      } // setup gatcvs
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup jenkins 
                      if ($scope.dagInfo.cleaner && $scope.dagInfo.cleaner.type == "jenkins") {

                        node.slug[$scope.dagInfo.scope] = 'job' + "/" + node.jobNames[$scope.dagInfo.scope];
                        var lastBuildUrl = $scope.dagInfo.cleaner.url + "/" + node.slug[[$scope.dagInfo.scope]] + "/lastBuild/api/json";
                        var ajaxSettings = {
                          url : lastBuildUrl,
                          headers : {
                            'Accept' : 'application/json'
                          }
                        };
                        if ($scope.dagInfo.cleaner.authorizationHeader) {
                          ajaxSettings.beforeSend = function(request) {
                            request.setRequestHeader("Authorization", $scope.dagInfo.cleaner.authorizationHeader);
                          }
                        }
                        $.ajax(ajaxSettings).fail(function(data) {
                          node.foundJob = false;
                          var cleaner = $scope.dagInfo.nodeCleaners[$scope.dagInfo.scope][node.id];
                          cleaner.cleanStatusImgUrl = $scope.clean_unknown_svg_url;
                        }).done(function(data) {
                          node.foundJob = true;
                          // the true jenkins doc : https://github.com/jenkinsci/jenkins/blob/master/core/src/main/java/hudson/model/Result.java
                          // 
                          // SUCCESS
                          // UNSTABLE
                          // FAILURE
                          // NOT_BUILT
                          // ABORTED
                          // 

                          var cleaner = $scope.dagInfo.nodeCleaners[$scope.dagInfo.scope][node.id];
                          if (cleaner) {
                              if (data.result == "SUCCESS" || data.result == "UNSTABLE") {
                                cleaner.cleanStatusImgUrl = $scope.clean_passing_svg_url;
                              } else if (data.result == "FAILURE") {
                                cleaner.cleanStatusImgUrl = $scope.clean_failing_svg_url;
                              } else if (data.result == "ABORTED") {
                                cleaner.cleanStatusImgUrl = $scope.clean_aborted_svg_url;
                              } else if (data.result == "UNCLEANABLE") { // will never, ever, get this from state from jenkins
                                cleaner.cleanStatusImgUrl = $scope.clean_uncleanable_svg_url;
                              } else {
                                cleaner.cleanStatusImgUrl = $scope.clean_unknown_svg_url;
                              }
                          }
                        });
                      }
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup travis 
                      if ($scope.dagInfo.cleaner && $scope.dagInfo.cleaner.type == "travis") {

                        var cleaner = $scope.dagInfo.nodeCleaners[$scope.dagInfo.scope][node.id];
                        if (node.value && node.value.giturl && node.value.giturl.slug) {
                          node.slug[$scope.dagInfo.scope] = node.value.giturl.slug;
                        } else {
                          node.slug[$scope.dagInfo.scope] = dag.id.name + "/" + node.jobNames[$scope.dagInfo.scope];
                        }
                        if (cleaner && $scope.dagInfo.cleaner.url && node.value && node.value.shortbranch) {
                          cleaner.cleanStatusImgUrl = $scope.dagInfo.cleaner.url + "/" + node.slug[[$scope.dagInfo.scope]] + ".svg?branch=" + node.value.shortbranch + "#" + (new Date().getTime().toString());
                        }
                        var travisURL;
                        if ($scope.dagInfo.cleaner.urlWorkAroundCORS) {
                          travisURL = $theContext.jevaispasmefairechierHTTP + $scope.dagInfo.cleaner.urlWorkAroundCORS + "/repos/" + node.slug[[$scope.dagInfo.scope]] + "/branches";
                        }

                        if (travisURL) {
                          var ajaxSettings = {
                            url : travisURL,
                            crossDomain : true,
                            headers : {
                              'Accept' : 'application/vnd.travis-ci.2+json'
                            }
                          };
                          if ($scope.dagInfo.cleaner.authorizationHeader) {
                            ajaxSettings.beforeSend = function(request) {
                              request.setRequestHeader("Authorization", $scope.dagInfo.cleaner.authorizationHeader);
                            }
                          }
                          $.ajax(ajaxSettings).fail(function(data) {
                            node.travis = false;
                          }).done(function(data) {
                            node.travis = true;
                            //
                            var foundJob = null;
                            {
                              // search in commits array for the branch
                              var foundCommit = null;
                              {
                                for (var ccc = 0; ccc < data.commits.length; ccc++) {
                                  if (data.commits[ccc].branch == node.value.shortbranch) {
                                    foundCommit = data.commits[ccc].id;
                                    break;
                                  }
                                }
                              }
                              if (foundCommit != null) {
                                // search in branch array for the job
                                for (var bbb = 0; bbb < data.branches.length; bbb++) {
                                  if (data.branches[bbb].commit_id == foundCommit) {
                                    if (data.branches[bbb].job_ids.length) {
                                      foundJob = data.branches[bbb].job_ids[0];
                                      if (cleaner && !cleaner.cleanStatusImgUrl) {
                                        var jobState = data.branches[bbb].state;
                                        if (jobState == "passed" || jobState == "created" || jobState == "started") {
                                          cleaner.cleanStatusImgUrl = $scope.clean_passing_svg_url;
                                        } else if (jobState == "failed") {
                                          cleaner.cleanStatusImgUrl = $scope.clean_failing_svg_url;
                                        } else if (jobState == "canceled") {
                                          cleaner.cleanStatusImgUrl = $scope.clean_aborted_svg_url;
                                        } else {
                                          cleaner.cleanStatusImgUrl = $scope.clean_unknown_svg_url;
                                        }
                                      }
                                      break;
                                    }
                                  }
                                }
                              }
                            }
                            if (foundJob != null) {
                              node.foundJob = foundJob;
                            }
                          });
                        }
                      } // setup travis
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5
                      if ($scope.refreshSnapshot) $scope.refreshSnapshot(node);
                      if ($scope.refreshRelease ) $scope.refreshRelease(node);
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                    }); // dag.nodes.forEach

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    if (clusterCount > 1) {
                      // cf. http://tools.medialab.sciences-po.fr/iwanthue/
                      var colors = [
                          "#3CF7BD", "#D118AB", "#6E3904", "#A6BCE6", "#C2E12C", "#0A5BC6", "#E493AB", "#D6F3B7", "#316B7B", "#289870", "#53327D", "#9C1D1D"
                      ];
                      var color = 0;
                      dag.nodes.forEach(function(node) {
                        if (node.clazz == "cluster") {
                          node.value.style = "fill: " + colors[(color++) % colors.length];
                        }
                      });
                    } // if (clusterCount > 1 ) {

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    dag.links.forEach(function(edge) {
                      if (typeof edge.value === "undefined" || edge.value == null) {
                        edge.value = {};
                      }
                      if (edge.clazz) {
                        edge.value["class"] = edge.clazz;
                        edge.value.arrowheadClass = edge.clazz;
                      }
                      edge.value.lineInterpolate = 'basis';
                      edge.value.arrowhead = 'vee'; // 'normal'; //  

                      var clazz = (edge.clazz == "default" ? 'direct' : edge.clazz);
                      $scope.nodeMap[edge.u].successors.push({
                        id : $scope.nodeMap[edge.v].id,
                        name : $scope.nodeMap[edge.v].name,
                        clazz : clazz
                      });
                      $scope.nodeMap[edge.v].predecessors.push({
                        id : $scope.nodeMap[edge.u].id,
                        name : $scope.nodeMap[edge.u].name,
                        clazz : clazz
                      });

                    }); // dag.links.forEach(function(edge) {

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    $scope.askCleanerToclean = function(node) {
                      // window.log("no cleaner");
                      return;
                    };
                    if ($scope.dagInfo.cleaner && ($scope.dagInfo.cleaner.type == "jenkins" || $scope.dagInfo.cleaner.type == "travis")) {
                      $scope.askCleanerToclean = function(node) {
                        var buildNode = Restangular .one('dags',  $scope.dagInfo.name)
                                                    .one('buses', $scope.dagInfo.scope)
                                                    .one('nodes', node.name);
                        buildNode.patch({}).then(function(json) {
                          // window.log('request for cleaning of node ' + node.name + ' was accepted.');
                        }, function(response) {
                          displayError(response, 'unable to request cleaning of node ' + node.name, function(enhancedErrorText) {
                            $scope.rebuild.setError(enhancedErrorText);
                            console.log(enhancedErrorText);
                          });
                        });
                      }
                    }
                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 

                    $scope.dag = dag;

                    $scope.putCLEAN_OKeventToNode = function(node) {
                      var sendCLEAN_OK = Restangular.one('dags',   $scope.dagInfo.name )
                                           .one('buses',  $scope.dagInfo.scope)
                                           .one('nodes',  node.name)
                                           .one('events', 'CLEAN_OK');

                      sendCLEAN_OK.patch({}, undefined, {
                        'Content-Type' : 'text/plain'
                      }).then(function(json) {
                      }, function(response) {
                        if (response.status == 304) {
                          window.log('node /' + node.name + '/ not modified');
                        } else {
                          window.log('error sending event to node /' + node.name + '/ : ' + response.data.error);
                        }
                      });
                    };

                    var setNodeStateToCLEAN = function(node) {
                      var setNodeStateRes = Restangular.one('dags',   $scope.dagInfo.name)
                                                       .one('buses',  $scope.dagInfo.scope)
                                                       .one('nodes',  node.name)
                                                       .one('states', 'CLEAN');

                      setNodeStateRes.patch({}, undefined, {
                        'Content-Type' : 'text/plain'
                      }).then(function(json) {
                        // window.log('sent patch request to force node ' + node.name + ' state to CLEAN');
                      }, function(response) {
                        if (response.status == 304) {
                          // window.log('node ' + node.name + ' was already in CLEAN state - not modified');
                        } else {
                          // window.log('faild to force node ' + node.name + ' to CLEAN state - not modified' + response.data.error);
                        }
                      });
                    };

                    $scope.cleanAllNodes = function() {
                      $scope.topological.forEach(function(node) {
                        setNodeStateToCLEAN(node);
                      })
                    }
                    
                    DAGRE_D3_HELPER.renderGraph($scope.dag, $( "#theDagSVG" ), $scope.node_name_variant_index);
                    nodeArray.forEach(function(node) {
                      var nodeCleaner = $scope.dagInfo.nodeCleaners[$scope.dagInfo.scope][node.id];
                      if (nodeCleaner && 
                          nodeCleaner.state) {
                        DAGRE_D3_HELPER.putTheStuffMan( node.id, [], [nodeCleaner.state] );
                      }
                    });
                    

                  }) // dagRestResourcePromise.then
                  .catch(function(response) {
                    console.log("Error with status code", response.status);
                  }); 
                  // 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  

                } // $scope.loadOnce = function() {
                // 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 

                $scope.loadOnce();

              }
          ]; // controller definition
          // 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 

          return {
            restrict : 'E',
            controller : controller,
            link : function($scope, $element, attr) {
              $scope.$watch(attr.ngShow, function() {
                if (!attr.ngShow) {
                  return;
                }
                if (attr.ngShow) {
                  $scope.loadOnce();
                }
              });
            }
          };

        }
      ]); // angular.module('dagsApplication').directive('dag', [function(){

  /////////////////////////////////////////////////////////////////////////////
  function gatcvs(str) {
    var _this_ = {};

    function isok(x) {
      if (typeof x === "undefined" || x === null || x.length === 0) {
        return false;
      }
      return true;
    }

    // 
    // g    Group id of the artifact (theoretically optional, but Required in practice)
    // a    Artifact id of the artifact (Required)
    // t    Type of the artifact (Required)
    // c    Classifier of the artifact (Optional)
    // v    Version of the artifact (Required)
    // s    Scope of the artifact (Optional - one of 'compile', 'provided', 'runtime', 'test', 'system', 'import')
    // 
    // [r    Repository that the artifact is contained in (Required)] <-- not needed
    // 
    // str = "g:a:t:v:p:c:e";
    // 

    // verify that parameter is fine
    // if not, return an object that containing only a 'ok' function returning false.
    if (!isok(str)) {
      _this_.ok = function() {
        return false;
      }
      return _this_;
    }

    var arr = str.split(":");

    _this_.g = arr[0];
    _this_.a = arr[1];
    _this_.t = arr[2];

    if (isok(arr[5])) {
      // everything is defined
      _this_.c = arr[3];
      _this_.v = arr[4];
      _this_.s = arr[5];
    } else {
      // at least one of max two optionals missing
      if (!isok(arr[4])) {
        // both optionals missing
        _this_.v = arr[3];
      } else {
        // only one optional missing, which one ?
        // look if arr[4] contains a scope
        var scopes = [
            'compile', 'import', 'provided', 'runtime', 'system', 'test',
        ]; // this array IS and MUST be sorted
        if (-1 == _.sortedIndexOf(scopes, arr[4])) {
          // Scope missing
          _this_.c = arr[3];
          _this_.v = arr[4];
        } else {
          // Classifier missing
          _this_.v = arr[3];
          _this_.s = arr[4];
        }
      }
    }

    _this_.ok = function() {
      var mandatories = [
          _this_.g, _this_.a, _this_.t, _this_.v
      ];
      for (j = 0; j < mandatories.length; j++) {
        if (!isok(mandatories[j])) {
          return false;
        }
      }
      _this_.v0 = _this_.v;
      return true;
    }

    return _this_;

  } // function gatcvs(str)

})();
