<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" trimDirectiveWhitespaces="true" %>
<%@ page import="net.aequologica.neo.geppaequo.webjars.WebJar" %>
<%@page import="net.aequologica.neo.dagr.DagOnSteroids"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout" %>
<%  
net.aequologica.neo.geppaequo.servlet.ZeroUtils.HostContextUserAccountAndApp(request);
%>
<%
  Boolean isWizard = request.isUserInRole("wizard") || request.isUserInRole("BUILTIN\\Administrators");
  request.setAttribute("isGeppaequoWizard", isWizard);
%>
<t:layout  jsmodules="angular modernizr datatables moment handlebars" base="/modules/dagr/" > <!-- typeahead  -->

<c:if test="${not empty requestScope.userInfo.id}">

<link rel="stylesheet" type="text/css" href="<c:url value='<%=WebJar.locate("angular-toastr.css") %>' />"></link>

<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/dags.css'        />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/graph.css'       />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/topo.css'        />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/progress.css'    />"></link>

<link rel="stylesheet" type="text/css" href="<c:url value='<%=WebJar.locate("bootstrap-switch.css") %>' />" />

<style>
.aetherInProgress {
    background: url("<c:url value='/assets/images/animated_gray_refresh_22.gif'/>") no-repeat right center;
    color: gray;
}
</style>

<style type="text/css">

[data-toggle ='tooltip'] {
  vertical-align: top;
}

.tt-query {
  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
     -moz-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
          box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
}

.tt-hint {
  color: #999
}

.tt-menu {
  width: 12rem;
  margin-top: .2rem;
  padding: 0;
  background-color: #fff;
  border: 1px solid #ccc;
  border: 1px solid rgba(0, 0, 0, 0.2);
  -webkit-border-radius: 4px;
     -moz-border-radius: 4px;
          border-radius: 4px;
  -webkit-box-shadow: 0 5px 10px rgba(0,0,0,.2);
     -moz-box-shadow: 0 5px 10px rgba(0,0,0,.2);
          box-shadow: 0 5px 10px rgba(0,0,0,.2);
}

.tt-suggestion {
  padding: 3px 20px;
  line-height: 24px;
}

.tt-suggestion.tt-cursor,.tt-suggestion:hover {
  color: #fff;
  background-color: #0097cf;

}

.tt-suggestion p {
  margin: 0;
}
</style>

</c:if> <%-- no user --%>
 
<c:if test="${empty requestScope.userInfo.id}">
<section id="login">
  <a href='<c:url value="/modules/login.jsp"/>#/api/dagr/v1/views/dags'
     role="button" 
     class="btn btn-sm btn-outline-primary">
     <span><i class="shaky fas fa-sign-in-alt"></i>&nbsp;Sign in</span>
  </a>
</section>
</c:if>

<c:if test="${not empty requestScope.userInfo.id}">
<div id="container" ng-app="dagsApplication">

  <section ng-controller="dagInfoController">

    <div ng-hide="dagInfo">
        <c:if test='${model.warning == null}'>
        <h1>No DAG found</h1>
        </c:if>
        <c:if test='${model.warning != null}'>
        <div class="alert alert-warning" role="alert">${model.warning}</div>
        </c:if>
        <c:if test='${model.exception != null}'>
        <div class="alert alert-danger" role="alert">${model.exception}</div>
        </c:if>
        <div><a href="<c:url value='/modules/dagr/dag-list.jsp'/>">DAG list</a></div>
    </div>
    <dag ng-show="dagInfo">
        <div>
          <form id    = "dagToolbar" 
                class = "shorttoolbar toolbar toprightfloating"> 
            <span id          = "tip"
                  style       = "display:none; color: black; font-size:smaller;"
                  class       = "alert alert-info">
            </span>
            <button ng-show   = "{{dagInfo.thisIsASub}}"
                  id        = "saveSub" 
                  data-tip    = "save sub-graph"
                  type        = "button" 
                  class       = "tip btn btn-outline-secondary btn-sm btn-outline-secondary"
                  ng-click    = "saveSubGraph()">
              <i class="shaky fas fa-save"></i>
            </button>
            <button id        = "toggleSVG" 
                  data-tip    = "toggle svg display"
                  type        = "button" 
                  class       = "tip btn btn-outline-secondary btn-sm btn-outline-secondary"
                  ng-click    = "toggleSVG()">
              <i class="shaky far fa-file-image" ></i>
            </button>
            <button id        = "nodeNameVariantLegend" 
                  data-tip    = ""
                  type        = "button" 
                  class       = "tip btn btn-outline-secondary btn-sm btn-outline-secondary"
                  ng-click    = "bumpNodeNameVariantIndex()">
              <i class="shaky fas {{node_name_variant_icons[node_name_variant_index]}}" ></i>
            </button>
            <button ng-hide   = "{{hideOnOffLine}}"
                  id          = "online" 
                  data-tip    = "{{connection ? '<b>online</b> / <span>offline</span>' : 'online / <span><b>offline</b></span>'}}"
                  type        = "button" 
                  class       = "connection {{connection ? 'on' : 'off'}} tip btn btn-outline-secondary btn-sm btn-outline-secondary"
                  ng-click    = "toggleConnection()">
              <i class="shaky fas {{connection ? 'fa-link' : 'fa-unlink'}}" ></i>
            </button>
            <button id        = "reloadDAG" 
                  data-tip    = "reload  /<i>{{dagInfo.name}}</i>/ dag"
                  type        = "button" 
                  class       = "tip btn btn-outline-secondary btn-sm btn-outline-secondary"
                  data-id     = "{{dagInfo.name}}" 
                  ng-click    = "reloadDAG()">
              <i class="shaky fas fa-sync" ></i>
            </button>
            <button id        = "download" 
                  data-tip    = "download /<i>{{dagInfo.name}}</i>/ dag"
                  type        = "button" 
                  class       = "tip btn btn-outline-secondary btn-sm btn-outline-secondary"
                  data-id     = "{{dagInfo.name}}" 
                  ng-click    = "downloadDAG()">
              <i class="shaky fas fa-download"></i>
            </button>
          </form>
        </div>
        
        <div style="margin:0 0 .5rem 0; display:inline-block;">
          <h3 id="daglabel">
            <span>{{dagInfo.label}}</span>
            <span class="btn-group" style="font-size:16px;">
              <button   type            = "button" 
                        class           = "btn btn-sm btn-outline-secondary dropdown-toggle" 
                        data-toggle     = "dropdown" 
                        aria-haspopup   = "true" 
                        aria-expanded   = "false" 
                        style           = "padding-left: .2rem;">
              </button>
              <span class="dropdown-menu">
              </span>
            </span>
          </h3>
          <span style="font-size:11px; color:darkgray;">
              <a ng-show="dag.value.giturl.url" href = "{{dag.value.giturl.url}}" target = "scm" title="{{dag.value.giturl.shortMessage}}">{{dag.value.giturl.hash}}</a>
              <span ng-hide="dag.value.giturl.url" title="{{dag.value.giturl.shortMessage}}">{{dag.value.giturl.hash}}</span>
              <span>{{dagInfo.date || "∅"}}</span>
          </span>
        </div>
        
        <c:if test='${model.warning != null}'>
        <div class="alert alert-warning" role="alert">${model.warning}</div>
        </c:if>

        <dag-svg id="theDagSVG" resize ng-hide="dagInfo.hideSVG"></dag-svg>
        
        <c:if test='${isGeppaequoWizard}'>
        <dag-cleaner ng-hide="hideCleaner"></dag-cleaner>
        </c:if>

        <dag-topological></dag-topological>
        
        <dag-websocket></dag-websocket>

        <dag-websocket2></dag-websocket2>

    </dag>
  
  </section>
</div>
</c:if>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("d3.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dagre-d3.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/angular-websocket.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/restangular.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("ui-bootstrap-tpls.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("angular-bootstrap-confirm.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/js/bootstrap-switch.min.js")%>' />" ></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("angular-bootstrap-switch.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("angular-toastr.tpls.js")%>' />"></script>


<%--
<script async="" src="https://cdn.rawgit.com/eligrey/Blob.js/0cef2746414269b16834878a8abc52eb9d53e6bd/Blob.js"/>
<script async="" src="https://cdn.rawgit.com/eligrey/canvas-toBlob.js/f1a01896135ab378aa5c0118eadd81da55e698d8/canvas-toBlob.js"/>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("FileSaver.js")%>' />"></script>
--%>

<script type="text/javascript" charset="utf8" src="<c:url value='/assets/scripts/url.js'/>" ></script>

<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/giturl.ct.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dagre-d3-helper.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dags.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-directive.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-version.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-websocket-directive.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-websocket-directive2.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/node-progress-directive.js' />"></script>


<script type="module">

"use strict";

import * as _fileSaver_ from "<c:url value='<%=WebJar.locate("FileSaver.js")%>' />";
import battement from "<c:url value='/scripts/canvas-battement.js' />";

<%-- cf. https://github.com/cpettitt/dagre-d3/issues/202 --%>
SVGElement.prototype.getTransformToElement = SVGElement.prototype.getTransformToElement || function(elem) {
  return elem.getScreenCTM().inverse().multiply(this.getScreenCTM());
};

var getNodeNameVariantLegend;

(function(){
  angular.module('dagsApplication').controller('dagInfoController', 
      [        '$scope', 'localStorageService', 'loadAllDagsService', 'Restangular', 'AetherRestangular', '$timeout', '$sce', 
       function($scope ,  localStorageService ,  loadAllDagsService,   Restangular,   AetherRestangular,   $timeout,   $sce) {

    // utility
    function formatDate(theDate) {
      return theDate ? moment.utc(theDate).format("dddd, MMMM Do YYYY, H:mm z") : '';
    }
        
    $scope.saveAs = _fileSaver_.saveAs;
    // ------------------------- from java to javascript ------------------------- 

    $scope.nodeStates    = "<%= java.util.EnumSet.allOf( net.aequologica.neo.dagr.DagOnSteroids.NodeCleaner.NodeState.class )%>".replace(/[\[\]]/g, "").split(', ').sort();
    $scope.busEventTypes = "<%= java.util.EnumSet.allOf( net.aequologica.neo.dagr.bus.BusEvent.Type.class ) %>".replace(/[\[\]]/g, "").split(', ').sort();
    $scope.scopeJOB      = "<%= net.aequologica.neo.dagr.Scope.JOB.toString()%>";
    $scope.scopeRELEASE  = "<%= net.aequologica.neo.dagr.Scope.RELEASE.toString()%>";

    $scope.magicien = false;
    <c:if test='${isGeppaequoWizard}'>
       $scope.magicien = true;
       $scope.websocket_magicien = false;
    </c:if>
    
    // ------ from java to javascript most inportant thingy : dagInfo ------------------------- 
    // dagInfo
    var dagInfos = [<c:forEach items="${model.infos}" var="_dagInfo_" varStatus="status">
      {
        id            : 'dag_${status.count}',
        name          : '${_dagInfo_.name}',
        label         : '<c:if test="${empty _dagInfo_.label}">${_dagInfo_.name}</c:if><c:if test="${not empty _dagInfo_.label}">${_dagInfo_.label}</c:if>',
        downloadURL   : '<c:url value="/api/dagr/v1/dags/${_dagInfo_.name}"/>',
        reloadInfoURL : '<c:url value="/api/dagr/v1/dags/${_dagInfo_.name}/info"/>',
        source        : '${_dagInfo_.url}',
        subDagId      : '${_dagInfo_.subDagId}',
        with_         : '${param.with}',
        date          : formatDate('${_dagInfo_.date}'),

        ////////// BEGIN cleaner
        scope : "JOB",
        cleaner       : {
          <c:forEach items="${_dagInfo_.cleanerProperties}" var="entry"> ${entry.key}: '${entry.value}',
          </c:forEach>
          _nameTemplates_  : {
            <c:forEach items="${_dagInfo_.nameTemplates}" var="entry"> ${entry.key}: Handlebars.compile('${entry.value}'),
            </c:forEach>
          },
        },
        nodeCleaners : {
          <c:forEach items="${_dagInfo_.scopedNodeCleaners}" var="entry"> ${entry.key}: {
            <c:forEach items="${entry.value}" var="nc"> ${nc.key}: { state : '${nc.value.state}' }, 
            </c:forEach>
            },
          </c:forEach>
        },
        ////////// END cleaner
      },</c:forEach>
    ];
    
    dagInfos.sort(function(a, b) {
      // cf. http://stackoverflow.com/questions/51165/how-do-you-do-string-comparison-in-javascript
      return a.name.localeCompare(b.name);
    });

    // ------------------------- select dagInfo ------------------------- 
    var curdag = localStorageService.get("dag");
    
    var dagInfo = _.find(dagInfos, function(dagInfo) { return dagInfo.name == curdag; });
    
    if (!dagInfo && dagInfos.length > 0) {
      dagInfo = dagInfos[0];
    }

    if (!dagInfo) {
      $scope.dagInfo = undefined;
      localStorageService.remove("dag");
      return;
    } 

    // ------------------------- habemus dagInfo ------------------------- 
    // vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

    // init dagInfo 
    (function initDagInfo(di){

      di.parseCleanerURL = function () {
        if (di.cleaner) {
          di.cleaner.urlobj = {host:undefined}; // in case anything goes wrong
          if (di.cleaner.url) {
            try {
              di.cleaner.urlobj = new URL(di.cleaner.url);
            } catch(err) {
                // window.log("cannot parse as URL, fallback on non-parsed value", di.cleaner.url, err);
                di.cleaner.urlobj = {host:di.cleaner.url};
            }
          }
        }  
      }
      di.parseCleanerURL ();

      di.createBumper = function () {
        if (di.cleaner && di.cleaner.bumps) {
          var bumps = JSON.parse(di.cleaner.bumps);
          di.cleaner.bumper = {
            getBumpForNode : function(nodeName) {
              if (!bumps) return "PATCH";
              if (!nodeName) return "PATCH";
              if (bumps.major) {
                var has = false;
                if (_.isArray(bumps.major)) {
                  has = _.includes(bumps.major, nodeName);
                } else {
                  has = nodeName.match(bumps.major);
                }
                if (has) return "MAJOR";
              }
              if (bumps.minor) {
                var has = false;
                if (_.isArray(bumps.minor)) {
                  has = _.includes(bumps.minor, nodeName);
                } else {
                  has = nodeName.match(bumps.minor);
                }
                if (has) return "MINOR";
              }
              return "PATCH";
            }
          }
        }
      }
      di.createBumper();

      // NOT FINISHED
      di.reload = function () {
        alert("dagInfo reload not yet finished - doing my best");
      };

      di.syncBattement = function(scope) {
        var scopeState = Restangular.one('dags',  di.name)
                                    .one('buses', di.scope);
        scopeState.get().then(
          function(response) { 
            // window.log(response);
            if (response && response == "RUNNING") {
                $scope.battement.controller('start');
            } else {
                $scope.battement.controller('stop');
            }
          }, function(response) {
            // window.log(response);
            $scope.battement.controller('stop');
          }
        );
      };

      di.onChangeCleanerScope = function() {
        // window.log("cleaner scope changed", di.scope);
        localStorageService.set(di.name+".scope", di.scope);
        _.forOwn(di.nodeCleaners[di.scope], function(nodeCleaner, nodeId) { 
          DAGRE_D3_HELPER.putTheStuffMan(nodeId, $scope.nodeStates, [nodeCleaner.state]);
        });

        di.syncBattement(di.scope);
      };
      
      localStorageService.set("dag", di.name);

      var cursco = localStorageService.get(di.name+".scope");
      if (!cursco || (cursco!="JOB" && cursco!="RELEASE")) {
        di.scope = "JOB";
      } else {
        di.scope = cursco;
      }
      
      di.thisIsNotASub = typeof di.subDagId              !== "string" || 
                                di.subDagId               ==  null     || 
                                di.subDagId.trim().length == 0;
      di.thisIsASub    = !di.thisIsNotASub;

    })(dagInfo);
    
    $scope.dagInfo = dagInfo;
    
    // https://stackoverflow.com/a/37898793/1070215
    $scope.showInput = false;
    $scope.toggleShowInput = function() {
      /*
      if ($scope.magicien) {
        $scope.showInput = !$scope.showInput;
      }
      */
    };
    $scope.inputUndo = function() {
      console.log("to do !");
    };
    
    // fill dags dropdown thru a worker - fancy, isn't it ?
    (function fillDropdown(){
      loadAllDagsService.doWork();
      $('h3#daglabel .dropdown-toggle').dropdownHover();
    })();
 
    // prepare aether requests
    (function prepareAetherRequests(SCOPE){
      var snapshotServer = {
          name        : "${applicationScope.quintessence.snapshotRepo.name}",
          baseURL     : "${applicationScope.quintessence.snapshotRepo.uri}"
      };
      var releaseServer = {
          name        : "${applicationScope.quintessence.releaseRepo.name}",
          baseURL     : "${applicationScope.quintessence.releaseRepo.uri}"
      };
        
      SCOPE.snapshotServer = snapshotServer;
      SCOPE.releaseServer  = releaseServer;
      
      if (!snapshotServer.name || !releaseServer.name) {
        SCOPE.hideOnOffLine = true;
      }
      
      SCOPE.connection       = localStorageService.get('connection');
      SCOPE.toggleConnection = function() {
        SCOPE.connection = !SCOPE.connection;
        localStorageService.set('connection', SCOPE.connection);
        location.reload(); 
      };

      SCOPE.refreshSnapshot = function(node) {
        if (!SCOPE.connection || !SCOPE.snapshotServer.name) {
          return;
        }
        node.resolvingSnapshot = "aetherInProgress";
        $timeout(function() { // give some time to angular to refresh the background
          var snapshotRes = AetherRestangular.one('repositories', SCOPE.snapshotServer.name)
                                              .one('groups'      , node.gav.g                )
                                              .one('artifacts'   , node.gav.a                )
                                              .one('versions'    , '[,)'                     )
                                              .one('extensions'  , 'pom'                     );

          snapshotRes.get().then(function(aetherJson) {
            node.resolvingSnapshot = "";
            node.resolvedSnapshot = $sce.trustAsHtml(aetherJson.version);
          }, function(response) {
            node.resolvingSnapshot = "";
            // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
            node.resolvedSnapshot = $sce.trustAsHtml("&#8709;");
          });
        }, 1000);
      }

      SCOPE.refreshRelease = function(node) {
        if (!SCOPE.connection || !SCOPE.releaseServer.name) {
          return;
        }
        node.resolvingRelease = "aetherInProgress";
        $timeout(function() { // give some time to angular to refresh the background
          var releaseRes = AetherRestangular.one('repositories' , SCOPE.releaseServer.name )
                                            .one('groups'       , node.gav.g                )
                                            .one('artifacts'    , node.gav.a                )
                                            .one('versions'     , '[,)'                     )
                                            .one('extensions'   , 'pom'                     );

          releaseRes.get().then(function(aetherJson) {
            node.resolvingRelease = "";
            node.resolvedRelease = $sce.trustAsHtml(aetherJson.version);
          }, function(response) {
            node.resolvingRelease = "";
            // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
            node.resolvedRelease = $sce.trustAsHtml("&#8709;");
          });
        }, 1000);
      }

    })($scope);

    // prepare build vignettes
    (function prepareVignettes(SCOPE){
      SCOPE.clean_passing_svg_url       = '<c:url value="/modules/dagr/images/clean_passing.svg"    />';
      SCOPE.clean_failing_svg_url       = '<c:url value="/modules/dagr/images/clean_failing.svg"    />';
      SCOPE.clean_aborted_svg_url       = '<c:url value="/modules/dagr/images/clean_aborted.svg"    />';
      SCOPE.clean_uncleanable_svg_url   = '<c:url value="/modules/dagr/images/clean_uncleanable.svg"/>';
      SCOPE.clean_unknown_svg_url       = '<c:url value="/modules/dagr/images/clean_unknown.svg"    />';
    })($scope);

    // prepare node name variants
    (function prepareNodeNameVariants(SCOPE){
      SCOPE.node_name_variant_icons = [ "fa-minus",
                                        "fa-plus",
                                        "fa-asterisk" ];
      SCOPE.node_name_variant_legend = ["( <b>short -</b> | medium + | full * ) label",
                                        "( short - | <b>medium +</b> | full * ) label",
                                        "( short - | medium + | <b>full *</b> ) label" ];
      
      var node_name_variant_index = localStorageService.get('node_name_variant_index');
      if (typeof node_name_variant_index === "undefined" || node_name_variant_index == null) {
          node_name_variant_index = 0;
      }
      SCOPE.node_name_variant_index = node_name_variant_index % SCOPE.node_name_variant_icons.length;
      SCOPE.getNodeNameVariantLegend = getNodeNameVariantLegend = function() {
        return  SCOPE.node_name_variant_legend[ SCOPE.node_name_variant_index];
      }
      
      SCOPE.bumpNodeNameVariantIndex = function() {
      SCOPE.node_name_variant_index = (SCOPE.node_name_variant_index + 1) % SCOPE.node_name_variant_icons.length;
        localStorageService.set('node_name_variant_index', SCOPE.node_name_variant_index);
      }
    })($scope);
    
    // prepare svg show/hide
    (function prepareSVGToggle(SCOPE){
      var hideSVG = localStorageService.get('hideSVG');
      if (typeof hideSVG !== "undefined" && hideSVG != null && hideSVG) {
        SCOPE.dagInfo.hideSVG = true;
      } else {
        SCOPE.dagInfo.hideSVG = false;
      }

      SCOPE.toggleSVG = function() {
        SCOPE.dagInfo.hideSVG = !SCOPE.dagInfo.hideSVG;
        localStorageService.set('hideSVG', SCOPE.dagInfo.hideSVG);
      }
    })($scope);

    // define
    (function defineSaveSubGraph(SCOPE){
      SCOPE.saveSubGraph = function() {
        localStorageService.set('subgraphs', SCOPE.dagInfo.subDagId);
        var url = Geppaequo.contextPath
                  + 'api/dagr/v1/dags/'
                  + SCOPE.dagInfo.name
                  + '/subs/' 
                  + SCOPE.dagInfo.subDagId
                  + '/description/' 
                  + 'sub';
        // window.log(url);
        $.ajax({
            url:          url,
            type:         'POST',
            cache:        false,
            contentType:  false,
            processData:  false
          }).done(function( data, textStatus, jqXHR ) {
            alert('sub dag saved to ' + data.replace(/\\/g, '/'));
          }).fail(function( jqXHR, textStatus, errorThrown ) {
            alert(textStatus, errorThrown);
          }).always(function( data_jqXHR, textStatus, jqXHR_errorThrown ) {
            // window.log("always");
        });
      }
    })($scope);

  }]);
  
  angular.module('dagsApplication').factory('theContext', [ function() {
    var jevaispasmefairechier = '<c:if test="${pageContext.request.secure}">s</c:if>://${pageContext.request.serverName}:${pageContext.request.serverPort}'+Geppaequo.contextPath;
    return {
      battement                 : battement,
      jevaispasmefairechierWS   : 'ws'   + jevaispasmefairechier,
      jevaispasmefairechierHTTP : 'http' + jevaispasmefairechier,
      /////////////////////////////////////////////////////////////////////////////
      // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
      tryParseJSON : function tryParseJSON(hypotheticalJSON) {
        try {
          var o = JSON.parse(hypotheticalJSON);

          // Handle non-exception-throwing cases:
          // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
          // but... JSON.parse(null) returns 'null', and typeof null === "object", 
          // so we must check for that, too.
          if (o && typeof o === "object" && o !== null) {
            return o;
          }
        } catch (e) {
        }

        return false;
      }
    };
  }]);
      
  
  // http://stackoverflow.com/a/16730809/1070215
  angular.module('dagsApplication').factory("loadAllDagsService",['$q',function($q){

    var worker = new Worker('<c:url value="/modules/dagr/scripts/"/>'+'load-all-dags-worker.js');
    var defer = $q.defer();
    worker.addEventListener('message', function(e) {
      // console.log('Worker said: ', e.data);
      var $dm = $('h3#daglabel .dropdown-menu');
      $dm.empty();
      e.data.sort(function(a, b) {
        // cf. http://stackoverflow.com/questions/51165/how-do-you-do-string-comparison-in-javascript
        return a.name.localeCompare(b.name);
      });
      
      _.forEach(e.data, function(dagInfo) {
        $dm.append($('<a class="dropdown-item">').attr({href:"<c:url value='/api/dagr/v1/views/dags/'/>"+dagInfo.name}).text(dagInfo.label || dagInfo.name));
      });
      defer.resolve(e.data);
    }, false);

    return {
        doWork : function(){
            defer = $q.defer();
            worker.postMessage({
              url : "<c:url value='/api/dagr/v1/dags' />"
            }); // Send data to our worker. 
            return defer.promise;
        }
    };
  }]);
  
  $(document).ready(function(){
    // tooltips
    $('form.shorttoolbar#dagToolbar [id="nodeNameVariantLegend"]').on( 'click', function() {
      $('form.shorttoolbar#dagToolbar span#tip').html(getNodeNameVariantLegend());
    });
    var $tip = $('form.shorttoolbar#dagToolbar span#tip');
    $('form.shorttoolbar#dagToolbar [type="button"].tip').hover(
        function() {
          if ($(this).attr('id') == "nodeNameVariantLegend") {
            $tip.html(getNodeNameVariantLegend());
          } else {
            $tip.html($(this).data("tip"));
          }
          $tip.show();
        }, function() {
          $tip.empty().hide();
        }
    );
    
    $('#toggleSocketIFrame').on('click', function(event){
      event.preventDefault();
      $('#dagsocket').toggle();
    })
  });
    
})();

</script>

<script type="text/javascript">
</script>
